/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.kernel.impl.newapi.DefaultCursors;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.kernel.impl.store.GeometryType;
import org.neo4j.kernel.impl.store.LongerShortString;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.ShortArray;
import org.neo4j.kernel.impl.store.TemporalType;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.util.Bits;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.txstate.PropertyContainerState;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.ByteValue;
import org.neo4j.values.storable.DoubleValue;
import org.neo4j.values.storable.FloatValue;
import org.neo4j.values.storable.IntValue;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.ShortValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;

public class DefaultPropertyCursor
extends PropertyRecord
implements PropertyCursor {
    private static final int MAX_BYTES_IN_SHORT_STRING_OR_SHORT_ARRAY = 32;
    private static final int INITIAL_POSITION = -1;
    private Read read;
    private long next;
    private int block;
    ByteBuffer buffer;
    private PageCursor page;
    private PageCursor stringPage;
    private PageCursor arrayPage;
    private PropertyContainerState propertiesState;
    private Iterator<StorageProperty> txStateChangedProperties;
    private StorageProperty txStateValue;
    private AssertOpen assertOpen;
    private final DefaultCursors pool;

    DefaultPropertyCursor(DefaultCursors pool) {
        super(-1L);
        this.pool = pool;
    }

    void initNode(long nodeReference, long reference, Read read, AssertOpen assertOpen) {
        assert (nodeReference != -1L);
        this.init(reference, read, assertOpen);
        if (read.hasTxStateWithChanges()) {
            this.propertiesState = read.txState().getNodeState(nodeReference);
            this.txStateChangedProperties = this.propertiesState.addedAndChangedProperties();
        }
    }

    void initRelationship(long relationshipReference, long reference, Read read, AssertOpen assertOpen) {
        assert (relationshipReference != -1L);
        this.init(reference, read, assertOpen);
        if (read.hasTxStateWithChanges()) {
            this.propertiesState = read.txState().getRelationshipState(relationshipReference);
            this.txStateChangedProperties = this.propertiesState.addedAndChangedProperties();
        }
    }

    void initGraph(long reference, Read read, AssertOpen assertOpen) {
        this.init(reference, read, assertOpen);
        if (read.hasTxStateWithChanges()) {
            this.propertiesState = read.txState().getGraphState();
            if (this.propertiesState != null) {
                this.txStateChangedProperties = this.propertiesState.addedAndChangedProperties();
            }
        }
    }

    private void init(long reference, Read read, AssertOpen assertOpen) {
        if (this.getId() != -1L) {
            this.clear();
        }
        this.assertOpen = assertOpen;
        this.block = Integer.MAX_VALUE;
        this.read = read;
        if (reference != -1L && this.page == null) {
            this.page = read.propertyPage(reference);
        }
        this.next = reference;
    }

    public boolean next() {
        boolean hasNext;
        while ((hasNext = this.innerNext()) && !this.allowed(this.propertyKey())) {
        }
        return hasNext;
    }

    private boolean allowed(int propertyKey) {
        return this.read.ktx.securityContext().mode().allowsPropertyReads(propertyKey);
    }

    private boolean innerNext() {
        if (this.txStateChangedProperties != null) {
            if (this.txStateChangedProperties.hasNext()) {
                this.txStateValue = this.txStateChangedProperties.next();
                return true;
            }
            this.txStateChangedProperties = null;
            this.txStateValue = null;
        }
        while (true) {
            int numberOfBlocks = this.getNumberOfBlocks();
            while (this.block < numberOfBlocks) {
                if (this.block == -1) {
                    this.block = 0;
                } else {
                    long current = this.currentBlock();
                    PropertyType type = PropertyType.getPropertyTypeOrNull(current);
                    if (type == null) break;
                    this.block += type.calculateNumberOfBlocksUsed(current);
                }
                if (this.block >= numberOfBlocks || this.type() == null) break;
                if (this.isPropertyChangedOrRemoved()) continue;
                return true;
            }
            if (this.next == -1L) {
                return false;
            }
            this.read.property(this, this.next, this.page);
            this.next = this.getNextProp();
            this.block = -1;
        }
    }

    private boolean isPropertyChangedOrRemoved() {
        return this.propertiesState != null && this.propertiesState.isPropertyChangedOrRemoved(this.propertyKey());
    }

    private long currentBlock() {
        return this.getBlocks()[this.block];
    }

    public void close() {
        if (!this.isClosed()) {
            this.propertiesState = null;
            this.txStateChangedProperties = null;
            this.txStateValue = null;
            this.read = null;
            this.clear();
            this.pool.accept(this);
        }
    }

    public int propertyKey() {
        if (this.txStateValue != null) {
            return this.txStateValue.propertyKeyId();
        }
        return PropertyBlock.keyIndexId(this.currentBlock());
    }

    public ValueGroup propertyType() {
        if (this.txStateValue != null) {
            return this.txStateValue.value().valueGroup();
        }
        PropertyType type = this.type();
        if (type == null) {
            return ValueGroup.NO_VALUE;
        }
        switch (type) {
            case BOOL: {
                return ValueGroup.BOOLEAN;
            }
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return ValueGroup.NUMBER;
            }
            case STRING: 
            case CHAR: 
            case SHORT_STRING: {
                return ValueGroup.TEXT;
            }
            case TEMPORAL: 
            case GEOMETRY: 
            case SHORT_ARRAY: 
            case ARRAY: {
                return this.propertyValue().valueGroup();
            }
        }
        throw new UnsupportedOperationException(type.name() + " not implemented");
    }

    private PropertyType type() {
        return PropertyType.getPropertyTypeOrNull(this.currentBlock());
    }

    public Value propertyValue() {
        if (this.txStateValue != null) {
            return this.txStateValue.value();
        }
        Value value = this.readValue();
        this.assertOpen.assertOpen();
        return value;
    }

    private Value readValue() {
        PropertyType type = this.type();
        if (type == null) {
            return Values.NO_VALUE;
        }
        switch (type) {
            case BOOL: {
                return this.readBoolean();
            }
            case BYTE: {
                return this.readByte();
            }
            case SHORT: {
                return this.readShort();
            }
            case INT: {
                return this.readInt();
            }
            case LONG: {
                return this.readLong();
            }
            case FLOAT: {
                return this.readFloat();
            }
            case DOUBLE: {
                return this.readDouble();
            }
            case CHAR: {
                return this.readChar();
            }
            case SHORT_STRING: {
                return this.readShortString();
            }
            case SHORT_ARRAY: {
                return this.readShortArray();
            }
            case STRING: {
                return this.readLongString();
            }
            case ARRAY: {
                return this.readLongArray();
            }
            case GEOMETRY: {
                return this.geometryValue();
            }
            case TEMPORAL: {
                return this.temporalValue();
            }
        }
        throw new IllegalStateException("Unsupported PropertyType: " + type.name());
    }

    Value geometryValue() {
        return GeometryType.decode(this.getBlocks(), this.block);
    }

    Value temporalValue() {
        return TemporalType.decode(this.getBlocks(), this.block);
    }

    private ArrayValue readLongArray() {
        long reference = PropertyBlock.fetchLong(this.currentBlock());
        if (this.arrayPage == null) {
            this.arrayPage = this.read.arrayPage(reference);
        }
        return this.read.array(this, reference, this.arrayPage);
    }

    private TextValue readLongString() {
        long reference = PropertyBlock.fetchLong(this.currentBlock());
        if (this.stringPage == null) {
            this.stringPage = this.read.stringPage(reference);
        }
        return this.read.string(this, reference, this.stringPage);
    }

    private Value readShortArray() {
        Bits bits = Bits.bits(32);
        int blocksUsed = ShortArray.calculateNumberOfBlocksUsed(this.currentBlock());
        for (int i = 0; i < blocksUsed; ++i) {
            bits.put(this.getBlocks()[this.block + i]);
        }
        return ShortArray.decode(bits);
    }

    private TextValue readShortString() {
        return LongerShortString.decode(this.getBlocks(), this.block, LongerShortString.calculateNumberOfBlocksUsed(this.currentBlock()));
    }

    private TextValue readChar() {
        return Values.charValue((char)((char)PropertyBlock.fetchShort(this.currentBlock())));
    }

    private DoubleValue readDouble() {
        return Values.doubleValue((double)Double.longBitsToDouble(this.getBlocks()[this.block + 1]));
    }

    private FloatValue readFloat() {
        return Values.floatValue((float)Float.intBitsToFloat(PropertyBlock.fetchInt(this.currentBlock())));
    }

    private LongValue readLong() {
        if (PropertyBlock.valueIsInlined(this.currentBlock())) {
            return Values.longValue((long)(PropertyBlock.fetchLong(this.currentBlock()) >>> 1));
        }
        return Values.longValue((long)this.getBlocks()[this.block + 1]);
    }

    private IntValue readInt() {
        return Values.intValue((int)PropertyBlock.fetchInt(this.currentBlock()));
    }

    private ShortValue readShort() {
        return Values.shortValue((short)PropertyBlock.fetchShort(this.currentBlock()));
    }

    private ByteValue readByte() {
        return Values.byteValue((byte)PropertyBlock.fetchByte(this.currentBlock()));
    }

    private BooleanValue readBoolean() {
        return Values.booleanValue((PropertyBlock.fetchByte(this.currentBlock()) == 1 ? 1 : 0) != 0);
    }

    public <E extends Exception> void writeTo(ValueWriter<E> target) {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean booleanValue() {
        throw new UnsupportedOperationException("not implemented");
    }

    public String stringValue() {
        throw new UnsupportedOperationException("not implemented");
    }

    public long longValue() {
        throw new UnsupportedOperationException("not implemented");
    }

    public double doubleValue() {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean valueEqualTo(long value) {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean valueEqualTo(double value) {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean valueEqualTo(String value) {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean valueMatches(Pattern regex) {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean valueGreaterThan(long number) {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean valueGreaterThan(double number) {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean valueLessThan(long number) {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean valueLessThan(double number) {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean valueGreaterThanOrEqualTo(long number) {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean valueGreaterThanOrEqualTo(double number) {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean valueLessThanOrEqualTo(long number) {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean valueLessThanOrEqualTo(double number) {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean isClosed() {
        return this.read == null;
    }

    @Override
    public String toString() {
        if (this.isClosed()) {
            return "PropertyCursor[closed state]";
        }
        return "PropertyCursor[id=" + this.getId() + ", open state with: block=" + this.block + ", next=" + this.next + ", underlying record=" + super.toString() + " ]";
    }

    public void release() {
        if (this.stringPage != null) {
            this.stringPage.close();
            this.stringPage = null;
        }
        if (this.arrayPage != null) {
            this.arrayPage.close();
            this.arrayPage = null;
        }
        if (this.page != null) {
            this.page.close();
            this.page = null;
        }
    }
}

