/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.LocalDateTimeSchemaKey;
import org.neo4j.kernel.impl.index.schema.SchemaLayout;

class LocalDateTimeLayout
extends SchemaLayout<LocalDateTimeSchemaKey> {
    LocalDateTimeLayout() {
        super("Tld", 0, 1);
    }

    public LocalDateTimeSchemaKey newKey() {
        return new LocalDateTimeSchemaKey();
    }

    public LocalDateTimeSchemaKey copyKey(LocalDateTimeSchemaKey key, LocalDateTimeSchemaKey into) {
        into.epochSecond = key.epochSecond;
        into.nanoOfSecond = key.nanoOfSecond;
        into.setEntityId(key.getEntityId());
        into.setCompareId(key.getCompareId());
        return into;
    }

    public int keySize(LocalDateTimeSchemaKey key) {
        return 20;
    }

    public void writeKey(PageCursor cursor, LocalDateTimeSchemaKey key) {
        cursor.putLong(key.epochSecond);
        cursor.putInt(key.nanoOfSecond);
        cursor.putLong(key.getEntityId());
    }

    public void readKey(PageCursor cursor, LocalDateTimeSchemaKey into, int keySize) {
        into.epochSecond = cursor.getLong();
        into.nanoOfSecond = cursor.getInt();
        into.setEntityId(cursor.getLong());
    }
}

