/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.kernel.impl.index.schema.NativeSchemaKey;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.Value;

class DateSchemaKey
extends NativeSchemaKey<DateSchemaKey> {
    static final int SIZE = 16;
    long epochDay;

    DateSchemaKey() {
    }

    @Override
    public Value asValue() {
        return DateValue.epochDate((long)this.epochDay);
    }

    @Override
    void initValueAsLowest() {
        this.epochDay = Long.MIN_VALUE;
    }

    @Override
    void initValueAsHighest() {
        this.epochDay = Long.MAX_VALUE;
    }

    @Override
    public int compareValueTo(DateSchemaKey other) {
        return Long.compare(this.epochDay, other.epochDay);
    }

    public String toString() {
        return String.format("value=%s,entityId=%d,epochDay=%d", this.asValue(), this.getEntityId(), this.epochDay);
    }

    @Override
    public void writeDate(long epochDay) {
        this.epochDay = epochDay;
    }

    @Override
    protected Value assertCorrectType(Value value) {
        if (!(value instanceof DateValue)) {
            throw new IllegalArgumentException("Key layout does only support DateValue, tried to create key from " + value);
        }
        return value;
    }
}

