/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongObjectMap;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.api.exceptions.index.IndexActivationFailedKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.exceptions.schema.UniquePropertyValueValidationException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.api.SchemaState;
import org.neo4j.kernel.impl.api.index.IndexMap;
import org.neo4j.kernel.impl.api.index.IndexMapReference;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexPopulationJob;
import org.neo4j.kernel.impl.api.index.IndexPopulationJobController;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxyCreator;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.IndexUpdaterMap;
import org.neo4j.kernel.impl.api.index.IndexingUpdateService;
import org.neo4j.kernel.impl.api.index.MultiPopulatorFactory;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.NodeUpdates;
import org.neo4j.kernel.impl.api.index.RebuildingIndexDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingController;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingMode;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.transaction.state.IndexUpdates;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.values.storable.Value;

public class IndexingService
extends LifecycleAdapter
implements IndexingUpdateService {
    private final IndexSamplingController samplingController;
    private final IndexProxyCreator indexProxyCreator;
    private final IndexStoreView storeView;
    private final IndexProviderMap providerMap;
    private final IndexMapReference indexMapRef;
    private final Iterable<IndexRule> indexRules;
    private final Log log;
    private final TokenNameLookup tokenNameLookup;
    private final MultiPopulatorFactory multiPopulatorFactory;
    private final LogProvider logProvider;
    private final Monitor monitor;
    private final SchemaState schemaState;
    private final IndexPopulationJobController populationJobController;
    private final Map<Long, IndexProxy> indexesToDropAfterCompletedRecovery = new HashMap<Long, IndexProxy>();
    public static final Monitor NO_MONITOR = new MonitorAdapter();
    private volatile State state = State.NOT_STARTED;

    IndexingService(IndexProxyCreator indexProxyCreator, IndexProviderMap providerMap, IndexMapReference indexMapRef, IndexStoreView storeView, Iterable<IndexRule> indexRules, IndexSamplingController samplingController, TokenNameLookup tokenNameLookup, JobScheduler scheduler, SchemaState schemaState, MultiPopulatorFactory multiPopulatorFactory, LogProvider logProvider, Monitor monitor) {
        this.indexProxyCreator = indexProxyCreator;
        this.providerMap = providerMap;
        this.indexMapRef = indexMapRef;
        this.storeView = storeView;
        this.indexRules = indexRules;
        this.samplingController = samplingController;
        this.tokenNameLookup = tokenNameLookup;
        this.schemaState = schemaState;
        this.multiPopulatorFactory = multiPopulatorFactory;
        this.logProvider = logProvider;
        this.monitor = monitor;
        this.populationJobController = new IndexPopulationJobController(scheduler);
        this.log = logProvider.getLog(this.getClass());
    }

    public void init() {
        this.indexMapRef.modify(indexMap -> {
            EnumMap<InternalIndexState, List<IndexLogRecord>> indexStates = new EnumMap<InternalIndexState, List<IndexLogRecord>>(InternalIndexState.class);
            for (IndexRule indexRule : this.indexRules) {
                IndexProxy indexProxy;
                long indexId = indexRule.getId();
                SchemaIndexDescriptor descriptor = indexRule.getIndexDescriptor();
                IndexProvider.Descriptor providerDescriptor = indexRule.getProviderDescriptor();
                IndexProvider provider = this.providerMap.lookup(providerDescriptor);
                InternalIndexState initialState = provider.getInitialState(indexId, descriptor);
                indexStates.computeIfAbsent(initialState, internalIndexState -> new ArrayList()).add(new IndexLogRecord(indexId, descriptor));
                this.log.debug(this.indexStateInfo("init", indexId, initialState, descriptor));
                switch (initialState) {
                    case ONLINE: {
                        this.monitor.initialState(descriptor, InternalIndexState.ONLINE);
                        indexProxy = this.indexProxyCreator.createOnlineIndexProxy(indexId, descriptor, providerDescriptor);
                        break;
                    }
                    case POPULATING: {
                        this.monitor.initialState(descriptor, InternalIndexState.POPULATING);
                        indexProxy = this.indexProxyCreator.createRecoveringIndexProxy(indexId, descriptor, providerDescriptor);
                        break;
                    }
                    case FAILED: {
                        this.monitor.initialState(descriptor, InternalIndexState.FAILED);
                        IndexPopulationFailure failure = IndexPopulationFailure.failure(provider.getPopulationFailure(indexId, descriptor));
                        indexProxy = this.indexProxyCreator.createFailedIndexProxy(indexId, descriptor, providerDescriptor, failure);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("" + initialState);
                    }
                }
                indexMap.putIndexProxy(indexId, indexProxy);
            }
            this.logIndexStateSummary("init", indexStates);
            return indexMap;
        });
    }

    public void start() throws Exception {
        this.state = State.STARTING;
        this.performRecoveredIndexDropActions();
        this.indexMapRef.indexMapSnapshot().forEachIndexProxy(this.indexProxyOperation("refresh", (ThrowingConsumer<IndexProxy, Exception>)((ThrowingConsumer)IndexProxy::refresh)));
        PrimitiveLongObjectMap rebuildingDescriptors = Primitive.longObjectMap();
        this.indexMapRef.modify(indexMap -> {
            EnumMap<InternalIndexState, List<IndexLogRecord>> indexStates = new EnumMap<InternalIndexState, List<IndexLogRecord>>(InternalIndexState.class);
            indexMap.forEachIndexProxy((indexId, proxy) -> {
                InternalIndexState state = proxy.getState();
                SchemaIndexDescriptor descriptor = proxy.getDescriptor();
                indexStates.computeIfAbsent(state, internalIndexState -> new ArrayList()).add(new IndexLogRecord((long)indexId, descriptor));
                this.log.debug(this.indexStateInfo("start", (Long)indexId, state, descriptor));
                switch (state) {
                    case ONLINE: {
                        break;
                    }
                    case POPULATING: {
                        rebuildingDescriptors.put(indexId.longValue(), (Object)new RebuildingIndexDescriptor(descriptor, proxy.getProviderDescriptor()));
                        break;
                    }
                    case FAILED: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown state: " + state);
                    }
                }
            });
            this.logIndexStateSummary("start", indexStates);
            this.dropRecoveringIndexes((IndexMap)indexMap, rebuildingDescriptors.iterator());
            if (!rebuildingDescriptors.isEmpty()) {
                IndexPopulationJob populationJob = this.newIndexPopulationJob();
                rebuildingDescriptors.visitEntries((indexId, descriptor) -> {
                    IndexProxy proxy = this.indexProxyCreator.createPopulatingIndexProxy(indexId, descriptor.getSchemaIndexDescriptor(), descriptor.getProviderDescriptor(), false, this.monitor, populationJob);
                    proxy.start();
                    indexMap.putIndexProxy(indexId, proxy);
                    return false;
                });
                this.startIndexPopulation(populationJob);
            }
            return indexMap;
        });
        this.samplingController.recoverIndexSamples();
        this.samplingController.start();
        rebuildingDescriptors.visitEntries((indexId, descriptor) -> {
            IndexProxy proxy;
            if (descriptor.getSchemaIndexDescriptor().type() != SchemaIndexDescriptor.Type.UNIQUE) {
                return false;
            }
            try {
                proxy = this.getIndexProxy(indexId);
            }
            catch (IndexNotFoundKernelException e) {
                throw new IllegalStateException("What? This index was seen during recovery just now, why isn't it available now?");
            }
            this.monitor.awaitingPopulationOfRecoveredIndex(indexId, descriptor.getSchemaIndexDescriptor());
            this.awaitOnline(proxy);
            return false;
        });
        this.state = State.RUNNING;
    }

    private void performRecoveredIndexDropActions() {
        this.indexesToDropAfterCompletedRecovery.values().forEach(index -> {
            try {
                index.drop();
            }
            catch (Exception e) {
                try {
                    index.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        this.indexesToDropAfterCompletedRecovery.clear();
    }

    private void awaitOnline(IndexProxy proxy) throws InterruptedException {
        block5: while (true) {
            switch (proxy.getState()) {
                case ONLINE: {
                    return;
                }
                case FAILED: {
                    throw new IllegalStateException("Index entered " + InternalIndexState.FAILED + " state while recovery waited for it to be fully populated");
                }
                case POPULATING: {
                    Thread.sleep(10L);
                    continue block5;
                }
            }
            break;
        }
        throw new IllegalStateException(proxy.getState().name());
    }

    public void shutdown() throws ExecutionException, InterruptedException {
        this.state = State.STOPPED;
        this.samplingController.stop();
        this.populationJobController.stop();
        this.closeAllIndexes();
    }

    public Register.DoubleLongRegister indexUpdatesAndSize(SchemaDescriptor descriptor) throws IndexNotFoundKernelException {
        long indexId = this.indexMapRef.getOnlineIndexId(descriptor);
        Register.DoubleLongRegister output = Registers.newDoubleLongRegister();
        this.storeView.indexUpdatesAndSize(indexId, output);
        return output;
    }

    public double indexUniqueValuesPercentage(SchemaDescriptor descriptor) throws IndexNotFoundKernelException {
        long indexId = this.indexMapRef.getOnlineIndexId(descriptor);
        Register.DoubleLongRegister output = Registers.newDoubleLongRegister();
        this.storeView.indexSample(indexId, output);
        long unique = output.readFirst();
        long size = output.readSecond();
        if (size == 0L) {
            return 1.0;
        }
        return (double)unique / (double)size;
    }

    public void validateBeforeCommit(SchemaDescriptor index, Value[] tuple) {
        this.indexMapRef.validateBeforeCommit(index, tuple);
    }

    @Override
    public void apply(IndexUpdates updates) throws IOException, IndexEntryConflictException {
        if (this.state == State.NOT_STARTED) {
            this.apply(updates, IndexUpdateMode.RECOVERY);
        } else if (this.state == State.RUNNING || this.state == State.STARTING) {
            this.apply(updates, IndexUpdateMode.ONLINE);
        } else {
            throw new IllegalStateException("Can't apply index updates " + Iterables.asList((Iterable)updates) + " while indexing service is " + (Object)((Object)this.state));
        }
    }

    private void apply(Iterable<IndexEntryUpdate<SchemaDescriptor>> updates, IndexUpdateMode updateMode) throws IOException, IndexEntryConflictException {
        try (IndexUpdaterMap updaterMap = this.indexMapRef.createIndexUpdaterMap(updateMode);){
            for (IndexEntryUpdate<SchemaDescriptor> indexUpdate : updates) {
                this.processUpdate(updaterMap, indexUpdate);
            }
        }
    }

    @Override
    public Iterable<IndexEntryUpdate<SchemaDescriptor>> convertToIndexUpdates(NodeUpdates nodeUpdates) {
        Iterable<SchemaDescriptor> relatedIndexes = this.indexMapRef.getRelatedIndexes(nodeUpdates.labelsChanged(), nodeUpdates.labelsUnchanged(), nodeUpdates.propertiesChanged());
        return nodeUpdates.forIndexKeys(relatedIndexes, this.storeView);
    }

    public void createIndexes(IndexRule ... rules) throws IOException {
        IndexPopulationStarter populationStarter = new IndexPopulationStarter(rules);
        this.indexMapRef.modify(populationStarter);
        populationStarter.startPopulation();
    }

    private void processUpdate(IndexUpdaterMap updaterMap, IndexEntryUpdate<SchemaDescriptor> indexUpdate) throws IOException, IndexEntryConflictException {
        IndexUpdater updater = updaterMap.getUpdater(indexUpdate.indexKey().schema());
        if (updater != null) {
            updater.process(indexUpdate);
        }
    }

    public void dropIndex(IndexRule rule) throws IOException {
        this.indexMapRef.modify(indexMap -> {
            long indexId = rule.getId();
            IndexProxy index = indexMap.removeIndexProxy(indexId);
            if (this.state == State.RUNNING) {
                assert (index != null) : "Index " + rule + " doesn't exists";
                index.drop();
            } else if (index != null) {
                this.indexesToDropAfterCompletedRecovery.put(indexId, index);
            }
            return indexMap;
        });
    }

    public void triggerIndexSampling(IndexSamplingMode mode) {
        this.log.info("Manual trigger for sampling all indexes [" + (Object)((Object)mode) + "]");
        this.samplingController.sampleIndexes(mode);
    }

    public void triggerIndexSampling(SchemaDescriptor descriptor, IndexSamplingMode mode) throws IndexNotFoundKernelException {
        String description = descriptor.userDescription(this.tokenNameLookup);
        this.log.info("Manual trigger for sampling index " + description + " [" + (Object)((Object)mode) + "]");
        this.samplingController.sampleIndex(this.indexMapRef.getIndexId(descriptor), mode);
    }

    private void dropRecoveringIndexes(IndexMap indexMap, PrimitiveLongIterator indexesToRebuild) throws IOException {
        while (indexesToRebuild.hasNext()) {
            IndexProxy indexProxy = indexMap.removeIndexProxy(indexesToRebuild.next());
            assert (indexProxy != null);
            indexProxy.drop();
        }
    }

    public void activateIndex(long indexId) throws IndexNotFoundKernelException, IndexActivationFailedKernelException, IndexPopulationFailedKernelException {
        try {
            if (this.state == State.RUNNING) {
                IndexProxy index = this.getIndexProxy(indexId);
                index.awaitStoreScanCompleted();
                index.activate();
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new IndexActivationFailedKernelException(e, "Unable to activate index, thread was interrupted.");
        }
    }

    public IndexProxy getIndexProxy(long indexId) throws IndexNotFoundKernelException {
        return this.indexMapRef.getIndexProxy(indexId);
    }

    public IndexProxy getIndexProxy(SchemaDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexMapRef.getIndexProxy(descriptor);
    }

    public long getIndexId(SchemaDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexMapRef.getIndexId(descriptor);
    }

    public void validateIndex(long indexId) throws IndexNotFoundKernelException, IndexPopulationFailedKernelException, UniquePropertyValueValidationException {
        this.getIndexProxy(indexId).validate();
    }

    public void forceAll(IOLimiter limiter) {
        this.indexMapRef.indexMapSnapshot().forEachIndexProxy(this.indexProxyOperation("force", (ThrowingConsumer<IndexProxy, Exception>)((ThrowingConsumer)proxy -> proxy.force(limiter))));
    }

    private BiConsumer<Long, IndexProxy> indexProxyOperation(String name, ThrowingConsumer<IndexProxy, Exception> operation) {
        return (id, indexProxy) -> {
            try {
                operation.accept(indexProxy);
            }
            catch (Exception e) {
                try {
                    IndexProxy proxy = this.indexMapRef.getIndexProxy((long)id);
                    throw new UnderlyingStorageException("Unable to " + name + " " + proxy, e);
                }
                catch (IndexNotFoundKernelException indexNotFoundKernelException) {
                    // empty catch block
                }
            }
        };
    }

    private void closeAllIndexes() {
        this.indexMapRef.modify(indexMap -> {
            Iterable<IndexProxy> indexesToStop = indexMap.getAllIndexProxies();
            for (IndexProxy index : indexesToStop) {
                try {
                    index.close();
                }
                catch (Exception e) {
                    this.log.error("Unable to close index", (Throwable)e);
                }
            }
            return new IndexMap();
        });
    }

    public PrimitiveLongSet getIndexIds() {
        Iterable<IndexProxy> indexProxies = this.indexMapRef.getAllIndexProxies();
        PrimitiveLongSet indexIds = Primitive.longSet();
        for (IndexProxy indexProxy : indexProxies) {
            indexIds.add(indexProxy.getIndexId());
        }
        return indexIds;
    }

    public ResourceIterator<File> snapshotIndexFiles() throws IOException {
        ArrayList<ResourceIterator<File>> snapshots = new ArrayList<ResourceIterator<File>>();
        for (IndexProxy indexProxy : this.indexMapRef.getAllIndexProxies()) {
            snapshots.add(indexProxy.snapshotFiles());
        }
        return Iterators.concatResourceIterators(snapshots.iterator());
    }

    private IndexPopulationJob newIndexPopulationJob() {
        MultipleIndexPopulator multiPopulator = this.multiPopulatorFactory.create(this.storeView, this.logProvider);
        return new IndexPopulationJob(multiPopulator, this.monitor, this.schemaState);
    }

    private void startIndexPopulation(IndexPopulationJob job) {
        this.populationJobController.startIndexPopulation(job);
    }

    private String indexStateInfo(String tag, Long indexId, InternalIndexState state, SchemaIndexDescriptor descriptor) {
        return String.format("IndexingService.%s: index %d on %s is %s", tag, indexId, descriptor.schema().userDescription(this.tokenNameLookup), state.name());
    }

    private void logIndexStateSummary(String method, Map<InternalIndexState, List<IndexLogRecord>> indexStates) {
        if (indexStates.isEmpty()) {
            return;
        }
        int mostPopularStateCount = Integer.MIN_VALUE;
        InternalIndexState mostPopularState = null;
        for (Map.Entry<InternalIndexState, List<IndexLogRecord>> indexStateEntry : indexStates.entrySet()) {
            if (indexStateEntry.getValue().size() <= mostPopularStateCount) continue;
            mostPopularState = indexStateEntry.getKey();
            mostPopularStateCount = indexStateEntry.getValue().size();
        }
        indexStates.remove(mostPopularState);
        for (Map.Entry<InternalIndexState, List<IndexLogRecord>> indexStateEntry : indexStates.entrySet()) {
            InternalIndexState state = indexStateEntry.getKey();
            List<IndexLogRecord> logRecords = indexStateEntry.getValue();
            for (IndexLogRecord logRecord : logRecords) {
                this.log.info(this.indexStateInfo(method, logRecord.getIndexId(), state, logRecord.getDescriptor()));
            }
        }
        this.log.info(String.format("IndexingService.%s: indexes not specifically mentioned above are %s", method, mostPopularState));
    }

    private static final class IndexLogRecord {
        private final long indexId;
        private final SchemaIndexDescriptor descriptor;

        IndexLogRecord(long indexId, SchemaIndexDescriptor descriptor) {
            this.indexId = indexId;
            this.descriptor = descriptor;
        }

        public long getIndexId() {
            return this.indexId;
        }

        public SchemaIndexDescriptor getDescriptor() {
            return this.descriptor;
        }
    }

    private final class IndexPopulationStarter
    implements ThrowingFunction<IndexMap, IndexMap, IOException> {
        private final IndexRule[] rules;
        private IndexPopulationJob populationJob;

        IndexPopulationStarter(IndexRule[] rules) {
            this.rules = rules;
        }

        public IndexMap apply(IndexMap indexMap) throws IOException {
            for (IndexRule rule : this.rules) {
                IndexProxy index;
                long ruleId = rule.getId();
                if (IndexingService.this.state == State.NOT_STARTED) {
                    IndexingService.this.indexesToDropAfterCompletedRecovery.remove(ruleId);
                }
                if ((index = indexMap.getIndexProxy(ruleId)) != null && IndexingService.this.state == State.NOT_STARTED) {
                    indexMap.putIndexProxy(ruleId, index);
                    continue;
                }
                SchemaIndexDescriptor descriptor = rule.getIndexDescriptor();
                IndexProvider.Descriptor providerDescriptor = rule.getProviderDescriptor();
                boolean flipToTentative = rule.canSupportUniqueConstraint();
                if (IndexingService.this.state == State.RUNNING) {
                    this.populationJob = this.populationJob == null ? IndexingService.this.newIndexPopulationJob() : this.populationJob;
                    index = IndexingService.this.indexProxyCreator.createPopulatingIndexProxy(ruleId, descriptor, providerDescriptor, flipToTentative, IndexingService.this.monitor, this.populationJob);
                    index.start();
                } else {
                    index = IndexingService.this.indexProxyCreator.createRecoveringIndexProxy(ruleId, descriptor, providerDescriptor);
                }
                indexMap.putIndexProxy(rule.getId(), index);
            }
            return indexMap;
        }

        void startPopulation() {
            if (this.populationJob != null) {
                IndexingService.this.startIndexPopulation(this.populationJob);
            }
        }
    }

    public static class MonitorAdapter
    implements Monitor {
        @Override
        public void initialState(SchemaIndexDescriptor descriptor, InternalIndexState state) {
        }

        @Override
        public void populationCompleteOn(SchemaIndexDescriptor descriptor) {
        }

        @Override
        public void indexPopulationScanStarting() {
        }

        @Override
        public void indexPopulationScanComplete() {
        }

        @Override
        public void awaitingPopulationOfRecoveredIndex(long indexId, SchemaIndexDescriptor descriptor) {
        }
    }

    public static interface Monitor {
        public void initialState(SchemaIndexDescriptor var1, InternalIndexState var2);

        public void populationCompleteOn(SchemaIndexDescriptor var1);

        public void indexPopulationScanStarting();

        public void indexPopulationScanComplete();

        public void awaitingPopulationOfRecoveredIndex(long var1, SchemaIndexDescriptor var3);
    }

    static enum State {
        NOT_STARTED,
        STARTING,
        RUNNING,
        STOPPED;

    }
}

