/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.neo4j.graphdb.config.InvalidSettingException;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ConfigurationValidator;
import org.neo4j.kernel.configuration.Connector;
import org.neo4j.logging.Log;

public class ServerConfigurationValidator
implements ConfigurationValidator {
    @Override
    public Map<String, String> validate(@Nonnull Config config, @Nonnull Log log) throws InvalidSettingException {
        HashMap<String, String> validSettings = new HashMap<String, String>();
        boolean hasEnabledConnector = false;
        for (String identifier : config.identifiersFromGroup(Connector.class)) {
            Connector connector = new Connector(identifier);
            if ("http".equalsIgnoreCase(connector.group.groupKey) || "https".equalsIgnoreCase(connector.group.groupKey)) {
                validSettings.put(connector.type.name(), Connector.ConnectorType.HTTP.name());
                hasEnabledConnector = hasEnabledConnector ? true : config.get(connector.enabled);
                continue;
            }
            validSettings.put(connector.type.name(), Connector.ConnectorType.BOLT.name());
        }
        if (!hasEnabledConnector) {
            throw new InvalidSettingException(String.format("Missing mandatory enabled connector of type '%s'", new Object[]{Connector.ConnectorType.HTTP}));
        }
        return validSettings;
    }
}

