/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.BoundedIterable;
import org.neo4j.helpers.collection.CombiningIterable;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.NativeSchemaIndexAccessor;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.kernel.impl.index.schema.SpatialIndexCache;
import org.neo4j.kernel.impl.index.schema.SpatialIndexFiles;
import org.neo4j.kernel.impl.index.schema.SpatialIndexPartReader;
import org.neo4j.kernel.impl.index.schema.SpatialIndexPopulator;
import org.neo4j.kernel.impl.index.schema.SpatialIndexReader;
import org.neo4j.kernel.impl.index.schema.SpatialIndexUpdater;
import org.neo4j.kernel.impl.index.schema.SpatialSchemaKey;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexBase;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.values.storable.CoordinateReferenceSystem;

class SpatialIndexAccessor
extends SpatialIndexCache<PartAccessor>
implements IndexAccessor {
    private final SchemaIndexDescriptor descriptor;

    SpatialIndexAccessor(long indexId, SchemaIndexDescriptor descriptor, IndexSamplingConfig samplingConfig, PageCache pageCache, FileSystemAbstraction fs, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, IndexProvider.Monitor monitor, SpatialIndexFiles spatialIndexFiles, SpaceFillingCurveConfiguration searchConfiguration) throws IOException {
        super(new PartFactory(pageCache, fs, recoveryCleanupWorkCollector, monitor, descriptor, indexId, samplingConfig, spatialIndexFiles, searchConfiguration));
        this.descriptor = descriptor;
        spatialIndexFiles.loadExistingIndexes(this);
    }

    @Override
    public void drop() throws IOException {
        FusionIndexBase.forAll(NativeSchemaIndexAccessor::drop, this);
    }

    @Override
    public IndexUpdater newUpdater(IndexUpdateMode mode) {
        return new SpatialIndexUpdater(this, mode);
    }

    @Override
    public void force(IOLimiter ioLimiter) throws IOException {
        for (NativeSchemaIndexAccessor part : this) {
            part.force(ioLimiter);
        }
    }

    @Override
    public void refresh() {
    }

    @Override
    public void close() throws IOException {
        this.closeInstantiateCloseLock();
        FusionIndexBase.forAll(NativeSchemaIndexAccessor::close, this);
    }

    @Override
    public IndexReader newReader() {
        return new SpatialIndexReader(this.descriptor, this);
    }

    @Override
    public BoundedIterable<Long> newAllEntriesReader() {
        final ArrayList<BoundedIterable<Long>> allEntriesReader = new ArrayList<BoundedIterable<Long>>();
        for (NativeSchemaIndexAccessor part : this) {
            allEntriesReader.add(part.newAllEntriesReader());
        }
        return new BoundedIterable<Long>(){

            @Override
            public long maxCount() {
                long sum = 0L;
                for (BoundedIterable part : allEntriesReader) {
                    long partMaxCount = part.maxCount();
                    if (partMaxCount == -1L) {
                        return -1L;
                    }
                    sum += partMaxCount;
                }
                return sum;
            }

            @Override
            public void close() throws Exception {
                FusionIndexBase.forAll(AutoCloseable::close, allEntriesReader);
            }

            @Override
            public Iterator<Long> iterator() {
                return new CombiningIterable((Iterable)allEntriesReader).iterator();
            }
        };
    }

    @Override
    public ResourceIterator<File> snapshotFiles() {
        ArrayList<ResourceIterator<File>> snapshotFiles = new ArrayList<ResourceIterator<File>>();
        for (NativeSchemaIndexAccessor part : this) {
            snapshotFiles.add(part.snapshotFiles());
        }
        return Iterators.concatResourceIterators(snapshotFiles.iterator());
    }

    @Override
    public void verifyDeferredConstraints(PropertyAccessor propertyAccessor) {
    }

    @Override
    public boolean isDirty() {
        return Iterators.stream(this.iterator()).anyMatch(NativeSchemaIndexAccessor::isDirty);
    }

    static class PartFactory
    implements SpatialIndexCache.Factory<PartAccessor> {
        private final PageCache pageCache;
        private final FileSystemAbstraction fs;
        private final RecoveryCleanupWorkCollector recoveryCleanupWorkCollector;
        private final IndexProvider.Monitor monitor;
        private final SchemaIndexDescriptor descriptor;
        private final long indexId;
        private final IndexSamplingConfig samplingConfig;
        private final SpatialIndexFiles spatialIndexFiles;
        private final SpaceFillingCurveConfiguration searchConfiguration;

        PartFactory(PageCache pageCache, FileSystemAbstraction fs, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, IndexProvider.Monitor monitor, SchemaIndexDescriptor descriptor, long indexId, IndexSamplingConfig samplingConfig, SpatialIndexFiles spatialIndexFiles, SpaceFillingCurveConfiguration searchConfiguration) {
            this.pageCache = pageCache;
            this.fs = fs;
            this.recoveryCleanupWorkCollector = recoveryCleanupWorkCollector;
            this.monitor = monitor;
            this.descriptor = descriptor;
            this.indexId = indexId;
            this.samplingConfig = samplingConfig;
            this.spatialIndexFiles = spatialIndexFiles;
            this.searchConfiguration = searchConfiguration;
        }

        @Override
        public PartAccessor newSpatial(CoordinateReferenceSystem crs) throws IOException {
            return this.createPartAccessor(this.spatialIndexFiles.forCrs(crs));
        }

        private PartAccessor createPartAccessor(SpatialIndexFiles.SpatialFileLayout fileLayout) throws IOException {
            if (!this.fs.fileExists(fileLayout.indexFile)) {
                this.createEmptyIndex(fileLayout);
            } else {
                fileLayout.readHeader(this.pageCache);
            }
            return new PartAccessor(this.pageCache, this.fs, fileLayout, this.recoveryCleanupWorkCollector, this.monitor, this.descriptor, this.indexId, this.samplingConfig, this.searchConfiguration);
        }

        private void createEmptyIndex(SpatialIndexFiles.SpatialFileLayout fileLayout) throws IOException {
            SpatialIndexPopulator.PartPopulator populator = new SpatialIndexPopulator.PartPopulator(this.pageCache, this.fs, fileLayout, this.monitor, this.descriptor, this.indexId, this.samplingConfig, this.searchConfiguration);
            populator.create();
            populator.close(true);
        }
    }

    static class PartAccessor
    extends NativeSchemaIndexAccessor<SpatialSchemaKey, NativeSchemaValue> {
        private final Layout<SpatialSchemaKey, NativeSchemaValue> layout;
        private final SchemaIndexDescriptor descriptor;
        private final IndexSamplingConfig samplingConfig;
        private final SpaceFillingCurveConfiguration searchConfiguration;

        PartAccessor(PageCache pageCache, FileSystemAbstraction fs, SpatialIndexFiles.SpatialFileLayout fileLayout, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, IndexProvider.Monitor monitor, SchemaIndexDescriptor descriptor, long indexId, IndexSamplingConfig samplingConfig, SpaceFillingCurveConfiguration searchConfiguration) throws IOException {
            super(pageCache, fs, fileLayout.indexFile, fileLayout.layout, recoveryCleanupWorkCollector, monitor, descriptor, indexId, samplingConfig);
            this.layout = fileLayout.layout;
            this.descriptor = descriptor;
            this.samplingConfig = samplingConfig;
            this.searchConfiguration = searchConfiguration;
        }

        @Override
        public SpatialIndexPartReader<NativeSchemaValue> newReader() {
            this.assertOpen();
            return new SpatialIndexPartReader<NativeSchemaValue>(this.tree, this.layout, this.samplingConfig, this.descriptor, this.searchConfiguration);
        }
    }
}

