/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.NodeSetFirstGroupStep;
import org.neo4j.unsafe.impl.batchimport.RecordIdIterator;
import org.neo4j.unsafe.impl.batchimport.UpdateRecordsStep;
import org.neo4j.unsafe.impl.batchimport.cache.ByteArray;
import org.neo4j.unsafe.impl.batchimport.staging.BatchFeedStep;
import org.neo4j.unsafe.impl.batchimport.staging.ReadRecordsStep;
import org.neo4j.unsafe.impl.batchimport.staging.Stage;
import org.neo4j.unsafe.impl.batchimport.store.StorePrepareIdSequence;

public class NodeFirstGroupStage
extends Stage {
    public static final String NAME = "Node --> Group";

    public NodeFirstGroupStage(Configuration config, RecordStore<RelationshipGroupRecord> groupStore, RecordStore<NodeRecord> nodeStore, ByteArray cache) {
        super(NAME, null, config, 0);
        this.add(new BatchFeedStep(this.control(), config, RecordIdIterator.allIn(groupStore, config), groupStore.getRecordSize()));
        this.add(new ReadRecordsStep<RelationshipGroupRecord>(this.control(), config, true, groupStore));
        this.add(new NodeSetFirstGroupStep(this.control(), config, nodeStore, cache));
        this.add(new UpdateRecordsStep<NodeRecord>(this.control(), config, nodeStore, new StorePrepareIdSequence()));
    }
}

