/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexBase;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexProvider;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.values.storable.Value;

public class FusionSelector10
implements FusionIndexProvider.Selector {
    @Override
    public void validateSatisfied(Object[] instances) {
        FusionIndexBase.validateSelectorInstances(instances, 1, 4, 2, 3);
    }

    @Override
    public int selectSlot(Value ... values) {
        if (values.length > 1) {
            return 4;
        }
        Value singleValue = values[0];
        switch (singleValue.valueGroup().category()) {
            case NUMBER: {
                return 1;
            }
            case GEOMETRY: {
                return 2;
            }
            case TEMPORAL: {
                return 3;
            }
        }
        return 4;
    }

    @Override
    public IndexReader select(IndexReader[] instances, IndexQuery ... predicates) {
        if (predicates.length > 1) {
            return instances[4];
        }
        IndexQuery predicate = predicates[0];
        switch (predicate.valueGroup().category()) {
            case NUMBER: {
                return instances[1];
            }
            case GEOMETRY: {
                return instances[2];
            }
            case TEMPORAL: {
                return instances[3];
            }
            case UNKNOWN: {
                return null;
            }
        }
        return instances[4];
    }
}

