/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.util.Arrays;
import org.neo4j.collection.primitive.PrimitiveLongResourceCollections;
import org.neo4j.collection.primitive.PrimitiveLongResourceIterator;
import org.neo4j.graphdb.Resource;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.kernel.api.exceptions.index.IndexNotApplicableKernelException;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.api.schema.BridgingIndexProgressor;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexBase;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexProvider;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexSampler;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.IndexSampler;
import org.neo4j.values.storable.Value;

class FusionIndexReader
extends FusionIndexBase<IndexReader>
implements IndexReader {
    private final SchemaIndexDescriptor descriptor;

    FusionIndexReader(IndexReader[] readers, FusionIndexProvider.Selector selector, SchemaIndexDescriptor descriptor) {
        super(readers, selector);
        this.descriptor = descriptor;
    }

    public void close() {
        FusionIndexReader.forAll(Resource::close, this.instances);
    }

    @Override
    public long countIndexedNodes(long nodeId, Value ... propertyValues) {
        return ((IndexReader)this.selector.select(this.instances, propertyValues)).countIndexedNodes(nodeId, propertyValues);
    }

    @Override
    public IndexSampler createSampler() {
        return new FusionIndexSampler(this.instancesAs(IndexSampler.class, IndexReader::createSampler));
    }

    @Override
    public PrimitiveLongResourceIterator query(IndexQuery ... predicates) throws IndexNotApplicableKernelException {
        IndexReader instance = this.selector.select((IndexReader[])this.instances, predicates);
        if (instance != null) {
            return instance.query(predicates);
        }
        PrimitiveLongResourceIterator[] converted = this.instancesAs(PrimitiveLongResourceIterator.class, reader -> reader.query(predicates));
        return PrimitiveLongResourceCollections.concat((PrimitiveLongResourceIterator[])converted);
    }

    @Override
    public void query(IndexProgressor.NodeValueClient cursor, IndexOrder indexOrder, IndexQuery ... predicates) throws IndexNotApplicableKernelException {
        IndexReader instance = this.selector.select((IndexReader[])this.instances, predicates);
        if (instance != null) {
            instance.query(cursor, indexOrder, predicates);
        } else {
            if (indexOrder != IndexOrder.NONE) {
                throw new UnsupportedOperationException(String.format("Tried to query index with unsupported order %s. Supported orders for query %s are %s.", indexOrder, Arrays.toString(predicates), IndexOrder.NONE));
            }
            BridgingIndexProgressor multiProgressor = new BridgingIndexProgressor(cursor, this.descriptor.schema().getPropertyIds());
            cursor.initialize(this.descriptor, multiProgressor, predicates);
            for (IndexReader reader : (IndexReader[])this.instances) {
                reader.query(multiProgressor, indexOrder, predicates);
            }
        }
    }

    @Override
    public boolean hasFullValuePrecision(IndexQuery ... predicates) {
        IndexReader instance = this.selector.select((IndexReader[])this.instances, predicates);
        if (instance == null) {
            if (predicates.length != 1 || !(predicates[0] instanceof IndexQuery.ExistsPredicate)) {
                throw new IllegalStateException("Selected IndexReader null for predicates " + Arrays.toString(predicates));
            }
            return true;
        }
        return instance.hasFullValuePrecision(predicates);
    }
}

