/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.neo4j.values.storable.CoordinateReferenceSystem;

class SpatialIndexCache<T>
implements Iterable<T> {
    private final Factory<T> factory;
    private ConcurrentHashMap<CoordinateReferenceSystem, T> spatials = new ConcurrentHashMap();
    private final Lock instantiateCloseLock = new ReentrantLock();
    private boolean closed;

    SpatialIndexCache(Factory<T> factory) {
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T uncheckedSelect(CoordinateReferenceSystem crs) {
        T existing = this.spatials.get(crs);
        if (existing != null) {
            return existing;
        }
        this.instantiateCloseLock.lock();
        try {
            this.assertOpen();
            Object object = this.spatials.computeIfAbsent(crs, key -> {
                try {
                    return this.factory.newSpatial(crs);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            return (T)object;
        }
        finally {
            this.instantiateCloseLock.unlock();
        }
    }

    protected void assertOpen() {
        if (this.closed) {
            throw new IllegalStateException(this + " is already closed");
        }
    }

    void closeInstantiateCloseLock() {
        this.instantiateCloseLock.lock();
        this.closed = true;
        this.instantiateCloseLock.unlock();
    }

    T select(CoordinateReferenceSystem crs) throws IOException {
        try {
            return this.uncheckedSelect(crs);
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    <RESULT> RESULT selectOrElse(CoordinateReferenceSystem crs, Function<T, RESULT> function, RESULT orElse) {
        T part = this.spatials.get(crs);
        if (part == null) {
            return orElse;
        }
        return function.apply(part);
    }

    void loadAll() {
        for (CoordinateReferenceSystem crs : CoordinateReferenceSystem.all()) {
            this.uncheckedSelect(crs);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.spatials.values().iterator();
    }

    static interface Factory<T> {
        public T newSpatial(CoordinateReferenceSystem var1) throws IOException;
    }
}

