/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.kernel.impl.index.schema.NativeSchemaKey;
import org.neo4j.kernel.impl.index.schema.RawBits;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class NumberSchemaKey
extends NativeSchemaKey<NumberSchemaKey> {
    static final int SIZE = 17;
    byte type;
    long rawValueBits;

    NumberSchemaKey() {
    }

    @Override
    protected Value assertCorrectType(Value value) {
        if (!Values.isNumberValue((Object)value)) {
            throw new IllegalArgumentException("Key layout does only support numbers, tried to create key from " + value);
        }
        return value;
    }

    NumberValue asValue() {
        return RawBits.asNumberValue(this.rawValueBits, this.type);
    }

    @Override
    void initValueAsLowest() {
        this.writeFloatingPoint(Double.NEGATIVE_INFINITY);
    }

    @Override
    void initValueAsHighest() {
        this.writeFloatingPoint(Double.POSITIVE_INFINITY);
    }

    @Override
    int compareValueTo(NumberSchemaKey other) {
        return RawBits.compare(this.rawValueBits, this.type, other.rawValueBits, other.type);
    }

    public String toString() {
        return String.format("type=%d,rawValue=%d,value=%s,entityId=%d", this.type, this.rawValueBits, this.asValue(), this.getEntityId());
    }

    public void writeInteger(byte value) {
        this.type = 0;
        this.rawValueBits = value;
    }

    public void writeInteger(short value) {
        this.type = 1;
        this.rawValueBits = value;
    }

    public void writeInteger(int value) {
        this.type = (byte)2;
        this.rawValueBits = value;
    }

    public void writeInteger(long value) {
        this.type = (byte)3;
        this.rawValueBits = value;
    }

    public void writeFloatingPoint(float value) {
        this.type = (byte)4;
        this.rawValueBits = Float.floatToIntBits(value);
    }

    public void writeFloatingPoint(double value) {
        this.type = (byte)5;
        this.rawValueBits = Double.doubleToLongBits(value);
    }
}

