/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.kernel.impl.api.CommandVisitor;
import org.neo4j.kernel.impl.index.IndexCommand;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;
import org.neo4j.storageengine.api.WritableChannel;

public class IndexDefineCommand
extends Command {
    static final int HIGHEST_POSSIBLE_ID = 65534;
    private final AtomicInteger nextIndexNameId = new AtomicInteger();
    private final AtomicInteger nextKeyId = new AtomicInteger();
    private Map<String, Integer> indexNameIdRange;
    private Map<String, Integer> keyIdRange;
    private PrimitiveIntObjectMap<String> idToIndexName;
    private PrimitiveIntObjectMap<String> idToKey;

    public IndexDefineCommand() {
        this.setIndexNameIdRange(new HashMap<String, Integer>());
        this.setKeyIdRange(new HashMap<String, Integer>());
        this.idToIndexName = Primitive.intObjectMap((int)16);
        this.idToKey = Primitive.intObjectMap((int)16);
    }

    public void init(Map<String, Integer> indexNames, Map<String, Integer> keys) {
        this.setIndexNameIdRange(indexNames);
        this.setKeyIdRange(keys);
        this.idToIndexName = IndexDefineCommand.reverse(indexNames);
        this.idToKey = IndexDefineCommand.reverse(keys);
    }

    private static PrimitiveIntObjectMap<String> reverse(Map<String, Integer> map) {
        PrimitiveIntObjectMap result = Primitive.intObjectMap((int)map.size());
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            result.put(entry.getValue().intValue(), (Object)entry.getKey());
        }
        return result;
    }

    private static String getFromMap(PrimitiveIntObjectMap<String> map, int id) {
        if (id == -1) {
            return null;
        }
        String result = (String)map.get(id);
        if (result == null) {
            throw new IllegalArgumentException("" + id);
        }
        return result;
    }

    public String getIndexName(int id) {
        return IndexDefineCommand.getFromMap(this.idToIndexName, id);
    }

    public String getKey(int id) {
        return IndexDefineCommand.getFromMap(this.idToKey, id);
    }

    public int getOrAssignIndexNameId(String indexName) {
        return this.getOrAssignId(this.indexNameIdRange, this.idToIndexName, this.nextIndexNameId, indexName);
    }

    public int getOrAssignKeyId(String key) {
        return this.getOrAssignId(this.keyIdRange, this.idToKey, this.nextKeyId, key);
    }

    private int getOrAssignId(Map<String, Integer> stringToId, PrimitiveIntObjectMap<String> idToString, AtomicInteger nextId, String string) {
        if (string == null) {
            return -1;
        }
        Integer id = stringToId.get(string);
        if (id != null) {
            return id;
        }
        int nextIdInt = nextId.incrementAndGet();
        if (nextIdInt > 65534 || stringToId.size() >= 65534) {
            throw new IllegalStateException(String.format("Modifying more than %d indexes or keys in a single transaction is not supported", 65535));
        }
        id = nextIdInt;
        stringToId.put(string, id);
        idToString.put(id.intValue(), (Object)string);
        return id;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IndexDefineCommand that = (IndexDefineCommand)o;
        return this.nextIndexNameId.get() == that.nextIndexNameId.get() && this.nextKeyId.get() == that.nextKeyId.get() && Objects.equals(this.indexNameIdRange, that.indexNameIdRange) && Objects.equals(this.keyIdRange, that.keyIdRange) && Objects.equals(this.idToIndexName, that.idToIndexName) && Objects.equals(this.idToKey, that.idToKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.nextIndexNameId.get(), this.nextKeyId.get(), this.indexNameIdRange, this.keyIdRange, this.idToIndexName, this.idToKey);
    }

    @Override
    public boolean handle(CommandVisitor visitor) throws IOException {
        return visitor.visitIndexDefineCommand(this);
    }

    public Map<String, Integer> getIndexNameIdRange() {
        return this.indexNameIdRange;
    }

    private void setIndexNameIdRange(Map<String, Integer> indexNameIdRange) {
        this.indexNameIdRange = indexNameIdRange;
    }

    public Map<String, Integer> getKeyIdRange() {
        return this.keyIdRange;
    }

    private void setKeyIdRange(Map<String, Integer> keyIdRange) {
        this.keyIdRange = keyIdRange;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[names:" + this.indexNameIdRange + ", keys:" + this.keyIdRange + "]";
    }

    @Override
    public void serialize(WritableChannel channel) throws IOException {
        channel.put((byte)10);
        byte zero = 0;
        IndexCommand.writeIndexCommandHeader(channel, zero, zero, zero, zero, zero, zero, zero);
        this.writeMap(channel, this.getIndexNameIdRange());
        this.writeMap(channel, this.getKeyIdRange());
    }

    private void writeMap(WritableChannel channel, Map<String, Integer> map) throws IOException {
        assert (map.size() <= 65534) : "Can not write map with size larger than 2 bytes. Actual size " + map.size();
        channel.putShort((short)map.size());
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            IoPrimitiveUtils.write2bLengthAndString(channel, entry.getKey());
            int id = entry.getValue();
            assert (id <= 65534) : "Can not write id larger than 2 bytes. Actual value " + id;
            channel.putShort((short)id);
        }
    }
}

