/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.api.index.ContractCheckingIndexProxy;
import org.neo4j.kernel.impl.api.index.FailedIndexProxy;
import org.neo4j.kernel.impl.api.index.FailedPopulatingIndexProxyFactory;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexCountsRemover;
import org.neo4j.kernel.impl.api.index.IndexMeta;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexPopulationJob;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.OnlineIndexProxy;
import org.neo4j.kernel.impl.api.index.PopulatingIndexProxy;
import org.neo4j.kernel.impl.api.index.RecoveringIndexProxy;
import org.neo4j.kernel.impl.api.index.TentativeConstraintIndexProxy;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.logging.LogProvider;

class IndexProxyCreator {
    private final IndexSamplingConfig samplingConfig;
    private final IndexStoreView storeView;
    private final IndexProviderMap providerMap;
    private final TokenNameLookup tokenNameLookup;
    private final LogProvider logProvider;

    IndexProxyCreator(IndexSamplingConfig samplingConfig, IndexStoreView storeView, IndexProviderMap providerMap, TokenNameLookup tokenNameLookup, LogProvider logProvider) {
        this.samplingConfig = samplingConfig;
        this.storeView = storeView;
        this.providerMap = providerMap;
        this.tokenNameLookup = tokenNameLookup;
        this.logProvider = logProvider;
    }

    IndexProxy createPopulatingIndexProxy(long ruleId, SchemaIndexDescriptor descriptor, IndexProvider.Descriptor providerDescriptor, boolean flipToTentative, IndexingService.Monitor monitor, IndexPopulationJob populationJob) {
        FlippableIndexProxy flipper = new FlippableIndexProxy();
        String indexUserDescription = this.indexUserDescription(descriptor, providerDescriptor);
        IndexPopulator populator = this.populatorFromProvider(providerDescriptor, ruleId, descriptor, this.samplingConfig);
        IndexMeta indexMeta = this.indexMetaFromProvider(ruleId, providerDescriptor, descriptor);
        FailedPopulatingIndexProxyFactory failureDelegateFactory = new FailedPopulatingIndexProxyFactory(indexMeta, populator, indexUserDescription, new IndexCountsRemover(this.storeView, ruleId), this.logProvider);
        MultipleIndexPopulator.IndexPopulation indexPopulation = populationJob.addPopulator(populator, ruleId, indexMeta, indexUserDescription, flipper, failureDelegateFactory);
        PopulatingIndexProxy populatingIndex = new PopulatingIndexProxy(indexMeta, populationJob, indexPopulation);
        flipper.flipTo(populatingIndex);
        flipper.setFlipTarget(() -> {
            monitor.populationCompleteOn(descriptor);
            OnlineIndexProxy onlineProxy = new OnlineIndexProxy(ruleId, indexMeta, this.onlineAccessorFromProvider(providerDescriptor, ruleId, descriptor, this.samplingConfig), this.storeView, true);
            if (flipToTentative) {
                return new TentativeConstraintIndexProxy(flipper, onlineProxy);
            }
            return onlineProxy;
        });
        return new ContractCheckingIndexProxy(flipper, false);
    }

    IndexProxy createRecoveringIndexProxy(long ruleId, SchemaIndexDescriptor descriptor, IndexProvider.Descriptor providerDescriptor) {
        IndexMeta indexMeta = this.indexMetaFromProvider(ruleId, providerDescriptor, descriptor);
        RecoveringIndexProxy proxy = new RecoveringIndexProxy(indexMeta);
        return new ContractCheckingIndexProxy(proxy, true);
    }

    IndexProxy createOnlineIndexProxy(long ruleId, SchemaIndexDescriptor descriptor, IndexProvider.Descriptor providerDescriptor) {
        try {
            IndexAccessor onlineAccessor = this.onlineAccessorFromProvider(providerDescriptor, ruleId, descriptor, this.samplingConfig);
            IndexMeta indexMeta = this.indexMetaFromProvider(ruleId, providerDescriptor, descriptor);
            IndexProxy proxy = new OnlineIndexProxy(ruleId, indexMeta, onlineAccessor, this.storeView, false);
            proxy = new ContractCheckingIndexProxy(proxy, true);
            return proxy;
        }
        catch (IOException e) {
            this.logProvider.getLog(this.getClass()).error("Failed to open index: " + ruleId + " (" + descriptor.userDescription(this.tokenNameLookup) + "), requesting re-population.", (Throwable)e);
            return this.createRecoveringIndexProxy(ruleId, descriptor, providerDescriptor);
        }
    }

    IndexProxy createFailedIndexProxy(long ruleId, SchemaIndexDescriptor descriptor, IndexProvider.Descriptor providerDescriptor, IndexPopulationFailure populationFailure) {
        IndexPopulator indexPopulator = this.populatorFromProvider(providerDescriptor, ruleId, descriptor, this.samplingConfig);
        IndexMeta indexMeta = this.indexMetaFromProvider(ruleId, providerDescriptor, descriptor);
        String indexUserDescription = this.indexUserDescription(descriptor, providerDescriptor);
        IndexProxy proxy = new FailedIndexProxy(indexMeta, indexUserDescription, indexPopulator, populationFailure, new IndexCountsRemover(this.storeView, ruleId), this.logProvider);
        proxy = new ContractCheckingIndexProxy(proxy, true);
        return proxy;
    }

    private String indexUserDescription(SchemaIndexDescriptor descriptor, IndexProvider.Descriptor providerDescriptor) {
        return String.format("%s [provider: %s]", descriptor.schema().userDescription(this.tokenNameLookup), providerDescriptor.toString());
    }

    private IndexPopulator populatorFromProvider(IndexProvider.Descriptor providerDescriptor, long ruleId, SchemaIndexDescriptor descriptor, IndexSamplingConfig samplingConfig) {
        IndexProvider indexProvider = this.providerMap.apply(providerDescriptor);
        return indexProvider.getPopulator(ruleId, descriptor, samplingConfig);
    }

    private IndexAccessor onlineAccessorFromProvider(IndexProvider.Descriptor providerDescriptor, long ruleId, SchemaIndexDescriptor descriptor, IndexSamplingConfig samplingConfig) throws IOException {
        IndexProvider indexProvider = this.providerMap.apply(providerDescriptor);
        return indexProvider.getOnlineAccessor(ruleId, descriptor, samplingConfig);
    }

    private IndexMeta indexMetaFromProvider(long ruleId, IndexProvider.Descriptor providerDescriptor, SchemaIndexDescriptor schemaIndexDescriptor) {
        IndexCapability indexCapability = this.providerMap.apply(providerDescriptor).getCapability(schemaIndexDescriptor);
        return new IndexMeta(ruleId, schemaIndexDescriptor, providerDescriptor, indexCapability);
    }
}

