/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.extension;

import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.extension.UnsatisfiedDependencyStrategy;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.impl.util.DependenciesProxy;
import org.neo4j.kernel.impl.util.UnsatisfiedDependencyException;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;

public class KernelExtensions
extends DependencyResolver.Adapter
implements Lifecycle {
    private final KernelContext kernelContext;
    private final List<KernelExtensionFactory<?>> kernelExtensionFactories = new ArrayList();
    private final Dependencies dependencies;
    private final LifeSupport life = new LifeSupport();
    private final UnsatisfiedDependencyStrategy unsatisfiedDependencyStrategy;

    public KernelExtensions(KernelContext kernelContext, Iterable<KernelExtensionFactory<?>> kernelExtensionFactories, Dependencies dependencies, UnsatisfiedDependencyStrategy unsatisfiedDependencyStrategy) {
        this.kernelContext = kernelContext;
        this.unsatisfiedDependencyStrategy = unsatisfiedDependencyStrategy;
        kernelExtensionFactories.forEach(this.kernelExtensionFactories::add);
        this.dependencies = dependencies;
    }

    public void init() {
        for (KernelExtensionFactory<?> kernelExtensionFactory : this.kernelExtensionFactories) {
            Object kernelExtensionDependencies = this.getKernelExtensionDependencies(kernelExtensionFactory);
            try {
                Lifecycle dependency = this.newInstance(kernelExtensionFactory, kernelExtensionDependencies);
                Objects.requireNonNull(dependency, kernelExtensionFactory.toString() + " returned a null KernelExtension");
                this.life.add(this.dependencies.satisfyDependency(dependency));
            }
            catch (UnsatisfiedDependencyException e) {
                this.unsatisfiedDependencyStrategy.handle(kernelExtensionFactory, e);
            }
        }
        this.life.init();
    }

    private <T> Lifecycle newInstance(KernelExtensionFactory<T> factory, Object dependencies) {
        return factory.newInstance(this.kernelContext, dependencies);
    }

    public void start() {
        this.life.start();
    }

    public void stop() {
        this.life.stop();
    }

    public void shutdown() {
        this.life.shutdown();
    }

    boolean isRegistered(Class<?> kernelExtensionFactoryClass) {
        for (KernelExtensionFactory<?> kernelExtensionFactory : this.kernelExtensionFactories) {
            if (!kernelExtensionFactoryClass.isInstance(kernelExtensionFactory)) continue;
            return true;
        }
        return false;
    }

    public <T> T resolveDependency(Class<T> type, DependencyResolver.SelectionStrategy selector) throws IllegalArgumentException {
        List filteredAndCasted = this.life.getLifecycleInstances().stream().filter(type::isInstance).map(type::cast).collect(Collectors.toList());
        return (T)selector.select(type, filteredAndCasted);
    }

    private Object getKernelExtensionDependencies(KernelExtensionFactory<?> factory) {
        Class configurationClass = (Class)((ParameterizedType)factory.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        return DependenciesProxy.dependencies((DependencyResolver)this.dependencies, configurationClass);
    }

    public Iterable<KernelExtensionFactory<?>> listFactories() {
        return this.kernelExtensionFactories;
    }
}

