/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.labelscan;

import java.util.Arrays;
import java.util.Comparator;

public class NodeLabelUpdate {
    public static final Comparator<? super NodeLabelUpdate> SORT_BY_NODE_ID = Comparator.comparingLong(NodeLabelUpdate::getNodeId);
    private final long nodeId;
    private final long[] labelsBefore;
    private final long[] labelsAfter;

    private NodeLabelUpdate(long nodeId, long[] labelsBefore, long[] labelsAfter) {
        this.nodeId = nodeId;
        this.labelsBefore = labelsBefore;
        this.labelsAfter = labelsAfter;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public long[] getLabelsBefore() {
        return this.labelsBefore;
    }

    public long[] getLabelsAfter() {
        return this.labelsAfter;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[node:" + this.nodeId + ", labelsBefore:" + Arrays.toString(this.labelsBefore) + ", labelsAfter:" + Arrays.toString(this.labelsAfter) + "]";
    }

    public static NodeLabelUpdate labelChanges(long nodeId, long[] labelsBeforeChange, long[] labelsAfterChange) {
        return new NodeLabelUpdate(nodeId, labelsBeforeChange, labelsAfterChange);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeLabelUpdate that = (NodeLabelUpdate)o;
        if (this.nodeId != that.nodeId) {
            return false;
        }
        if (!Arrays.equals(this.labelsAfter, that.labelsAfter)) {
            return false;
        }
        return Arrays.equals(this.labelsBefore, that.labelsBefore);
    }

    public int hashCode() {
        int result = (int)(this.nodeId ^ this.nodeId >>> 32);
        result = 31 * result + (this.labelsBefore != null ? Arrays.hashCode(this.labelsBefore) : 0);
        result = 31 * result + (this.labelsAfter != null ? Arrays.hashCode(this.labelsAfter) : 0);
        return result;
    }
}

