/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import org.neo4j.cursor.RawCursor;
import org.neo4j.index.internal.gbptree.Hit;
import org.neo4j.kernel.impl.index.schema.NativeSchemaKey;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.values.storable.Value;

public class NativeHitIndexProgressor<KEY extends NativeSchemaKey<KEY>, VALUE extends NativeSchemaValue>
implements IndexProgressor {
    private final RawCursor<Hit<KEY, VALUE>, IOException> seeker;
    private final IndexProgressor.NodeValueClient client;
    private final Collection<RawCursor<Hit<KEY, VALUE>, IOException>> toRemoveFromOnClose;
    private boolean closed;

    NativeHitIndexProgressor(RawCursor<Hit<KEY, VALUE>, IOException> seeker, IndexProgressor.NodeValueClient client, Collection<RawCursor<Hit<KEY, VALUE>, IOException>> toRemoveFromOnClose) {
        this.seeker = seeker;
        this.client = client;
        this.toRemoveFromOnClose = toRemoveFromOnClose;
    }

    @Override
    public boolean next() {
        try {
            while (this.seeker.next()) {
                NativeSchemaKey key = (NativeSchemaKey)((Object)((Hit)this.seeker.get()).key());
                Value[] values = this.extractValues(key);
                if (!this.acceptValue(values) || !this.client.acceptNode(key.getEntityId(), values)) continue;
                return true;
            }
            return false;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected boolean acceptValue(Value[] values) {
        return true;
    }

    Value[] extractValues(KEY key) {
        Value[] valueArray;
        if (this.client.needsValues()) {
            Value[] valueArray2 = new Value[1];
            valueArray = valueArray2;
            valueArray2[0] = ((NativeSchemaKey)((Object)key)).asValue();
        } else {
            valueArray = null;
        }
        return valueArray;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            try {
                this.seeker.close();
                this.toRemoveFromOnClose.remove(this.seeker);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

