/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.kernel.api.QueryRegistryOperations;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.StatementOperationParts;
import org.neo4j.kernel.impl.api.operations.QueryRegistrationOperations;
import org.neo4j.kernel.impl.query.clientconnection.ClientConnectionInfo;
import org.neo4j.values.virtual.MapValue;

public class OperationsFacade
implements QueryRegistryOperations {
    private final KernelStatement statement;
    private StatementOperationParts operations;

    OperationsFacade(KernelStatement statement, StatementOperationParts operationParts) {
        this.statement = statement;
        this.operations = operationParts;
    }

    final QueryRegistrationOperations queryRegistrationOperations() {
        return this.operations.queryRegistrationOperations();
    }

    @Override
    public void setMetaData(Map<String, Object> data) {
        this.statement.assertOpen();
        this.statement.getTransaction().setMetaData(data);
    }

    @Override
    public Map<String, Object> getMetaData() {
        this.statement.assertOpen();
        return this.statement.getTransaction().getMetaData();
    }

    @Override
    public Stream<ExecutingQuery> executingQueries() {
        this.statement.assertOpen();
        return this.queryRegistrationOperations().executingQueries(this.statement);
    }

    @Override
    public ExecutingQuery startQueryExecution(ClientConnectionInfo descriptor, String queryText, MapValue queryParameters) {
        this.statement.assertOpen();
        return this.queryRegistrationOperations().startQueryExecution(this.statement, descriptor, queryText, queryParameters);
    }

    @Override
    public void registerExecutingQuery(ExecutingQuery executingQuery) {
        this.statement.assertOpen();
        this.queryRegistrationOperations().registerExecutingQuery(this.statement, executingQuery);
    }

    @Override
    public void unregisterExecutingQuery(ExecutingQuery executingQuery) {
        this.queryRegistrationOperations().unregisterExecutingQuery(this.statement, executingQuery);
    }
}

