/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContext;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.kernel.api.QueryRegistryOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.api.txstate.ExplicitIndexTransactionState;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.api.txstate.TxStateHolder;
import org.neo4j.kernel.impl.api.ClockContext;
import org.neo4j.kernel.impl.api.CloseableResourceManager;
import org.neo4j.kernel.impl.api.ExecutingQueryList;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.OperationsFacade;
import org.neo4j.kernel.impl.api.StatementOperationParts;
import org.neo4j.kernel.impl.locking.LockTracer;
import org.neo4j.kernel.impl.locking.StatementLocks;
import org.neo4j.storageengine.api.StorageStatement;
import org.neo4j.util.FeatureToggles;

public class KernelStatement
extends CloseableResourceManager
implements TxStateHolder,
Statement,
AssertOpen {
    private static final boolean TRACK_STATEMENTS = FeatureToggles.flag(KernelStatement.class, (String)"trackStatements", (boolean)false);
    private static final boolean RECORD_STATEMENTS_TRACES = FeatureToggles.flag(KernelStatement.class, (String)"recordStatementsTraces", (boolean)false);
    private static final int STATEMENT_TRACK_HISTORY_MAX_SIZE = 100;
    private static final Deque<StackTraceElement[]> EMPTY_STATEMENT_HISTORY = new ArrayDeque<StackTraceElement[]>(0);
    private final TxStateHolder txStateHolder;
    private final StorageStatement storeStatement;
    private final KernelTransactionImplementation transaction;
    private final OperationsFacade facade;
    private StatementLocks statementLocks;
    private PageCursorTracer pageCursorTracer = PageCursorTracer.NULL;
    private int referenceCount;
    private volatile ExecutingQueryList executingQueryList;
    private final LockTracer systemLockTracer;
    private final Deque<StackTraceElement[]> statementOpenCloseCalls;
    private final ClockContext clockContext;
    private final VersionContextSupplier versionContextSupplier;

    public KernelStatement(KernelTransactionImplementation transaction, TxStateHolder txStateHolder, StorageStatement storeStatement, LockTracer systemLockTracer, StatementOperationParts statementOperations, ClockContext clockContext, VersionContextSupplier versionContextSupplier) {
        this.transaction = transaction;
        this.txStateHolder = txStateHolder;
        this.storeStatement = storeStatement;
        this.facade = new OperationsFacade(this, statementOperations);
        this.executingQueryList = ExecutingQueryList.EMPTY;
        this.systemLockTracer = systemLockTracer;
        this.statementOpenCloseCalls = RECORD_STATEMENTS_TRACES ? new ArrayDeque() : EMPTY_STATEMENT_HISTORY;
        this.clockContext = clockContext;
        this.versionContextSupplier = versionContextSupplier;
    }

    @Override
    public QueryRegistryOperations queryRegistration() {
        return this.facade;
    }

    @Override
    public TransactionState txState() {
        return this.txStateHolder.txState();
    }

    @Override
    public ExplicitIndexTransactionState explicitIndexTxState() {
        return this.txStateHolder.explicitIndexTxState();
    }

    @Override
    public boolean hasTxStateWithChanges() {
        return this.txStateHolder.hasTxStateWithChanges();
    }

    public void close() {
        if (this.referenceCount > 0 && --this.referenceCount == 0) {
            this.cleanupResources();
        }
        this.recordOpenCloseMethods();
    }

    @Override
    public void assertOpen() {
        if (this.referenceCount == 0) {
            throw new NotInTransactionException("The statement has been closed.");
        }
        Optional<Status> terminationReason = this.transaction.getReasonIfTerminated();
        terminationReason.ifPresent(status -> {
            throw new TransactionTerminatedException(status);
        });
    }

    public void initialize(StatementLocks statementLocks, PageCursorTracer pageCursorCounters) {
        this.statementLocks = statementLocks;
        this.pageCursorTracer = pageCursorCounters;
        this.clockContext.initializeTransaction();
    }

    public StatementLocks locks() {
        return this.statementLocks;
    }

    public LockTracer lockTracer() {
        LockTracer tracer = this.executingQueryList.top(ExecutingQuery::lockTracer);
        return tracer == null ? this.systemLockTracer : this.systemLockTracer.combine(tracer);
    }

    public PageCursorTracer getPageCursorTracer() {
        return this.pageCursorTracer;
    }

    public final void acquire() {
        if (this.referenceCount++ == 0) {
            this.storeStatement.acquire();
            this.clockContext.initializeStatement();
        }
        this.recordOpenCloseMethods();
    }

    final boolean isAcquired() {
        return this.referenceCount > 0;
    }

    final void forceClose() {
        if (this.referenceCount > 0) {
            int leakedStatements = this.referenceCount;
            this.referenceCount = 0;
            this.cleanupResources();
            if (TRACK_STATEMENTS && this.transaction.isSuccess()) {
                String message = this.getStatementNotClosedMessage(leakedStatements);
                throw new StatementNotClosedException(message, this.statementOpenCloseCalls);
            }
        }
        this.pageCursorTracer.reportEvents();
    }

    private String getStatementNotClosedMessage(int leakedStatements) {
        String additionalInstruction = RECORD_STATEMENTS_TRACES ? "" : String.format(" To see statement open/close stack traces please pass '%s' to your JVM or enable corresponding feature toggle.", FeatureToggles.toggle(KernelStatement.class, (String)"recordStatementsTraces", (Object)Boolean.TRUE));
        return String.format("Statements were not correctly closed. Number of leaked statements: %d.%s", leakedStatements, additionalInstruction);
    }

    final String username() {
        return this.transaction.securityContext().subject().username();
    }

    final ExecutingQueryList executingQueryList() {
        return this.executingQueryList;
    }

    final void startQueryExecution(ExecutingQuery query) {
        this.executingQueryList = this.executingQueryList.push(query);
    }

    final void stopQueryExecution(ExecutingQuery executingQuery) {
        this.executingQueryList = this.executingQueryList.remove(executingQuery);
        this.transaction.getStatistics().addWaitingTime(executingQuery.reportedWaitingTimeNanos());
    }

    public StorageStatement getStoreStatement() {
        return this.storeStatement;
    }

    private void cleanupResources() {
        this.storeStatement.release();
        this.executingQueryList = ExecutingQueryList.EMPTY;
        this.closeAllCloseableResources();
    }

    public KernelTransactionImplementation getTransaction() {
        return this.transaction;
    }

    public VersionContext getVersionContext() {
        return this.versionContextSupplier.getVersionContext();
    }

    private void recordOpenCloseMethods() {
        if (RECORD_STATEMENTS_TRACES) {
            if (this.statementOpenCloseCalls.size() > 100) {
                this.statementOpenCloseCalls.pop();
            }
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            this.statementOpenCloseCalls.add(Arrays.copyOfRange(stackTrace, 2, stackTrace.length));
        }
    }

    public ClockContext clocks() {
        return this.clockContext;
    }

    static class StatementNotClosedException
    extends IllegalStateException {
        StatementNotClosedException(String s, Deque<StackTraceElement[]> openCloseTraces) {
            super(s);
            this.addSuppressed(new StatementTraceException(StatementNotClosedException.buildMessage(openCloseTraces)));
        }

        private static String buildMessage(Deque<StackTraceElement[]> openCloseTraces) {
            if (openCloseTraces.isEmpty()) {
                return "";
            }
            int separatorLength = 80;
            String paddingString = "=";
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(out);
            printStream.println();
            printStream.println("Last 100 statements open/close stack traces are:");
            int element = 0;
            for (StackTraceElement[] traceElements : openCloseTraces) {
                printStream.println(StringUtils.center((String)("*StackTrace " + element + "*"), (int)separatorLength, (String)paddingString));
                for (StackTraceElement traceElement : traceElements) {
                    printStream.println("\tat " + traceElement);
                }
                printStream.println(StringUtils.center((String)"", (int)separatorLength, (String)paddingString));
                printStream.println();
                ++element;
            }
            printStream.println("All statement open/close stack traces printed.");
            return out.toString();
        }

        private static class StatementTraceException
        extends RuntimeException {
            StatementTraceException(String message) {
                super(message);
            }

            @Override
            public synchronized Throwable fillInStackTrace() {
                return this;
            }
        }
    }
}

