/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.kernel.impl.core.EmbeddedProxySPI;
import org.neo4j.kernel.impl.core.NodeProxy;
import org.neo4j.kernel.impl.core.PathProxy;
import org.neo4j.kernel.impl.core.RelationshipProxy;
import org.neo4j.kernel.impl.util.NodeProxyWrappingNodeValue;
import org.neo4j.kernel.impl.util.PathWrappingPathValue;
import org.neo4j.kernel.impl.util.RelationshipProxyWrappingValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.virtual.NodeReference;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.PathValue;
import org.neo4j.values.virtual.RelationshipReference;
import org.neo4j.values.virtual.RelationshipValue;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;

public class DefaultValueMapper
extends ValueMapper.JavaMapper {
    private final EmbeddedProxySPI proxySPI;

    public DefaultValueMapper(EmbeddedProxySPI proxySPI) {
        this.proxySPI = proxySPI;
    }

    public Node mapNode(VirtualNodeValue value) {
        assert (!(value instanceof NodeReference));
        if (value instanceof NodeProxyWrappingNodeValue) {
            return ((NodeProxyWrappingNodeValue)value).nodeProxy();
        }
        return new NodeProxy(this.proxySPI, value.id());
    }

    public Relationship mapRelationship(VirtualRelationshipValue value) {
        assert (!(value instanceof RelationshipReference));
        if (value instanceof RelationshipProxyWrappingValue) {
            return ((RelationshipProxyWrappingValue)value).relationshipProxy();
        }
        return new RelationshipProxy(this.proxySPI, value.id());
    }

    public Path mapPath(PathValue value) {
        int i;
        if (value instanceof PathWrappingPathValue) {
            return ((PathWrappingPathValue)value).path();
        }
        NodeValue[] nodeValues = value.nodes();
        RelationshipValue[] relationshipValues = value.relationships();
        long[] nodes = new long[nodeValues.length];
        long[] relationships = new long[relationshipValues.length];
        int[] directedTypes = new int[relationshipValues.length];
        for (i = 0; i < nodes.length; ++i) {
            nodes[i] = nodeValues[i].id();
        }
        for (i = 0; i < relationships.length; ++i) {
            RelationshipValue relationship = relationshipValues[i];
            relationships[i] = relationship.id();
            int typeId = this.proxySPI.getRelationshipTypeIdByName(relationship.type().stringValue());
            directedTypes[i] = nodes[i] == relationship.startNode().id() ? typeId : ~typeId;
        }
        return new PathProxy(this.proxySPI, nodes, relationships, directedTypes);
    }
}

