/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.newapi.DefaultCursors;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipGroupCursor;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.kernel.impl.newapi.RelationshipCursor;
import org.neo4j.kernel.impl.newapi.RelationshipDirection;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.storageengine.api.txstate.NodeState;

class DefaultRelationshipTraversalCursor
extends RelationshipCursor
implements RelationshipTraversalCursor {
    private long originNodeReference;
    private long next;
    private Record buffer;
    private PageCursor pageCursor;
    private final DefaultRelationshipGroupCursor group;
    private final DefaultCursors pool;
    private GroupState groupState;
    private FilterState filterState;
    private boolean filterStore;
    private int filterType = -1;
    private PrimitiveLongIterator addedRelationships;

    DefaultRelationshipTraversalCursor(DefaultRelationshipGroupCursor group, DefaultCursors pool) {
        this.group = group;
        this.pool = pool;
    }

    void buffered(long nodeReference, Record record, RelationshipDirection direction, int type, Read read) {
        this.originNodeReference = nodeReference;
        this.buffer = Record.initialize(record);
        this.groupState = GroupState.NONE;
        this.filterState = FilterState.fromRelationshipDirection(direction);
        this.filterType = type;
        this.init(read);
        this.addedRelationships = PrimitiveLongCollections.emptyIterator();
    }

    void chain(long nodeReference, long reference, Read read) {
        if (this.pageCursor == null) {
            this.pageCursor = read.relationshipPage(reference);
        }
        this.setId(-1L);
        this.groupState = GroupState.NONE;
        this.filterState = FilterState.NONE;
        this.filterType = -1;
        this.originNodeReference = nodeReference;
        this.next = reference;
        this.init(read);
        this.addedRelationships = PrimitiveLongCollections.emptyIterator();
    }

    void groups(long nodeReference, long groupReference, Read read) {
        this.setId(-1L);
        this.next = -1L;
        this.groupState = GroupState.INCOMING;
        this.filterState = FilterState.NONE;
        this.filterType = -1;
        this.originNodeReference = nodeReference;
        read.relationshipGroups(nodeReference, groupReference, this.group);
        this.init(read);
        this.addedRelationships = PrimitiveLongCollections.emptyIterator();
    }

    void filtered(long nodeReference, long reference, Read read, boolean filterStore) {
        if (this.pageCursor == null) {
            this.pageCursor = read.relationshipPage(reference);
        }
        this.setId(-1L);
        this.groupState = GroupState.NONE;
        this.filterState = FilterState.NOT_INITIALIZED;
        this.filterStore = filterStore;
        this.originNodeReference = nodeReference;
        this.next = reference;
        this.init(read);
        this.addedRelationships = PrimitiveLongCollections.emptyIterator();
    }

    void filteredTxState(long nodeReference, Read read, int filterType, RelationshipDirection direction) {
        this.setId(-1L);
        this.groupState = GroupState.NONE;
        this.filterType = filterType;
        this.filterState = FilterState.fromRelationshipDirection(direction);
        this.filterStore = false;
        this.originNodeReference = nodeReference;
        this.next = -1L;
        this.init(read);
        this.addedRelationships = PrimitiveLongCollections.emptyIterator();
    }

    public RelationshipTraversalCursor.Position suspend() {
        throw new UnsupportedOperationException("not implemented");
    }

    public void resume(RelationshipTraversalCursor.Position position) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void neighbour(NodeCursor cursor) {
        this.read.singleNode(this.neighbourNodeReference(), cursor);
    }

    public long neighbourNodeReference() {
        long source = this.sourceNodeReference();
        long target = this.targetNodeReference();
        if (source == this.originNodeReference) {
            return target;
        }
        if (target == this.originNodeReference) {
            return source;
        }
        throw new IllegalStateException("NOT PART OF CHAIN");
    }

    public long originNodeReference() {
        return this.originNodeReference;
    }

    public boolean next() {
        TransactionState txs;
        boolean hasChanges;
        if (this.filterState == FilterState.NOT_INITIALIZED) {
            hasChanges = this.hasChanges();
            TransactionState transactionState = txs = hasChanges ? this.read.txState() : null;
            if (this.filterState == FilterState.NOT_INITIALIZED && this.filterStore) {
                this.read.relationshipFull(this, this.next, this.pageCursor);
                this.setupFilterState();
            }
            if (!(this.filterState == FilterState.NOT_INITIALIZED || hasChanges && txs.relationshipIsDeletedInThisTx(this.getId()))) {
                return true;
            }
        } else {
            hasChanges = this.hasChanges();
            TransactionState transactionState = txs = hasChanges ? this.read.txState() : null;
        }
        if (hasChanges && this.addedRelationships.hasNext()) {
            this.loadFromTxState(this.addedRelationships.next());
            return true;
        }
        if (this.hasBufferedData()) {
            return this.nextBuffered(txs);
        }
        do {
            if (this.traversingDenseNode()) {
                this.traverseDenseNode();
            }
            if (this.next == -1L) {
                this.reset();
                return false;
            }
            this.read.relationshipFull(this, this.next, this.pageCursor);
            this.computeNext();
        } while (this.filterStore && !this.correctTypeAndDirection() || hasChanges && txs.relationshipIsDeletedInThisTx(this.getId()));
        return true;
    }

    private void setupFilterState() {
        long target;
        this.filterType = this.getType();
        long source = this.sourceNodeReference();
        if (source == (target = this.targetNodeReference())) {
            this.next = this.getFirstNextRel();
            this.filterState = FilterState.LOOP;
        } else if (source == this.originNodeReference) {
            this.next = this.getFirstNextRel();
            this.filterState = FilterState.OUTGOING;
        } else if (target == this.originNodeReference) {
            this.next = this.getSecondNextRel();
            this.filterState = FilterState.INCOMING;
        }
    }

    private boolean nextBuffered(TransactionState txs) {
        do {
            this.buffer = this.buffer.next;
            if (!this.hasBufferedData()) {
                this.reset();
                return false;
            }
            this.copyFromBuffer();
        } while (txs != null && txs.relationshipIsDeletedInThisTx(this.getId()));
        return true;
    }

    private void traverseDenseNode() {
        block5: while (this.next == -1L) {
            switch (this.groupState) {
                case INCOMING: {
                    boolean hasNext = this.group.next();
                    if (!hasNext) {
                        assert (this.next == -1L);
                        return;
                    }
                    this.next = this.group.incomingRawId();
                    if (this.pageCursor == null) {
                        this.pageCursor = this.read.relationshipPage(Math.max(this.next, 0L));
                    }
                    this.groupState = GroupState.OUTGOING;
                    continue block5;
                }
                case OUTGOING: {
                    this.next = this.group.outgoingRawId();
                    this.groupState = GroupState.LOOP;
                    continue block5;
                }
                case LOOP: {
                    this.next = this.group.loopsRawId();
                    this.groupState = GroupState.INCOMING;
                    continue block5;
                }
            }
            throw new IllegalStateException("We cannot get here, but checkstyle forces this!");
        }
    }

    private void computeNext() {
        long source = this.sourceNodeReference();
        long target = this.targetNodeReference();
        if (source == this.originNodeReference) {
            this.next = this.getFirstNextRel();
        } else if (target == this.originNodeReference) {
            this.next = this.getSecondNextRel();
        } else {
            throw new IllegalStateException("NOT PART OF CHAIN! " + this);
        }
    }

    private boolean correctTypeAndDirection() {
        return this.filterType == this.getType() && this.filterState.check(this.sourceNodeReference(), this.targetNodeReference(), this.originNodeReference);
    }

    private void copyFromBuffer() {
        this.setId(this.buffer.id);
        this.setType(this.buffer.type);
        this.setNextProp(this.buffer.nextProp);
        this.setFirstNode(this.buffer.firstNode);
        this.setSecondNode(this.buffer.secondNode);
    }

    private boolean traversingDenseNode() {
        return this.groupState != GroupState.NONE;
    }

    public boolean shouldRetry() {
        return false;
    }

    public void close() {
        if (!this.isClosed()) {
            this.read = null;
            this.buffer = null;
            this.reset();
            this.pool.accept(this);
        }
    }

    private void reset() {
        this.next = -1L;
        this.setId(-1L);
        this.groupState = GroupState.NONE;
        this.filterState = FilterState.NONE;
        this.filterType = -1;
        this.filterStore = false;
        this.buffer = null;
    }

    @Override
    protected void collectAddedTxStateSnapshot() {
        if (this.filterState == FilterState.NOT_INITIALIZED) {
            this.read.relationshipFull(this, this.next, this.pageCursor);
            this.setupFilterState();
        }
        NodeState nodeState = this.read.txState().getNodeState(this.originNodeReference);
        this.addedRelationships = this.hasTxStateFilter() ? nodeState.getAddedRelationships(this.filterState.direction, this.filterType) : nodeState.getAddedRelationships();
    }

    private boolean hasTxStateFilter() {
        return this.filterState != FilterState.NONE;
    }

    public boolean isClosed() {
        return this.read == null && !this.hasBufferedData();
    }

    public void release() {
        if (this.pageCursor != null) {
            this.pageCursor.close();
            this.pageCursor = null;
        }
        this.group.release();
    }

    @Override
    public String toString() {
        if (this.isClosed()) {
            return "RelationshipTraversalCursor[closed state]";
        }
        String dense = "denseNode=" + this.traversingDenseNode();
        String mode = "mode=";
        mode = this.hasBufferedData() ? mode + "bufferedData" : (this.filterStore ? mode + "filterStore" : mode + "regular");
        return "RelationshipTraversalCursor[id=" + this.getId() + ", open state with: " + dense + ", next=" + this.next + ", " + mode + ", underlying record=" + super.toString() + " ]";
    }

    private boolean hasBufferedData() {
        return this.buffer != null;
    }

    static class Record {
        private static final RelationshipRecord DUMMY = null;
        final long id;
        final int type;
        final long nextProp;
        final long firstNode;
        final long secondNode;
        final Record next;

        static Record initialize(Record first) {
            return new Record(DUMMY, first);
        }

        Record(RelationshipRecord record, Record next) {
            if (record != null) {
                this.id = record.getId();
                this.type = record.getType();
                this.nextProp = record.getNextProp();
                this.firstNode = record.getFirstNode();
                this.secondNode = record.getSecondNode();
            } else {
                this.id = -1L;
                this.type = -1;
                this.nextProp = -1L;
                this.firstNode = -1L;
                this.secondNode = -1L;
            }
            this.next = next;
        }
    }

    private static enum FilterState {
        NOT_INITIALIZED(RelationshipDirection.ERROR){

            @Override
            boolean check(long source, long target, long origin) {
                throw new IllegalStateException("Cannot call check on uninitialized filter");
            }
        }
        ,
        INCOMING(RelationshipDirection.INCOMING){

            @Override
            boolean check(long source, long target, long origin) {
                return origin == target;
            }
        }
        ,
        OUTGOING(RelationshipDirection.OUTGOING){

            @Override
            boolean check(long source, long target, long origin) {
                return origin == source;
            }
        }
        ,
        LOOP(RelationshipDirection.LOOP){

            @Override
            boolean check(long source, long target, long origin) {
                return source == target;
            }
        }
        ,
        NONE(RelationshipDirection.ERROR){

            @Override
            boolean check(long source, long target, long origin) {
                return true;
            }
        };

        private final RelationshipDirection direction;

        abstract boolean check(long var1, long var3, long var5);

        private FilterState(RelationshipDirection direction) {
            this.direction = direction;
        }

        private static FilterState fromRelationshipDirection(RelationshipDirection direction) {
            switch (direction) {
                case OUTGOING: {
                    return OUTGOING;
                }
                case INCOMING: {
                    return INCOMING;
                }
                case LOOP: {
                    return LOOP;
                }
                case ERROR: {
                    throw new IllegalArgumentException("There has been a RelationshipDirection.ERROR");
                }
            }
            throw new IllegalStateException(String.format("Still poking my eye, dear checkstyle... (cannot filter on direction '%s')", new Object[]{direction}));
        }
    }

    private static enum GroupState {
        INCOMING,
        OUTGOING,
        LOOP,
        NONE;

    }
}

