/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.neo4j.values.storable.ValueGroup;

class TemporalIndexCache<T>
implements Iterable<T> {
    private final Factory<T> factory;
    private final ConcurrentHashMap<Offset, T> cache = new ConcurrentHashMap();

    TemporalIndexCache(Factory<T> factory) {
        this.factory = factory;
    }

    T uncheckedSelect(ValueGroup valueGroup) {
        switch (valueGroup) {
            case DATE: {
                return this.date();
            }
            case LOCAL_DATE_TIME: {
                return this.localDateTime();
            }
            case ZONED_DATE_TIME: {
                return this.zonedDateTime();
            }
            case LOCAL_TIME: {
                return this.localTime();
            }
            case ZONED_TIME: {
                return this.zonedTime();
            }
            case DURATION: {
                return this.duration();
            }
        }
        throw new IllegalStateException("Unsupported value group " + valueGroup);
    }

    T select(ValueGroup valueGroup) throws IOException {
        try {
            return this.uncheckedSelect(valueGroup);
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    <RESULT> RESULT selectOrElse(ValueGroup valueGroup, Function<T, RESULT> function, RESULT orElse) {
        T cachedValue;
        switch (valueGroup) {
            case DATE: {
                cachedValue = this.cache.get((Object)Offset.date);
                break;
            }
            case LOCAL_DATE_TIME: {
                cachedValue = this.cache.get((Object)Offset.localDateTime);
                break;
            }
            case ZONED_DATE_TIME: {
                cachedValue = this.cache.get((Object)Offset.zonedDateTime);
                break;
            }
            case LOCAL_TIME: {
                cachedValue = this.cache.get((Object)Offset.localTime);
                break;
            }
            case ZONED_TIME: {
                cachedValue = this.cache.get((Object)Offset.zonedTime);
                break;
            }
            case DURATION: {
                cachedValue = this.cache.get((Object)Offset.duration);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported value group " + valueGroup);
            }
        }
        return cachedValue != null ? function.apply(cachedValue) : orElse;
    }

    private T date() throws UncheckedIOException {
        return (T)this.cache.computeIfAbsent(Offset.date, d -> {
            try {
                return this.factory.newDate();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    private T localDateTime() throws UncheckedIOException {
        return (T)this.cache.computeIfAbsent(Offset.localDateTime, d -> {
            try {
                return this.factory.newLocalDateTime();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    private T zonedDateTime() throws UncheckedIOException {
        return (T)this.cache.computeIfAbsent(Offset.zonedDateTime, d -> {
            try {
                return this.factory.newZonedDateTime();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    private T localTime() throws UncheckedIOException {
        return (T)this.cache.computeIfAbsent(Offset.localTime, d -> {
            try {
                return this.factory.newLocalTime();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    private T zonedTime() throws UncheckedIOException {
        return (T)this.cache.computeIfAbsent(Offset.zonedTime, d -> {
            try {
                return this.factory.newZonedTime();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    private T duration() throws UncheckedIOException {
        return (T)this.cache.computeIfAbsent(Offset.duration, d -> {
            try {
                return this.factory.newDuration();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    void loadAll() {
        try {
            this.date();
            this.zonedDateTime();
            this.localDateTime();
            this.zonedTime();
            this.localTime();
            this.duration();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.cache.values().iterator();
    }

    static interface Factory<T> {
        public T newDate() throws IOException;

        public T newLocalDateTime() throws IOException;

        public T newZonedDateTime() throws IOException;

        public T newLocalTime() throws IOException;

        public T newZonedTime() throws IOException;

        public T newDuration() throws IOException;
    }

    static enum Offset {
        date,
        localDateTime,
        zonedDateTime,
        localTime,
        zonedTime,
        duration;

    }
}

