/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.neo4j.values.storable.CoordinateReferenceSystem;

class SpatialIndexCache<T>
implements Iterable<T> {
    private final Factory<T> factory;
    private Map<CoordinateReferenceSystem, T> spatials = new ConcurrentHashMap<CoordinateReferenceSystem, T>();

    SpatialIndexCache(Factory<T> factory) {
        this.factory = factory;
    }

    T uncheckedSelect(CoordinateReferenceSystem crs) {
        return (T)this.spatials.computeIfAbsent(crs, key -> {
            try {
                return this.factory.newSpatial(crs);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    T select(CoordinateReferenceSystem crs) throws IOException {
        try {
            return this.uncheckedSelect(crs);
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    <RESULT> RESULT selectOrElse(CoordinateReferenceSystem crs, Function<T, RESULT> function, RESULT orElse) {
        T part = this.spatials.get(crs);
        if (part == null) {
            return orElse;
        }
        return function.apply(part);
    }

    void loadAll() {
        for (CoordinateReferenceSystem crs : CoordinateReferenceSystem.all()) {
            this.uncheckedSelect(crs);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.spatials.values().iterator();
    }

    static interface Factory<T> {
        public T newSpatial(CoordinateReferenceSystem var1) throws IOException;
    }
}

