/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.builtinprocs;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.neo4j.function.Predicates;
import org.neo4j.internal.kernel.api.CapableIndexReference;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.builtinprocs.IndexSpecifier;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingMode;

public class IndexProcedures
implements AutoCloseable {
    private final KernelTransaction ktx;
    private final Statement statement;
    private final IndexingService indexingService;

    public IndexProcedures(KernelTransaction tx, IndexingService indexingService) {
        this.ktx = tx;
        this.statement = tx.acquireStatement();
        this.indexingService = indexingService;
    }

    public void awaitIndex(String indexSpecification, long timeout, TimeUnit timeoutUnits) throws ProcedureException {
        IndexSpecifier index = this.parse(indexSpecification);
        int labelId = this.getLabelId(index.label());
        int[] propertyKeyIds = this.getPropertyIds(index.properties());
        this.waitUntilOnline((IndexReference)this.getIndex(labelId, propertyKeyIds, index), index, timeout, timeoutUnits);
    }

    public void resampleIndex(String indexSpecification) throws ProcedureException {
        IndexSpecifier index = this.parse(indexSpecification);
        int labelId = this.getLabelId(index.label());
        int[] propertyKeyIds = this.getPropertyIds(index.properties());
        try {
            this.triggerSampling((IndexReference)this.getIndex(labelId, propertyKeyIds, index));
        }
        catch (IndexNotFoundKernelException e) {
            throw new ProcedureException(e.status(), e.getMessage(), new Object[]{e});
        }
    }

    public void resampleOutdatedIndexes() {
        this.indexingService.triggerIndexSampling(IndexSamplingMode.TRIGGER_REBUILD_UPDATED);
    }

    private IndexSpecifier parse(String specification) {
        return new IndexSpecifier(specification);
    }

    private int getLabelId(String labelName) throws ProcedureException {
        int labelId = this.ktx.tokenRead().nodeLabel(labelName);
        if (labelId == -1) {
            throw new ProcedureException((Status)Status.Schema.LabelAccessFailed, "No such label %s", new Object[]{labelName});
        }
        return labelId;
    }

    private int[] getPropertyIds(String[] propertyKeyNames) throws ProcedureException {
        int[] propertyKeyIds = new int[propertyKeyNames.length];
        for (int i = 0; i < propertyKeyIds.length; ++i) {
            int propertyKeyId = this.ktx.tokenRead().propertyKey(propertyKeyNames[i]);
            if (propertyKeyId == -1) {
                throw new ProcedureException((Status)Status.Schema.PropertyKeyAccessFailed, "No such property key %s", (Object[])propertyKeyNames);
            }
            propertyKeyIds[i] = propertyKeyId;
        }
        return propertyKeyIds;
    }

    private CapableIndexReference getIndex(int labelId, int[] propertyKeyIds, IndexSpecifier index) throws ProcedureException {
        CapableIndexReference indexReference = this.ktx.schemaRead().index(labelId, propertyKeyIds);
        if (indexReference == CapableIndexReference.NO_INDEX) {
            throw new ProcedureException((Status)Status.Schema.IndexNotFound, "No index on %s", new Object[]{index});
        }
        return indexReference;
    }

    private void waitUntilOnline(IndexReference index, IndexSpecifier indexDescription, long timeout, TimeUnit timeoutUnits) throws ProcedureException {
        try {
            Predicates.awaitEx(() -> this.isOnline(indexDescription, index), (long)timeout, (TimeUnit)timeoutUnits);
        }
        catch (TimeoutException e) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureTimedOut, "Index on %s did not come online within %s %s", new Object[]{indexDescription, timeout, timeoutUnits});
        }
    }

    private boolean isOnline(IndexSpecifier indexDescription, IndexReference index) throws ProcedureException {
        InternalIndexState state = this.getState(indexDescription, index);
        switch (state) {
            case POPULATING: {
                return false;
            }
            case ONLINE: {
                return true;
            }
            case FAILED: {
                throw new ProcedureException((Status)Status.Schema.IndexCreationFailed, "Index on %s is in failed state", new Object[]{indexDescription});
            }
        }
        throw new IllegalStateException("Unknown index state " + state);
    }

    private InternalIndexState getState(IndexSpecifier indexDescription, IndexReference index) throws ProcedureException {
        try {
            return this.ktx.schemaRead().indexGetState(index);
        }
        catch (IndexNotFoundKernelException e) {
            throw new ProcedureException((Status)Status.Schema.IndexNotFound, (Throwable)e, "No index on %s", new Object[]{indexDescription});
        }
    }

    private void triggerSampling(IndexReference index) throws IndexNotFoundKernelException {
        this.indexingService.triggerIndexSampling((SchemaDescriptor)SchemaDescriptorFactory.forLabel(index.label(), index.properties()), IndexSamplingMode.TRIGGER_REBUILD_ALL);
    }

    @Override
    public void close() {
        this.statement.close();
    }
}

