/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.scheduler;

import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.scheduler.JobScheduler;

final class GroupedDaemonThreadFactory
implements ThreadFactory,
ForkJoinPool.ForkJoinWorkerThreadFactory {
    private final JobScheduler.Group group;
    private final ThreadGroup threadGroup;

    GroupedDaemonThreadFactory(JobScheduler.Group group, ThreadGroup parentThreadGroup) {
        this.group = group;
        this.threadGroup = new ThreadGroup(parentThreadGroup, group.name());
    }

    @Override
    public Thread newThread(Runnable job) {
        Thread thread = new Thread(this.threadGroup, job, this.group.threadName());
        thread.setDaemon(true);
        return thread;
    }

    @Override
    public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
        ForkJoinPool.ForkJoinWorkerThreadFactory factory = ForkJoinPool.defaultForkJoinWorkerThreadFactory;
        AtomicReference reference = new AtomicReference();
        Thread allocator = this.newThread(() -> reference.set(factory.newThread(pool)));
        allocator.start();
        do {
            try {
                allocator.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (reference.get() == null);
        ForkJoinWorkerThread worker = (ForkJoinWorkerThread)reference.get();
        worker.setName(this.group.threadName());
        return worker;
    }
}

