/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Arrays;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveArrays;
import org.neo4j.collection.primitive.PrimitiveLongCollection;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.helpers.RelationshipSelectionCursor;
import org.neo4j.internal.kernel.api.helpers.RelationshipSelections;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.locking.ResourceTypes;

class TwoPhaseNodeForRelationshipLocking {
    private final ThrowingConsumer<Long, KernelException> relIdAction;
    private long firstRelId;
    private long[] sortedNodeIds;
    private static final long[] EMPTY = new long[0];

    TwoPhaseNodeForRelationshipLocking(ThrowingConsumer<Long, KernelException> relIdAction) {
        this.relIdAction = relIdAction;
    }

    void lockAllNodesAndConsumeRelationships(long nodeId, KernelTransactionImplementation transaction) throws KernelException {
        boolean retry;
        do {
            retry = false;
            this.firstRelId = -1L;
            this.collectAndSortNodeIds(nodeId, transaction);
            this.lockAllNodes(transaction, this.sortedNodeIds);
            NodeCursor nodes = transaction.nodeCursor();
            Read read = transaction.dataRead();
            read.singleNode(nodeId, nodes);
            if (!nodes.next()) continue;
            RelationshipSelectionCursor rels = RelationshipSelections.allCursor((CursorFactory)transaction.cursors(), (NodeCursor)nodes, null);
            boolean first = true;
            while (rels.next() && !retry) {
                retry = this.performAction(transaction, rels.relationshipReference(), first);
                first = false;
            }
        } while (retry);
    }

    private void collectAndSortNodeIds(long nodeId, KernelTransaction transaction) throws EntityNotFoundException {
        PrimitiveLongSet nodeIdSet = Primitive.longSet();
        nodeIdSet.add(nodeId);
        NodeCursor nodes = transaction.nodeCursor();
        Read read = transaction.dataRead();
        read.singleNode(nodeId, nodes);
        if (!nodes.next()) {
            this.sortedNodeIds = EMPTY;
            return;
        }
        RelationshipSelectionCursor rels = RelationshipSelections.allCursor((CursorFactory)transaction.cursors(), (NodeCursor)nodes, null);
        while (rels.next()) {
            if (this.firstRelId == -1L) {
                this.firstRelId = rels.relationshipReference();
            }
            nodeIdSet.add(rels.sourceNodeReference());
            nodeIdSet.add(rels.targetNodeReference());
        }
        long[] nodeIds = PrimitiveArrays.of((PrimitiveLongCollection)nodeIdSet);
        Arrays.sort(nodeIds);
        this.sortedNodeIds = nodeIds;
    }

    private void lockAllNodes(KernelTransactionImplementation transaction, long[] nodeIds) {
        transaction.statementLocks().optimistic().acquireExclusive(transaction.lockTracer(), ResourceTypes.NODE, nodeIds);
    }

    private void unlockAllNodes(KernelTransactionImplementation transaction, long[] nodeIds) {
        for (long nodeId : nodeIds) {
            transaction.statementLocks().optimistic().releaseExclusive(ResourceTypes.NODE, nodeId);
        }
    }

    private boolean performAction(KernelTransactionImplementation transaction, long rel, boolean first) throws KernelException {
        if (first && rel != this.firstRelId) {
            this.unlockAllNodes(transaction, this.sortedNodeIds);
            this.sortedNodeIds = null;
            return true;
        }
        this.relIdAction.accept((Object)rel);
        return false;
    }
}

