/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Iterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.NamedToken;
import org.neo4j.internal.kernel.api.Token;
import org.neo4j.internal.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.internal.kernel.api.exceptions.schema.TooManyLabelsException;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.kernel.api.exceptions.RelationshipTypeIdNotFoundKernelException;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.storageengine.api.StoreReadLayer;

public class KernelToken
implements Token {
    private final StoreReadLayer store;
    private final KernelTransactionImplementation ktx;

    public KernelToken(StoreReadLayer store, KernelTransactionImplementation ktx) {
        this.store = store;
        this.ktx = ktx;
    }

    public int labelGetOrCreateForName(String labelName) throws IllegalTokenNameException, TooManyLabelsException {
        this.ktx.assertOpen();
        int labelId = this.store.labelGetForName(this.checkValidTokenName(labelName));
        if (labelId != -1) {
            return labelId;
        }
        this.ktx.assertAllows(AccessMode::allowsTokenCreates, "Token create");
        return this.store.labelGetOrCreateForName(labelName);
    }

    public void labelCreateForName(String labelName, int id) throws IllegalTokenNameException, TooManyLabelsException {
        this.ktx.assertOpen();
        this.ktx.txState().labelDoCreateForName(labelName, id);
    }

    public void relationshipTypeCreateForName(String relationshipTypeName, int id) throws IllegalTokenNameException {
        this.ktx.assertOpen();
        this.ktx.txState().relationshipTypeDoCreateForName(relationshipTypeName, id);
    }

    public void propertyKeyCreateForName(String propertyKeyName, int id) throws IllegalTokenNameException {
        this.ktx.assertOpen();
        this.ktx.txState().propertyKeyDoCreateForName(propertyKeyName, id);
    }

    public int propertyKeyGetOrCreateForName(String propertyKeyName) throws IllegalTokenNameException {
        this.ktx.assertOpen();
        int propertyId = this.store.propertyKeyGetForName(this.checkValidTokenName(propertyKeyName));
        if (propertyId != -1) {
            return propertyId;
        }
        this.ktx.assertAllows(AccessMode::allowsTokenCreates, "Token create");
        return this.store.propertyKeyGetOrCreateForName(propertyKeyName);
    }

    public int relationshipTypeGetOrCreateForName(String relationshipTypeName) throws IllegalTokenNameException {
        this.ktx.assertOpen();
        int typeId = this.store.relationshipTypeGetForName(this.checkValidTokenName(relationshipTypeName));
        if (typeId != -1) {
            return typeId;
        }
        this.ktx.assertAllows(AccessMode::allowsTokenCreates, "Token create");
        return this.store.relationshipTypeGetOrCreateForName(relationshipTypeName);
    }

    public String nodeLabelName(int labelId) throws LabelNotFoundKernelException {
        this.ktx.assertOpen();
        return this.store.labelGetName(labelId);
    }

    public int nodeLabel(String name) {
        this.ktx.assertOpen();
        return this.store.labelGetForName(name);
    }

    public int relationshipType(String name) {
        this.ktx.assertOpen();
        return this.store.relationshipTypeGetForName(name);
    }

    public String relationshipTypeName(int relationshipTypeId) throws RelationshipTypeIdNotFoundKernelException {
        this.ktx.assertOpen();
        return this.store.relationshipTypeGetName(relationshipTypeId);
    }

    public int propertyKey(String name) {
        this.ktx.assertOpen();
        return this.store.propertyKeyGetForName(name);
    }

    public String propertyKeyName(int propertyKeyId) throws PropertyKeyIdNotFoundKernelException {
        this.ktx.assertOpen();
        return this.store.propertyKeyGetName(propertyKeyId);
    }

    public Iterator<NamedToken> labelsGetAllTokens() {
        this.ktx.assertOpen();
        return Iterators.map(token -> new NamedToken(token.name(), token.id()), this.store.labelsGetAllTokens());
    }

    public Iterator<NamedToken> propertyKeyGetAllTokens() {
        this.ktx.assertOpen();
        AccessMode mode = this.ktx.securityContext().mode();
        return Iterators.stream(this.store.propertyKeyGetAllTokens()).filter(propKey -> mode.allowsPropertyReads(propKey.id())).map(token -> new NamedToken(token.name(), token.id())).iterator();
    }

    public Iterator<NamedToken> relationshipTypesGetAllTokens() {
        this.ktx.assertOpen();
        return Iterators.map(token -> new NamedToken(token.name(), token.id()), this.store.relationshipTypeGetAllTokens());
    }

    private String checkValidTokenName(String name) throws IllegalTokenNameException {
        if (name == null || name.isEmpty()) {
            throw new IllegalTokenNameException(name);
        }
        return name;
    }
}

