/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexBase;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexProvider;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexSampler;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexUpdater;
import org.neo4j.storageengine.api.schema.IndexSample;

class FusionIndexPopulator
extends FusionIndexBase<IndexPopulator>
implements IndexPopulator {
    private final long indexId;
    private final FusionIndexProvider.DropAction dropAction;

    FusionIndexPopulator(IndexPopulator[] populators, FusionIndexProvider.Selector selector, long indexId, FusionIndexProvider.DropAction dropAction) {
        super(populators, selector);
        this.indexId = indexId;
        this.dropAction = dropAction;
    }

    @Override
    public void create() throws IOException {
        FusionIndexPopulator.forAll(IndexPopulator::create, this.instances);
    }

    @Override
    public void drop() throws IOException {
        FusionIndexPopulator.forAll(IndexPopulator::drop, this.instances);
        this.dropAction.drop(this.indexId);
    }

    @Override
    public void add(Collection<? extends IndexEntryUpdate<?>> updates) throws IndexEntryConflictException, IOException {
        Collection[] batches = new Collection[((IndexPopulator[])this.instances).length];
        for (IndexEntryUpdate<?> update : updates) {
            int slot = this.selector.selectSlot(update.values());
            ArrayList batch = batches[slot];
            if (batch == null) {
                batches[slot] = batch = new ArrayList();
            }
            batch.add(update);
        }
        for (int i = 0; i < ((IndexPopulator[])this.instances).length; ++i) {
            if (batches[i] == null) continue;
            ((IndexPopulator[])this.instances)[i].add(batches[i]);
        }
    }

    @Override
    public void verifyDeferredConstraints(PropertyAccessor propertyAccessor) throws IndexEntryConflictException, IOException {
        for (IndexPopulator populator : (IndexPopulator[])this.instances) {
            populator.verifyDeferredConstraints(propertyAccessor);
        }
    }

    @Override
    public IndexUpdater newPopulatingUpdater(PropertyAccessor accessor) throws IOException {
        return new FusionIndexUpdater(this.instancesAs(IndexUpdater.class, populator -> populator.newPopulatingUpdater(accessor)), this.selector);
    }

    @Override
    public void close(boolean populationCompletedSuccessfully) throws IOException {
        FusionIndexPopulator.forAll(populator -> populator.close(populationCompletedSuccessfully), this.instances);
    }

    @Override
    public void markAsFailed(String failure) throws IOException {
        FusionIndexPopulator.forAll(populator -> populator.markAsFailed(failure), this.instances);
    }

    @Override
    public void includeSample(IndexEntryUpdate<?> update) {
        ((IndexPopulator)this.selector.select(this.instances, update.values())).includeSample(update);
    }

    @Override
    public IndexSample sampleResult() {
        return FusionIndexSampler.combineSamples(this.instancesAs(IndexSample.class, IndexPopulator::sampleResult));
    }
}

