/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.index.schema.DateLayout;
import org.neo4j.kernel.impl.index.schema.DateSchemaKey;
import org.neo4j.kernel.impl.index.schema.DurationLayout;
import org.neo4j.kernel.impl.index.schema.DurationSchemaKey;
import org.neo4j.kernel.impl.index.schema.LocalDateTimeLayout;
import org.neo4j.kernel.impl.index.schema.LocalDateTimeSchemaKey;
import org.neo4j.kernel.impl.index.schema.LocalTimeLayout;
import org.neo4j.kernel.impl.index.schema.LocalTimeSchemaKey;
import org.neo4j.kernel.impl.index.schema.NativeSchemaKey;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.kernel.impl.index.schema.TemporalIndexCache;
import org.neo4j.kernel.impl.index.schema.ZonedDateTimeLayout;
import org.neo4j.kernel.impl.index.schema.ZonedDateTimeSchemaKey;
import org.neo4j.kernel.impl.index.schema.ZonedTimeLayout;
import org.neo4j.kernel.impl.index.schema.ZonedTimeSchemaKey;
import org.neo4j.values.storable.ValueGroup;

class TemporalIndexFiles {
    private final FileSystemAbstraction fs;
    private FileLayout<DateSchemaKey> date;
    private FileLayout<LocalDateTimeSchemaKey> localDateTime;
    private FileLayout<ZonedDateTimeSchemaKey> zonedDateTime;
    private FileLayout<LocalTimeSchemaKey> localTime;
    private FileLayout<ZonedTimeSchemaKey> zonedTime;
    private FileLayout<DurationSchemaKey> duration;

    TemporalIndexFiles(IndexDirectoryStructure directoryStructure, long indexId, SchemaIndexDescriptor descriptor, FileSystemAbstraction fs) {
        this.fs = fs;
        File indexDirectory = directoryStructure.directoryForIndex(indexId);
        this.date = new FileLayout(new File(indexDirectory, "date"), new DateLayout(), ValueGroup.DATE);
        this.localTime = new FileLayout(new File(indexDirectory, "localTime"), new LocalTimeLayout(), ValueGroup.LOCAL_TIME);
        this.zonedTime = new FileLayout(new File(indexDirectory, "zonedTime"), new ZonedTimeLayout(), ValueGroup.ZONED_TIME);
        this.localDateTime = new FileLayout(new File(indexDirectory, "localDateTime"), new LocalDateTimeLayout(), ValueGroup.LOCAL_DATE_TIME);
        this.zonedDateTime = new FileLayout(new File(indexDirectory, "zonedDateTime"), new ZonedDateTimeLayout(), ValueGroup.ZONED_DATE_TIME);
        this.duration = new FileLayout(new File(indexDirectory, "duration"), new DurationLayout(), ValueGroup.DURATION);
    }

    Iterable<FileLayout> existing() {
        ArrayList<FileLayout> existing = new ArrayList<FileLayout>();
        this.addIfExists(existing, this.date);
        this.addIfExists(existing, this.localDateTime);
        this.addIfExists(existing, this.zonedDateTime);
        this.addIfExists(existing, this.localTime);
        this.addIfExists(existing, this.zonedTime);
        this.addIfExists(existing, this.duration);
        return existing;
    }

    <T, E extends Exception> void loadExistingIndexes(TemporalIndexCache<T, E> indexCache) throws E {
        for (FileLayout fileLayout : this.existing()) {
            indexCache.select(fileLayout.valueGroup);
        }
    }

    FileLayout<DateSchemaKey> date() {
        return this.date;
    }

    FileLayout<LocalTimeSchemaKey> localTime() {
        return this.localTime;
    }

    FileLayout<ZonedTimeSchemaKey> zonedTime() {
        return this.zonedTime;
    }

    FileLayout<LocalDateTimeSchemaKey> localDateTime() {
        return this.localDateTime;
    }

    FileLayout<ZonedDateTimeSchemaKey> zonedDateTime() {
        return this.zonedDateTime;
    }

    FileLayout<DurationSchemaKey> duration() {
        return this.duration;
    }

    private void addIfExists(List<FileLayout> existing, FileLayout fileLayout) {
        if (this.exists(fileLayout)) {
            existing.add(fileLayout);
        }
    }

    private boolean exists(FileLayout fileLayout) {
        return fileLayout != null && this.fs.fileExists(fileLayout.indexFile);
    }

    static class FileLayout<KEY extends NativeSchemaKey<KEY>> {
        final File indexFile;
        final Layout<KEY, NativeSchemaValue> layout;
        final ValueGroup valueGroup;

        FileLayout(File indexFile, Layout<KEY, NativeSchemaValue> layout, ValueGroup valueGroup) {
            this.indexFile = indexFile;
            this.layout = layout;
            this.valueGroup = valueGroup;
        }
    }
}

