/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableClosableChannel;
import org.neo4j.unsafe.impl.batchimport.InputIterator;
import org.neo4j.unsafe.impl.batchimport.input.ByteBufferReadableChannel;
import org.neo4j.unsafe.impl.batchimport.input.Group;
import org.neo4j.unsafe.impl.batchimport.input.InputCache;
import org.neo4j.unsafe.impl.batchimport.input.InputChunk;
import org.neo4j.unsafe.impl.batchimport.input.InputEntityVisitor;
import org.neo4j.unsafe.impl.batchimport.input.InputException;
import org.neo4j.unsafe.impl.batchimport.input.ValueType;

abstract class InputEntityCacheReader
implements InputIterator {
    private final PrimitiveIntObjectMap<String>[] tokens;
    private final StoreChannel channel;
    private final ByteBuffer chunkHeaderBuffer = InputCache.newChunkHeaderBuffer();
    private boolean end;

    InputEntityCacheReader(StoreChannel channel, StoreChannel header) throws IOException {
        this.tokens = new PrimitiveIntObjectMap[4];
        this.tokens[0] = Primitive.intObjectMap();
        this.tokens[1] = Primitive.intObjectMap();
        this.tokens[2] = Primitive.intObjectMap();
        this.tokens[3] = Primitive.intObjectMap();
        this.channel = channel;
        this.readHeader(header);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean next(InputChunk chunk) throws IOException {
        long dataStartPosition;
        int length;
        InputEntityDeserializer realChunk = (InputEntityDeserializer)chunk;
        StoreChannel storeChannel = this.channel;
        synchronized (storeChannel) {
            if (this.end) {
                return false;
            }
            this.chunkHeaderBuffer.clear();
            this.channel.read(this.chunkHeaderBuffer);
            this.chunkHeaderBuffer.flip();
            length = this.chunkHeaderBuffer.getInt();
            dataStartPosition = this.channel.position();
            this.channel.position(dataStartPosition + (long)length);
            if (length == 0) {
                this.end = true;
                return false;
            }
        }
        realChunk.initialize(dataStartPosition, length);
        return true;
    }

    private static ReadAheadChannel<StoreChannel> reader(StoreChannel channel) {
        return new ReadAheadChannel<StoreChannel>(channel);
    }

    private void readHeader(StoreChannel header) throws IOException {
        try (ReadAheadChannel<StoreChannel> reader = InputEntityCacheReader.reader(header);){
            byte type;
            int[] tokenIds = new int[4];
            while ((type = reader.get()) != -2) {
                int tokenId;
                byte by = type;
                tokenIds[by] = tokenIds[by] + 1;
                String name = (String)ValueType.stringType().read(reader);
                this.tokens[type].put(tokenId, (Object)name);
            }
        }
    }

    @Override
    public void close() {
        try {
            this.channel.close();
        }
        catch (IOException e) {
            throw new InputException("Couldn't close channel for cached input data", e);
        }
    }

    abstract class InputEntityDeserializer
    implements InputChunk {
        private ByteBuffer buffer;
        protected ReadableClosableChannel channel;
        protected Group[] previousGroups = new Group[2];

        InputEntityDeserializer() {
        }

        void initialize(long startPosition, int chunkLength) throws IOException {
            if (this.buffer == null || this.buffer.capacity() < chunkLength) {
                this.buffer = ByteBuffer.allocate(chunkLength + chunkLength / 10);
                this.channel = new ByteBufferReadableChannel(this.buffer);
            }
            this.buffer.clear();
            this.buffer.limit(chunkLength);
            InputEntityCacheReader.this.channel.read(this.buffer, startPosition);
            this.buffer.flip();
            this.clearState();
        }

        protected void clearState() {
            Arrays.fill(this.previousGroups, Group.GLOBAL);
        }

        @Override
        public void close() {
        }

        protected boolean readProperties(InputEntityVisitor visitor) throws IOException {
            int count = this.channel.getShort();
            if (count == -3) {
                return false;
            }
            if (count == -1) {
                visitor.propertyId(this.channel.getLong());
            } else {
                for (int i = 0; i < count; ++i) {
                    Object token = this.readToken((byte)0);
                    Object value = this.readValue();
                    if (token instanceof Integer) {
                        visitor.property((Integer)token, value);
                        continue;
                    }
                    visitor.property((String)token, value);
                }
            }
            return true;
        }

        protected Object readToken(byte type) throws IOException {
            int id = this.channel.getInt();
            if (id == -1) {
                return this.channel.getInt();
            }
            String name = (String)InputEntityCacheReader.this.tokens[type].get(id);
            if (name == null) {
                throw new IllegalArgumentException("Unknown token " + id);
            }
            return name;
        }

        protected Object readValue() throws IOException {
            return ValueType.typeOf(this.channel.get()).read(this.channel);
        }

        protected Group readGroup(int slot) throws IOException {
            byte groupMode = this.channel.get();
            switch (groupMode) {
                case 0: {
                    return this.previousGroups[slot];
                }
                case 1: {
                    this.previousGroups[slot] = new Group.Adapter(this.channel.getInt(), (String)this.readToken((byte)3));
                    return this.previousGroups[slot];
                }
            }
            throw new IllegalArgumentException("Unknown group mode " + groupMode);
        }
    }
}

