/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.impl.core.StartupStatisticsProvider;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.util.monitoring.ProgressReporter;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.recovery.CorruptedLogsTruncator;
import org.neo4j.kernel.recovery.RecoveryApplier;
import org.neo4j.kernel.recovery.RecoveryMonitor;
import org.neo4j.kernel.recovery.RecoveryService;
import org.neo4j.kernel.recovery.RecoveryStartInformation;
import org.neo4j.storageengine.api.TransactionApplicationMode;

public class Recovery
extends LifecycleAdapter {
    private final RecoveryService recoveryService;
    private final RecoveryMonitor monitor;
    private final StartupStatisticsProvider startupStatistics;
    private final CorruptedLogsTruncator logsTruncator;
    private final ProgressReporter progressReporter;
    private final boolean failOnCorruptedLogFiles;
    private int numberOfRecoveredTransactions;

    public Recovery(RecoveryService recoveryService, StartupStatisticsProvider startupStatistics, CorruptedLogsTruncator logsTruncator, RecoveryMonitor monitor, ProgressReporter progressReporter, boolean failOnCorruptedLogFiles) {
        this.recoveryService = recoveryService;
        this.monitor = monitor;
        this.startupStatistics = startupStatistics;
        this.logsTruncator = logsTruncator;
        this.progressReporter = progressReporter;
        this.failOnCorruptedLogFiles = failOnCorruptedLogFiles;
    }

    public void init() throws IOException {
        RecoveryStartInformation recoveryStartInformation = this.recoveryService.getRecoveryStartInformation();
        if (!recoveryStartInformation.isRecoveryRequired()) {
            return;
        }
        LogPosition recoveryPosition = recoveryStartInformation.getRecoveryPosition();
        this.monitor.recoveryRequired(recoveryPosition);
        this.recoveryService.startRecovery();
        LogPosition recoveryToPosition = recoveryPosition;
        CommittedTransactionRepresentation lastTransaction = null;
        CommittedTransactionRepresentation lastReversedTransaction = null;
        try {
            Throwable throwable;
            RecoveryApplier recoveryVisitor;
            long lowestRecoveredTxId = 1L;
            try (TransactionCursor transactionsToRecover = this.recoveryService.getTransactionsInReverseOrder(recoveryPosition);){
                recoveryVisitor = this.recoveryService.getRecoveryApplier(TransactionApplicationMode.REVERSE_RECOVERY);
                throwable = null;
                try {
                    while (transactionsToRecover.next()) {
                        CommittedTransactionRepresentation transaction = (CommittedTransactionRepresentation)transactionsToRecover.get();
                        if (lastReversedTransaction == null) {
                            lastReversedTransaction = transaction;
                            this.initProgressReporter(recoveryStartInformation, lastReversedTransaction);
                        }
                        recoveryVisitor.visit(transaction);
                        lowestRecoveredTxId = transaction.getCommitEntry().getTxId();
                        this.reportProgress();
                    }
                }
                catch (Throwable transaction) {
                    throwable = transaction;
                    throw transaction;
                }
                finally {
                    if (recoveryVisitor != null) {
                        if (throwable != null) {
                            try {
                                recoveryVisitor.close();
                            }
                            catch (Throwable transaction) {
                                throwable.addSuppressed(transaction);
                            }
                        } else {
                            recoveryVisitor.close();
                        }
                    }
                }
            }
            this.monitor.reverseStoreRecoveryCompleted(lowestRecoveredTxId);
            transactionsToRecover = this.recoveryService.getTransactions(recoveryPosition);
            var9_9 = null;
            try {
                recoveryVisitor = this.recoveryService.getRecoveryApplier(TransactionApplicationMode.RECOVERY);
                throwable = null;
                try {
                    while (transactionsToRecover.next()) {
                        lastTransaction = (CommittedTransactionRepresentation)transactionsToRecover.get();
                        long txId = lastTransaction.getCommitEntry().getTxId();
                        recoveryVisitor.visit(lastTransaction);
                        this.monitor.transactionRecovered(txId);
                        ++this.numberOfRecoveredTransactions;
                        recoveryToPosition = transactionsToRecover.position();
                        this.reportProgress();
                    }
                    recoveryToPosition = transactionsToRecover.position();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (recoveryVisitor != null) {
                        if (throwable != null) {
                            try {
                                recoveryVisitor.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            recoveryVisitor.close();
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                var9_9 = throwable4;
                throw throwable4;
            }
            finally {
                if (transactionsToRecover != null) {
                    if (var9_9 != null) {
                        try {
                            transactionsToRecover.close();
                        }
                        catch (Throwable throwable5) {
                            var9_9.addSuppressed(throwable5);
                        }
                    } else {
                        transactionsToRecover.close();
                    }
                }
            }
        }
        catch (Throwable t) {
            if (this.failOnCorruptedLogFiles) {
                Exceptions.throwIfUnchecked((Throwable)t);
                throw new RuntimeException(t);
            }
            if (lastTransaction != null) {
                LogEntryCommit commitEntry = lastTransaction.getCommitEntry();
                this.monitor.failToRecoverTransactionsAfterCommit(t, commitEntry, recoveryToPosition);
            }
            this.monitor.failToRecoverTransactionsAfterPosition(t, recoveryPosition);
            recoveryToPosition = recoveryPosition;
        }
        this.progressReporter.completed();
        this.logsTruncator.truncate(recoveryToPosition);
        this.recoveryService.transactionsRecovered(lastTransaction, recoveryToPosition);
        this.startupStatistics.setNumberOfRecoveredTransactions(this.numberOfRecoveredTransactions);
        this.monitor.recoveryCompleted(this.numberOfRecoveredTransactions);
    }

    private void initProgressReporter(RecoveryStartInformation recoveryStartInformation, CommittedTransactionRepresentation lastReversedTransaction) {
        long numberOfTransactionToRecover = this.getNumberOfTransactionToRecover(recoveryStartInformation, lastReversedTransaction);
        this.progressReporter.start(numberOfTransactionToRecover * 2L);
    }

    private void reportProgress() {
        this.progressReporter.progress(1L);
    }

    private long getNumberOfTransactionToRecover(RecoveryStartInformation recoveryStartInformation, CommittedTransactionRepresentation lastReversedTransaction) {
        return lastReversedTransaction.getCommitEntry().getTxId() - recoveryStartInformation.getFirstTxIdAfterLastCheckPoint() + 1L;
    }
}

