/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.spatial.CRS;
import org.neo4j.graphdb.spatial.Coordinate;
import org.neo4j.graphdb.spatial.Geometry;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.kernel.impl.util.NodeProxyWrappingNodeValue;
import org.neo4j.kernel.impl.util.PathWrappingPathValue;
import org.neo4j.kernel.impl.util.RelationshipProxyWrappingValue;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.PathValue;
import org.neo4j.values.virtual.RelationshipValue;
import org.neo4j.values.virtual.VirtualValues;

public final class ValueUtils {
    private ValueUtils() {
        throw new UnsupportedOperationException("do not instantiate");
    }

    public static AnyValue of(Object object) {
        Value value = Values.unsafeOf((Object)object, (boolean)true);
        if (value != null) {
            return value;
        }
        if (object instanceof Entity) {
            if (object instanceof Node) {
                return ValueUtils.fromNodeProxy((Node)object);
            }
            if (object instanceof Relationship) {
                return ValueUtils.fromRelationshipProxy((Relationship)object);
            }
            throw new IllegalArgumentException("Unknown entity + " + object.getClass().getName());
        }
        if (object instanceof Iterable) {
            if (object instanceof Path) {
                return ValueUtils.fromPath((Path)object);
            }
            if (object instanceof List) {
                return ValueUtils.asListValue((List)object);
            }
            return ValueUtils.asListValue((Iterable)object);
        }
        if (object instanceof Map) {
            return ValueUtils.asMapValue((Map)object);
        }
        if (object instanceof Iterator) {
            ArrayList objects = new ArrayList();
            Iterator iterator = (Iterator)object;
            while (iterator.hasNext()) {
                objects.add(iterator.next());
            }
            return ValueUtils.asListValue(objects);
        }
        if (object instanceof Object[]) {
            Object[] array = (Object[])object;
            AnyValue[] anyValues = new AnyValue[array.length];
            for (int i = 0; i < array.length; ++i) {
                anyValues[i] = ValueUtils.of(array[i]);
            }
            return VirtualValues.list((AnyValue[])anyValues);
        }
        if (object instanceof Stream) {
            return ValueUtils.asListValue(((Stream)object).collect(Collectors.toList()));
        }
        if (object instanceof Geometry) {
            return ValueUtils.asGeometryValue((Geometry)object);
        }
        throw new IllegalArgumentException(String.format("Cannot convert %s to AnyValue", object.getClass().getName()));
    }

    public static PointValue asPointValue(Point point) {
        return ValueUtils.toPoint((Geometry)point);
    }

    public static PointValue asGeometryValue(Geometry geometry) {
        if (!geometry.getGeometryType().equals("Point")) {
            throw new IllegalArgumentException("Cannot handle geometry type: " + geometry.getCRS().getType());
        }
        return ValueUtils.toPoint(geometry);
    }

    private static PointValue toPoint(Geometry geometry) {
        List coordinate = ((Coordinate)geometry.getCoordinates().get(0)).getCoordinate();
        double[] primitiveCoordinate = new double[coordinate.size()];
        for (int i = 0; i < coordinate.size(); ++i) {
            primitiveCoordinate[i] = (Double)coordinate.get(i);
        }
        return Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.get((CRS)geometry.getCRS()), (double[])primitiveCoordinate);
    }

    public static ListValue asListValue(List<?> collection) {
        ArrayList<AnyValue> values = new ArrayList<AnyValue>(collection.size());
        for (Object o : collection) {
            values.add(ValueUtils.of(o));
        }
        return VirtualValues.fromList(values);
    }

    public static ListValue asListValue(Iterable<?> collection) {
        ArrayList<AnyValue> values = new ArrayList<AnyValue>();
        for (Object o : collection) {
            values.add(ValueUtils.of(o));
        }
        return VirtualValues.fromList(values);
    }

    public static AnyValue asNodeOrEdgeValue(PropertyContainer container) {
        if (container instanceof Node) {
            return ValueUtils.fromNodeProxy((Node)container);
        }
        if (container instanceof Relationship) {
            return ValueUtils.fromRelationshipProxy((Relationship)container);
        }
        throw new IllegalArgumentException("Cannot produce a node or edge from " + container.getClass().getName());
    }

    public static ListValue asListOfEdges(Iterable<Relationship> rels) {
        return VirtualValues.list((AnyValue[])((AnyValue[])StreamSupport.stream(rels.spliterator(), false).map(ValueUtils::fromRelationshipProxy).toArray(RelationshipValue[]::new)));
    }

    public static ListValue asListOfEdges(Relationship[] rels) {
        RelationshipValue[] relValues = new RelationshipValue[rels.length];
        for (int i = 0; i < relValues.length; ++i) {
            relValues[i] = ValueUtils.fromRelationshipProxy(rels[i]);
        }
        return VirtualValues.list((AnyValue[])relValues);
    }

    public static MapValue asMapValue(Map<String, Object> map) {
        return VirtualValues.map(ValueUtils.mapValues(map));
    }

    private static Map<String, AnyValue> mapValues(Map<String, Object> map) {
        HashMap<String, AnyValue> newMap = new HashMap<String, AnyValue>(map.size());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            newMap.put(entry.getKey(), ValueUtils.of(entry.getValue()));
        }
        return newMap;
    }

    public static NodeValue fromNodeProxy(Node node) {
        return new NodeProxyWrappingNodeValue(node);
    }

    public static RelationshipValue fromRelationshipProxy(Relationship relationship) {
        return new RelationshipProxyWrappingValue(relationship);
    }

    public static PathValue fromPath(Path path) {
        return new PathWrappingPathValue(path);
    }

    public static Value asValue(Object value) {
        if (value instanceof Value) {
            return (Value)value;
        }
        return Values.of((Object)value);
    }
}

