/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.impl.store.DynamicArrayStore;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.ShortArray;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.LongArray;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.TimeZones;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public enum TemporalType {
    TEMPORAL_INVALID(0, "Invalid"){

        @Override
        public Value decodeForTemporal(long[] valueBlocks, int offset) {
            throw new UnsupportedOperationException("Cannot decode invalid temporal");
        }

        @Override
        public int calculateNumberOfBlocksUsedForTemporal(long firstBlock) {
            return -1;
        }

        @Override
        public ArrayValue decodeArray(Value dataValue) {
            throw new UnsupportedOperationException("Cannot decode invalid temporal array");
        }
    }
    ,
    TEMPORAL_DATE(1, "Date"){

        @Override
        public Value decodeForTemporal(long[] valueBlocks, int offset) {
            long epochDay = this.valueIsInlined(valueBlocks[offset]) ? valueBlocks[offset] >>> 33 : valueBlocks[1 + offset];
            return DateValue.epochDate((long)epochDay);
        }

        @Override
        public int calculateNumberOfBlocksUsedForTemporal(long firstBlock) {
            return this.valueIsInlined(firstBlock) ? 1 : 2;
        }

        @Override
        public ArrayValue decodeArray(Value dataValue) {
            if (dataValue instanceof LongArray) {
                LongArray numbers = (LongArray)dataValue;
                LocalDate[] dates = new LocalDate[numbers.length()];
                for (int i = 0; i < dates.length; ++i) {
                    dates[i] = LocalDate.ofEpochDay(numbers.longValue(i));
                }
                return Values.dateArray((LocalDate[])dates);
            }
            throw new InvalidRecordException("Array with unexpected type. Actual:" + dataValue.getClass().getSimpleName() + ". Expected: LongArray.");
        }

        private boolean valueIsInlined(long firstBlock) {
            return (firstBlock & 0x100000000L) > 0L;
        }
    }
    ,
    TEMPORAL_LOCAL_TIME(2, "LocalTime"){

        @Override
        public Value decodeForTemporal(long[] valueBlocks, int offset) {
            long nanoOfDay = this.valueIsInlined(valueBlocks[offset]) ? valueBlocks[offset] >>> 33 : valueBlocks[1 + offset];
            return LocalTimeValue.localTime((long)nanoOfDay);
        }

        @Override
        public int calculateNumberOfBlocksUsedForTemporal(long firstBlock) {
            return this.valueIsInlined(firstBlock) ? 1 : 2;
        }

        @Override
        public ArrayValue decodeArray(Value dataValue) {
            if (dataValue instanceof LongArray) {
                LongArray numbers = (LongArray)dataValue;
                LocalTime[] times = new LocalTime[numbers.length()];
                for (int i = 0; i < times.length; ++i) {
                    times[i] = LocalTime.ofNanoOfDay(numbers.longValue(i));
                }
                return Values.localTimeArray((LocalTime[])times);
            }
            throw new InvalidRecordException("Array with unexpected type. Actual:" + dataValue.getClass().getSimpleName() + ". Expected: LongArray.");
        }

        private boolean valueIsInlined(long firstBlock) {
            return (firstBlock & 0x100000000L) > 0L;
        }
    }
    ,
    TEMPORAL_LOCAL_DATE_TIME(3, "LocalDateTime"){

        @Override
        public Value decodeForTemporal(long[] valueBlocks, int offset) {
            long nanoOfSecond = valueBlocks[offset] >>> 32;
            long epochSecond = valueBlocks[1 + offset];
            return LocalDateTimeValue.localDateTime((long)epochSecond, (long)nanoOfSecond);
        }

        @Override
        public int calculateNumberOfBlocksUsedForTemporal(long firstBlock) {
            return 2;
        }

        @Override
        public ArrayValue decodeArray(Value dataValue) {
            if (dataValue instanceof LongArray) {
                LongArray numbers = (LongArray)dataValue;
                LocalDateTime[] dateTimes = new LocalDateTime[numbers.length() / 2];
                for (int i = 0; i < dateTimes.length; ++i) {
                    dateTimes[i] = LocalDateTime.ofInstant(Instant.ofEpochSecond(numbers.longValue(i * 2), numbers.longValue(i * 2 + 1)), ZoneOffset.UTC);
                }
                return Values.localDateTimeArray((LocalDateTime[])dateTimes);
            }
            throw new InvalidRecordException("Array with unexpected type. Actual:" + dataValue.getClass().getSimpleName() + ". Expected: LongArray.");
        }
    }
    ,
    TEMPORAL_TIME(4, "Time"){

        @Override
        public Value decodeForTemporal(long[] valueBlocks, int offset) {
            int minuteOffset = (int)(valueBlocks[offset] >>> 32);
            long nanoOfDay = valueBlocks[1 + offset];
            return TimeValue.time((long)nanoOfDay, (ZoneOffset)ZoneOffset.ofTotalSeconds(minuteOffset * 60));
        }

        @Override
        public int calculateNumberOfBlocksUsedForTemporal(long firstBlock) {
            return 2;
        }

        @Override
        public ArrayValue decodeArray(Value dataValue) {
            if (dataValue instanceof LongArray) {
                LongArray numbers = (LongArray)dataValue;
                OffsetTime[] times = new OffsetTime[(int)((double)numbers.length() / 1.25)];
                for (int i = 0; i < times.length; ++i) {
                    long nanoOfDay = numbers.longValue(i);
                    int shift = i % 4 * 16;
                    short minuteOffset = (short)(numbers.longValue(times.length + i / 4) >>> shift);
                    times[i] = OffsetTime.of(LocalTime.ofNanoOfDay(nanoOfDay), ZoneOffset.ofTotalSeconds(minuteOffset * 60));
                }
                return Values.timeArray((OffsetTime[])times);
            }
            throw new InvalidRecordException("Array with unexpected type. Actual:" + dataValue.getClass().getSimpleName() + ". Expected: LongArray.");
        }
    }
    ,
    TEMPORAL_DATE_TIME(5, "DateTime"){

        @Override
        public Value decodeForTemporal(long[] valueBlocks, int offset) {
            if (this.storingZoneOffset(valueBlocks[offset])) {
                int nanoOfSecond = (int)(valueBlocks[offset] >>> 33);
                long epochSecond = valueBlocks[1 + offset];
                int minuteOffset = (int)valueBlocks[2 + offset];
                return DateTimeValue.datetime((long)epochSecond, (long)nanoOfSecond, (ZoneOffset)ZoneOffset.ofTotalSeconds(minuteOffset * 60));
            }
            int nanoOfSecond = (int)(valueBlocks[offset] >>> 33);
            long epochSecond = valueBlocks[1 + offset];
            short zoneNumber = (short)valueBlocks[2 + offset];
            return DateTimeValue.datetime((long)epochSecond, (long)nanoOfSecond, (ZoneId)ZoneId.of(TimeZones.map((short)zoneNumber)));
        }

        @Override
        public int calculateNumberOfBlocksUsedForTemporal(long firstBlock) {
            return 3;
        }

        @Override
        public ArrayValue decodeArray(Value dataValue) {
            if (dataValue instanceof LongArray) {
                LongArray numbers = (LongArray)dataValue;
                ZonedDateTime[] dateTimes = new ZonedDateTime[numbers.length() / 3];
                for (int i = 0; i < dateTimes.length; ++i) {
                    long epochSecond = numbers.longValue(i * 3);
                    long nanos = numbers.longValue(i * 3 + 1);
                    long zoneValue = numbers.longValue(i * 3 + 2);
                    if ((zoneValue & 1L) == 1L) {
                        short minuteOffset = (short)(zoneValue >>> 1);
                        dateTimes[i] = ZonedDateTime.ofInstant(Instant.ofEpochSecond(epochSecond, nanos), ZoneOffset.ofTotalSeconds(minuteOffset * 60));
                        continue;
                    }
                    short zoneNumber = (short)(zoneValue >>> 1);
                    dateTimes[i] = ZonedDateTime.ofInstant(Instant.ofEpochSecond(epochSecond, nanos), ZoneId.of(TimeZones.map((short)zoneNumber)));
                }
                return Values.dateTimeArray((ZonedDateTime[])dateTimes);
            }
            throw new InvalidRecordException("LocalTime array with unexpected type. Actual:" + dataValue.getClass().getSimpleName() + ". Expected: LongArray.");
        }

        private boolean storingZoneOffset(long firstBlock) {
            return (firstBlock & 0x100000000L) > 0L;
        }
    }
    ,
    TEMPORAL_DURATION(6, "Duration"){

        @Override
        public Value decodeForTemporal(long[] valueBlocks, int offset) {
            int nanos = (int)(valueBlocks[offset] >>> 32);
            long months = valueBlocks[1 + offset];
            long days = valueBlocks[2 + offset];
            long seconds = valueBlocks[3 + offset];
            return DurationValue.duration((long)months, (long)days, (long)seconds, (long)nanos);
        }

        @Override
        public int calculateNumberOfBlocksUsedForTemporal(long firstBlock) {
            return 4;
        }

        @Override
        public ArrayValue decodeArray(Value dataValue) {
            if (dataValue instanceof LongArray) {
                LongArray numbers = (LongArray)dataValue;
                DurationValue[] durations = new DurationValue[numbers.length() / 4];
                for (int i = 0; i < durations.length; ++i) {
                    durations[i] = DurationValue.duration((long)numbers.longValue(i * 4), (long)numbers.longValue(i * 4 + 1), (long)numbers.longValue(i * 4 + 2), (long)numbers.longValue(i * 4 + 3));
                }
                return Values.durationArray((DurationValue[])durations);
            }
            throw new InvalidRecordException("Array with unexpected type. Actual:" + dataValue.getClass().getSimpleName() + ". Expected: LongArray.");
        }
    };

    private static final int BLOCKS_LONG_INLINED = 1;
    private static final int BLOCKS_LONG_NOT_INLINED = 2;
    private static final int BLOCKS_LOCAL_DATETIME = 2;
    private static final int BLOCKS_TIME = 2;
    private static final int BLOCKS_DATETIME = 3;
    private static final int BLOCKS_DURATION = 4;
    private static final TemporalType[] TYPES;
    private static final Map<String, TemporalType> all;
    private static final long TEMPORAL_TYPE_MASK = 0xF0000000L;
    private final int temporalType;
    private final String name;

    private static int getTemporalType(long firstBlock) {
        return (int)((firstBlock & 0xF0000000L) >> 28);
    }

    public static int calculateNumberOfBlocksUsed(long firstBlock) {
        TemporalType geometryType = TemporalType.find(TemporalType.getTemporalType(firstBlock));
        return geometryType.calculateNumberOfBlocksUsedForTemporal(firstBlock);
    }

    private static TemporalType find(int temporalType) {
        if (temporalType < TYPES.length && temporalType >= 0) {
            return TYPES[temporalType];
        }
        return TEMPORAL_INVALID;
    }

    public static Value decode(PropertyBlock block) {
        return TemporalType.decode(block.getValueBlocks(), 0);
    }

    public static Value decode(long[] valueBlocks, int offset) {
        long firstBlock = valueBlocks[offset];
        int temporalType = TemporalType.getTemporalType(firstBlock);
        return TemporalType.find(temporalType).decodeForTemporal(valueBlocks, offset);
    }

    public static long[] encodeDate(int keyId, long epochDay) {
        return TemporalType.encodeLong(keyId, epochDay, TemporalType.TEMPORAL_DATE.temporalType);
    }

    public static long[] encodeLocalTime(int keyId, long nanoOfDay) {
        return TemporalType.encodeLong(keyId, nanoOfDay, TemporalType.TEMPORAL_LOCAL_TIME.temporalType);
    }

    private static long[] encodeLong(int keyId, long val, int temporalType) {
        int idBits = 24;
        long keyAndType = (long)keyId | (long)PropertyType.TEMPORAL.intValue() << idBits;
        long temporalTypeBits = temporalType << idBits + 4;
        long[] data = ShortArray.LONG.getRequiredBits(val) <= 31 ? new long[]{keyAndType | temporalTypeBits | 0x100000000L | val << 33} : new long[]{keyAndType | temporalTypeBits, val};
        return data;
    }

    public static long[] encodeLocalDateTime(int keyId, long epochSecond, long nanoOfSecond) {
        int idBits = 24;
        long keyAndType = (long)keyId | (long)PropertyType.TEMPORAL.intValue() << idBits;
        long temporalTypeBits = TemporalType.TEMPORAL_LOCAL_DATE_TIME.temporalType << idBits + 4;
        long[] data = new long[]{keyAndType | temporalTypeBits | nanoOfSecond << 32, epochSecond};
        return data;
    }

    public static long[] encodeDateTime(int keyId, long epochSecond, long nanoOfSecond, String zoneId) {
        int idBits = 24;
        short zoneNumber = TimeZones.map((String)zoneId);
        long keyAndType = (long)keyId | (long)PropertyType.TEMPORAL.intValue() << idBits;
        long temporalTypeBits = TemporalType.TEMPORAL_DATE_TIME.temporalType << idBits + 4;
        long[] data = new long[]{keyAndType | temporalTypeBits | nanoOfSecond << 33, epochSecond, zoneNumber};
        return data;
    }

    public static long[] encodeDateTime(int keyId, long epochSecond, long nanoOfSecond, int secondOffset) {
        int idBits = 24;
        int minuteOffset = secondOffset / 60;
        long keyAndType = (long)keyId | (long)PropertyType.TEMPORAL.intValue() << idBits;
        long temporalTypeBits = TemporalType.TEMPORAL_DATE_TIME.temporalType << idBits + 4;
        long[] data = new long[]{keyAndType | temporalTypeBits | 0x100000000L | nanoOfSecond << 33, epochSecond, minuteOffset};
        return data;
    }

    public static long[] encodeTime(int keyId, long nanoOfDayLocal, int secondOffset) {
        int idBits = 24;
        int minuteOffset = secondOffset / 60;
        long keyAndType = (long)keyId | (long)PropertyType.TEMPORAL.intValue() << idBits;
        long temporalTypeBits = TemporalType.TEMPORAL_TIME.temporalType << idBits + 4;
        long[] data = new long[]{keyAndType | temporalTypeBits | (long)minuteOffset << 32, nanoOfDayLocal};
        return data;
    }

    public static long[] encodeDuration(int keyId, long months, long days, long seconds, int nanos) {
        int idBits = 24;
        long keyAndType = (long)keyId | (long)PropertyType.TEMPORAL.intValue() << idBits;
        long temporalTypeBits = TemporalType.TEMPORAL_DURATION.temporalType << idBits + 4;
        long[] data = new long[]{keyAndType | temporalTypeBits | (long)nanos << 32, months, days, seconds};
        return data;
    }

    public static byte[] encodeDateArray(LocalDate[] dates) {
        long[] data = new long[dates.length];
        for (int i = 0; i < data.length; ++i) {
            data[i] = dates[i].toEpochDay();
        }
        TemporalHeader header = new TemporalHeader(TemporalType.TEMPORAL_DATE.temporalType);
        byte[] bytes = DynamicArrayStore.encodeFromNumbers(data, 2);
        header.writeArrayHeaderTo(bytes);
        return bytes;
    }

    public static byte[] encodeLocalTimeArray(LocalTime[] times) {
        long[] data = new long[times.length];
        for (int i = 0; i < data.length; ++i) {
            data[i] = times[i].toNanoOfDay();
        }
        TemporalHeader header = new TemporalHeader(TemporalType.TEMPORAL_LOCAL_TIME.temporalType);
        byte[] bytes = DynamicArrayStore.encodeFromNumbers(data, 2);
        header.writeArrayHeaderTo(bytes);
        return bytes;
    }

    public static byte[] encodeLocalDateTimeArray(LocalDateTime[] dateTimes) {
        long[] data = new long[dateTimes.length * 2];
        for (int i = 0; i < dateTimes.length; ++i) {
            data[i * 2] = dateTimes[i].toEpochSecond(ZoneOffset.UTC);
            data[i * 2 + 1] = dateTimes[i].getNano();
        }
        TemporalHeader header = new TemporalHeader(TemporalType.TEMPORAL_LOCAL_DATE_TIME.temporalType);
        byte[] bytes = DynamicArrayStore.encodeFromNumbers(data, 2);
        header.writeArrayHeaderTo(bytes);
        return bytes;
    }

    public static byte[] encodeTimeArray(OffsetTime[] times) {
        int i;
        long[] data = new long[(int)Math.ceil((double)times.length * 1.25)];
        for (i = 0; i < times.length; ++i) {
            data[i] = times[i].toLocalTime().toNanoOfDay();
        }
        for (int j = 0; j < times.length; ++j) {
            int shift = j % 4 * 16;
            short minuteOffset = (short)(times[j].getOffset().getTotalSeconds() / 60);
            data[i] = Short.toUnsignedLong(minuteOffset) << shift | data[i];
            if (j % 4 != 3) continue;
            ++i;
        }
        TemporalHeader header = new TemporalHeader(TemporalType.TEMPORAL_TIME.temporalType);
        byte[] bytes = DynamicArrayStore.encodeFromNumbers(data, 2);
        header.writeArrayHeaderTo(bytes);
        return bytes;
    }

    public static byte[] encodeDateTimeArray(ZonedDateTime[] dateTimes) {
        long[] data = new long[dateTimes.length * 3];
        for (int i = 0; i < dateTimes.length; ++i) {
            data[i * 3] = dateTimes[i].toEpochSecond();
            data[i * 3 + 1] = dateTimes[i].getNano();
            if (dateTimes[i].getZone() instanceof ZoneOffset) {
                ZoneOffset offset = (ZoneOffset)dateTimes[i].getZone();
                int minuteOffset = offset.getTotalSeconds() / 60;
                data[i * 3 + 2] = (long)(minuteOffset << 1) | 1L;
                continue;
            }
            String timeZoneId = dateTimes[i].getZone().getId();
            short zoneNumber = TimeZones.map((String)timeZoneId);
            data[i * 3 + 2] = zoneNumber << 1;
        }
        TemporalHeader header = new TemporalHeader(TemporalType.TEMPORAL_DATE_TIME.temporalType);
        byte[] bytes = DynamicArrayStore.encodeFromNumbers(data, 2);
        header.writeArrayHeaderTo(bytes);
        return bytes;
    }

    public static byte[] encodeDurationArray(DurationValue[] durations) {
        long[] data = new long[durations.length * 4];
        for (int i = 0; i < durations.length; ++i) {
            data[i * 4] = durations[i].get((TemporalUnit)ChronoUnit.MONTHS);
            data[i * 4 + 1] = durations[i].get((TemporalUnit)ChronoUnit.DAYS);
            data[i * 4 + 2] = durations[i].get((TemporalUnit)ChronoUnit.SECONDS);
            data[i * 4 + 3] = durations[i].get((TemporalUnit)ChronoUnit.NANOS);
        }
        TemporalHeader header = new TemporalHeader(TemporalType.TEMPORAL_DURATION.temporalType);
        byte[] bytes = DynamicArrayStore.encodeFromNumbers(data, 2);
        header.writeArrayHeaderTo(bytes);
        return bytes;
    }

    public static ArrayValue decodeTemporalArray(TemporalHeader header, byte[] data) {
        byte[] dataHeader = PropertyType.ARRAY.readDynamicRecordHeader(data);
        byte[] dataBody = new byte[data.length - dataHeader.length];
        System.arraycopy(data, dataHeader.length, dataBody, 0, dataBody.length);
        Value dataValue = DynamicArrayStore.getRightArray((Pair<byte[], byte[]>)Pair.of((Object)dataHeader, (Object)dataBody));
        return TemporalType.find(header.temporalType).decodeArray(dataValue);
    }

    private TemporalType(int temporalType, String name) {
        this.temporalType = temporalType;
        this.name = name;
    }

    public abstract Value decodeForTemporal(long[] var1, int var2);

    public abstract int calculateNumberOfBlocksUsedForTemporal(long var1);

    public abstract ArrayValue decodeArray(Value var1);

    public String getName() {
        return this.name;
    }

    static {
        TYPES = TemporalType.values();
        all = new HashMap<String, TemporalType>(TYPES.length);
        for (TemporalType temporalType : TYPES) {
            all.put(temporalType.name, temporalType);
        }
    }

    public static class TemporalHeader {
        private final int temporalType;

        private TemporalHeader(int temporalType) {
            this.temporalType = temporalType;
        }

        private void writeArrayHeaderTo(byte[] bytes) {
            bytes[0] = (byte)PropertyType.TEMPORAL.intValue();
            bytes[1] = (byte)this.temporalType;
        }

        static TemporalHeader fromArrayHeaderBytes(byte[] header) {
            int temporalType = Byte.toUnsignedInt(header[1]);
            return new TemporalHeader(temporalType);
        }

        public static TemporalHeader fromArrayHeaderByteBuffer(ByteBuffer buffer) {
            int temporalType = Byte.toUnsignedInt(buffer.get());
            return new TemporalHeader(temporalType);
        }
    }
}

