/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.Collections;
import java.util.Set;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;

public class MultipleUnderlyingStorageExceptions
extends UnderlyingStorageException {
    public final Set<Pair<SchemaIndexDescriptor, UnderlyingStorageException>> exceptions;

    public MultipleUnderlyingStorageExceptions(Set<Pair<SchemaIndexDescriptor, UnderlyingStorageException>> exceptions) {
        super(MultipleUnderlyingStorageExceptions.buildMessage(exceptions));
        this.exceptions = Collections.unmodifiableSet(exceptions);
        for (Pair<SchemaIndexDescriptor, UnderlyingStorageException> exception : exceptions) {
            this.addSuppressed((Throwable)exception.other());
        }
    }

    private static String buildMessage(Set<Pair<SchemaIndexDescriptor, UnderlyingStorageException>> exceptions) {
        StringBuilder builder = new StringBuilder();
        builder.append("Errors when closing (flushing) index updaters:");
        for (Pair<SchemaIndexDescriptor, UnderlyingStorageException> pair : exceptions) {
            builder.append(String.format(" (%s) %s", ((SchemaIndexDescriptor)pair.first()).toString(), ((UnderlyingStorageException)pair.other()).getMessage()));
        }
        return builder.toString();
    }
}

