/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc.temporal;

import java.time.Clock;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.time.temporal.IsoFields;
import java.time.temporal.TemporalUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.DefaultParameterValue;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.proc.CallableUserFunction;
import org.neo4j.kernel.api.proc.Context;
import org.neo4j.kernel.api.proc.Key;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.proc.temporal.DateFunction;
import org.neo4j.kernel.impl.proc.temporal.DateTimeFunction;
import org.neo4j.kernel.impl.proc.temporal.DurationFunction;
import org.neo4j.kernel.impl.proc.temporal.LocalDateTimeFunction;
import org.neo4j.kernel.impl.proc.temporal.LocalTimeFunction;
import org.neo4j.kernel.impl.proc.temporal.TimeFunction;
import org.neo4j.procedure.Description;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;

public abstract class TemporalFunction<T extends AnyValue>
implements CallableUserFunction {
    private static final Key<Clock> DEFAULT_CLOCK = Context.STATEMENT_CLOCK;
    private static final List<FieldSignature> INPUT_SIGNATURE = Collections.singletonList(FieldSignature.inputField((String)"input", (Neo4jTypes.AnyType)Neo4jTypes.NTAny, (DefaultParameterValue)DefaultParameterValue.nullValue((Neo4jTypes.AnyType)Neo4jTypes.NTAny)));
    private static final String[] ALLOWED = new String[0];
    private final UserFunctionSignature signature;

    public static void registerTemporalFunctions(Procedures procedures) throws ProcedureException {
        TemporalFunction.register(new DateTimeFunction(), procedures);
        TemporalFunction.register(new LocalDateTimeFunction(), procedures);
        TemporalFunction.register(new DateFunction(), procedures);
        TemporalFunction.register(new TimeFunction(), procedures);
        TemporalFunction.register(new LocalTimeFunction(), procedures);
        DurationFunction.register(procedures);
    }

    protected abstract T now(Clock var1, String var2);

    protected abstract T parse(TextValue var1, Supplier<ZoneId> var2);

    protected abstract T build(MapValue var1, Supplier<ZoneId> var2);

    protected abstract T select(AnyValue var1, Supplier<ZoneId> var2);

    protected abstract T positionalCreate(AnyValue[] var1);

    protected abstract T truncate(TemporalUnit var1, TemporalValue var2, MapValue var3, Supplier<ZoneId> var4);

    TemporalFunction(Neo4jTypes.AnyType result) {
        String basename = TemporalFunction.basename(this.getClass());
        assert (result.getClass().getSimpleName().equals(basename + "Type")) : "result type should match function name";
        Description description = this.getClass().getAnnotation(Description.class);
        this.signature = new UserFunctionSignature(new QualifiedName(new String[0], basename.toLowerCase()), INPUT_SIGNATURE, result, null, ALLOWED, description == null ? null : description.value());
    }

    private static void register(TemporalFunction<?> base, Procedures procedures) throws ProcedureException {
        procedures.register(base);
        procedures.register(new Now(base, "transaction"));
        procedures.register(new Now(base, "statement"));
        procedures.register(new Now(base, "realtime"));
        procedures.register(new Truncate(base));
        base.registerMore(procedures);
    }

    private static String basename(Class<? extends TemporalFunction> function) {
        return function.getSimpleName().replace("Function", "");
    }

    static int anInt(String name, AnyValue value) {
        long v;
        if (value instanceof IntegralValue && (v = ((IntegralValue)value).longValue()) <= Integer.MAX_VALUE && v >= Integer.MIN_VALUE) {
            return (int)v;
        }
        throw new IllegalArgumentException(name + " should be an int, not: " + value);
    }

    static String aString(String name, AnyValue value) {
        if (value instanceof TextValue) {
            return ((TextValue)value).stringValue();
        }
        throw new IllegalArgumentException(name + " should be a string, not: " + value);
    }

    void registerMore(Procedures procedures) throws ProcedureException {
    }

    @Override
    public final UserFunctionSignature signature() {
        return this.signature;
    }

    public final T apply(Context ctx, AnyValue[] input) throws ProcedureException {
        if (input == null || input.length == 0 || input[0] == Values.NO_VALUE || input[0] == null) {
            return this.now(ctx.get(DEFAULT_CLOCK), null);
        }
        if (input.length > 1) {
            return this.positionalCreate(input);
        }
        if (input[0] instanceof TextValue) {
            return this.parse((TextValue)input[0], TemporalFunction.defaultZone(ctx));
        }
        if (input[0] instanceof TemporalValue) {
            return this.select(input[0], TemporalFunction.defaultZone(ctx));
        }
        if (input[0] instanceof MapValue) {
            MapValue map = (MapValue)input[0];
            String timezone = TemporalFunction.onlyTimezone(map);
            if (timezone != null) {
                return this.now(ctx.get(DEFAULT_CLOCK), timezone);
            }
            return this.build(map, TemporalFunction.defaultZone(ctx));
        }
        throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, "Invalid call signature", new Object[0]);
    }

    private static Supplier<ZoneId> defaultZone(Context ctx) throws ProcedureException {
        Clock clock = ctx.get(DEFAULT_CLOCK);
        return clock::getZone;
    }

    private static String onlyTimezone(MapValue map) {
        AnyValue timezone;
        String key;
        if (map.size() == 1 && "timezone".equalsIgnoreCase(key = (String)Iterables.single((Iterable)map.keySet())) && (timezone = map.get(key)) instanceof TextValue) {
            return ((TextValue)timezone).stringValue();
        }
        return null;
    }

    private static class Truncate<T extends AnyValue>
    extends SubFunction<T> {
        private static final List<FieldSignature> SIGNATURE = Arrays.asList(FieldSignature.inputField((String)"unit", (Neo4jTypes.AnyType)Neo4jTypes.NTString), FieldSignature.inputField((String)"input", (Neo4jTypes.AnyType)Neo4jTypes.NTAny), FieldSignature.inputField((String)"fields", (Neo4jTypes.AnyType)Neo4jTypes.NTMap, (DefaultParameterValue)DefaultParameterValue.nullValue((Neo4jTypes.AnyType)Neo4jTypes.NTMap)));

        Truncate(TemporalFunction<T> function) {
            super(function, "truncate", SIGNATURE, String.format("Truncate the input temporal value to a %s instant using the specified unit.", TemporalFunction.basename(function.getClass())));
        }

        @Override
        public T apply(Context ctx, AnyValue[] args) throws ProcedureException {
            if (args != null && args.length >= 2 && args.length <= 3) {
                MapValue fields;
                AnyValue unit = args[0];
                AnyValue input = args[1];
                Object object = fields = args.length == 2 || args[2] == Values.NO_VALUE ? VirtualValues.EMPTY_MAP : args[2];
                if (unit instanceof TextValue && input instanceof TemporalValue && fields instanceof MapValue) {
                    return this.function.truncate(Truncate.unit(((TextValue)unit).stringValue()), (TemporalValue)input, fields, TemporalFunction.defaultZone(ctx));
                }
            }
            throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, "Invalid call signature", new Object[0]);
        }

        private static TemporalUnit unit(String unit) {
            switch (unit) {
                case "millennium": {
                    return ChronoUnit.MILLENNIA;
                }
                case "century": {
                    return ChronoUnit.CENTURIES;
                }
                case "decade": {
                    return ChronoUnit.DECADES;
                }
                case "year": {
                    return ChronoUnit.YEARS;
                }
                case "quarter": {
                    return IsoFields.QUARTER_YEARS;
                }
                case "month": {
                    return ChronoUnit.MONTHS;
                }
                case "week": {
                    return ChronoUnit.WEEKS;
                }
                case "day": {
                    return ChronoUnit.DAYS;
                }
                case "hour": {
                    return ChronoUnit.HOURS;
                }
                case "minute": {
                    return ChronoUnit.MINUTES;
                }
                case "second": {
                    return ChronoUnit.SECONDS;
                }
                case "millisecond": {
                    return ChronoUnit.MILLIS;
                }
                case "microsecond": {
                    return ChronoUnit.MICROS;
                }
            }
            throw new IllegalArgumentException("Unsupported unit: " + unit);
        }
    }

    private static class Now<T extends AnyValue>
    extends SubFunction<T> {
        private static final List<FieldSignature> SIGNATURE = Collections.singletonList(FieldSignature.inputField((String)"timezone", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (DefaultParameterValue)DefaultParameterValue.nullValue((Neo4jTypes.AnyType)Neo4jTypes.NTString)));
        private final Key<Clock> key;

        Now(TemporalFunction<T> function, String clock) {
            super(function, clock, SIGNATURE, String.format("Get the current %s instant using the %s clock.", TemporalFunction.basename(function.getClass()), clock));
            switch (clock) {
                case "transaction": {
                    this.key = Context.TRANSACTION_CLOCK;
                    break;
                }
                case "statement": {
                    this.key = Context.STATEMENT_CLOCK;
                    break;
                }
                case "realtime": {
                    this.key = Context.SYSTEM_CLOCK;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized clock: " + clock);
                }
            }
        }

        @Override
        public T apply(Context ctx, AnyValue[] input) throws ProcedureException {
            if (input == null || input.length == 0 || (input[0] == Values.NO_VALUE || input[0] == null) && input.length == 1) {
                return this.function.now(ctx.get(this.key), null);
            }
            if (input.length == 1 && input[0] instanceof TextValue) {
                TextValue timezone = (TextValue)input[0];
                return this.function.now(ctx.get(this.key), timezone.stringValue());
            }
            throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, "Invalid call signature", new Object[0]);
        }
    }

    private static abstract class SubFunction<T extends AnyValue>
    implements CallableUserFunction {
        private final UserFunctionSignature signature;
        final TemporalFunction<T> function;

        SubFunction(TemporalFunction<T> base, String name, List<FieldSignature> input, String description) {
            this.function = base;
            this.signature = new UserFunctionSignature(new QualifiedName(new String[]{((TemporalFunction)base).signature.name().name()}, name), input, ((TemporalFunction)base).signature.outputType(), null, ALLOWED, description);
        }

        @Override
        public final UserFunctionSignature signature() {
            return this.signature;
        }

        public abstract T apply(Context var1, AnyValue[] var2) throws ProcedureException;
    }
}

