/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.io.File;
import java.net.URL;
import java.util.Map;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.event.KernelEventHandler;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.graphdb.security.URLAccessValidationError;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.explicitindex.AutoIndexing;
import org.neo4j.kernel.impl.coreapi.CoreAPIAvailabilityGuard;
import org.neo4j.kernel.impl.factory.DataSourceModule;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.factory.PlatformModule;
import org.neo4j.kernel.impl.query.QueryExecutionKernelException;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.values.virtual.MapValue;

class ProcedureGDBFacadeSPI
implements GraphDatabaseFacade.SPI {
    private final File storeDir;
    private final DataSourceModule sourceModule;
    private final DependencyResolver resolver;
    private final CoreAPIAvailabilityGuard availability;
    private final ThrowingFunction<URL, URL, URLAccessValidationError> urlValidator;
    private final SecurityContext securityContext;

    ProcedureGDBFacadeSPI(PlatformModule platform, DataSourceModule sourceModule, DependencyResolver resolver, CoreAPIAvailabilityGuard availability, ThrowingFunction<URL, URL, URLAccessValidationError> urlValidator, SecurityContext securityContext) {
        this.storeDir = platform.storeDir;
        this.sourceModule = sourceModule;
        this.resolver = resolver;
        this.availability = availability;
        this.urlValidator = urlValidator;
        this.securityContext = securityContext;
    }

    @Override
    public boolean databaseIsAvailable(long timeout) {
        return this.availability.isAvailable(timeout);
    }

    @Override
    public DependencyResolver resolver() {
        return this.resolver;
    }

    @Override
    public StoreId storeId() {
        return this.sourceModule.storeId.get();
    }

    @Override
    public File storeDir() {
        return this.storeDir;
    }

    @Override
    public String name() {
        return "ProcedureGraphDatabaseService";
    }

    @Override
    public Result executeQuery(String query, Map<String, Object> parameters, TransactionalContext tc) {
        try {
            this.availability.assertDatabaseAvailable();
            return this.sourceModule.queryExecutor.get().executeQuery(query, parameters, tc);
        }
        catch (QueryExecutionKernelException e) {
            throw e.asUserException();
        }
    }

    @Override
    public Result executeQuery(String query, MapValue parameters, TransactionalContext tc) {
        try {
            this.availability.assertDatabaseAvailable();
            return this.sourceModule.queryExecutor.get().executeQuery(query, parameters, tc);
        }
        catch (QueryExecutionKernelException e) {
            throw e.asUserException();
        }
    }

    @Override
    public AutoIndexing autoIndexing() {
        return this.sourceModule.autoIndexing;
    }

    @Override
    public void registerKernelEventHandler(KernelEventHandler handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void unregisterKernelEventHandler(KernelEventHandler handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> void registerTransactionEventHandler(TransactionEventHandler<T> handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> void unregisterTransactionEventHandler(TransactionEventHandler<T> handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public URL validateURLAccess(URL url) throws URLAccessValidationError {
        return (URL)this.urlValidator.apply((Object)url);
    }

    @Override
    public GraphDatabaseQueryService queryService() {
        return (GraphDatabaseQueryService)this.resolver.resolveDependency(GraphDatabaseQueryService.class);
    }

    @Override
    public void shutdown() {
        throw new UnsupportedOperationException();
    }

    @Override
    public KernelTransaction beginTransaction(Transaction.Type type, LoginContext ignored, long timeout) {
        try {
            this.availability.assertDatabaseAvailable();
            KernelTransaction kernelTx = this.sourceModule.kernelAPI.get().newTransaction(type, (LoginContext)this.securityContext, timeout);
            kernelTx.registerCloseListener(txId -> this.sourceModule.threadToTransactionBridge.unbindTransactionFromCurrentThread());
            this.sourceModule.threadToTransactionBridge.bindTransactionToCurrentThread(kernelTx);
            return kernelTx;
        }
        catch (org.neo4j.kernel.api.exceptions.TransactionFailureException e) {
            throw new TransactionFailureException(e.getMessage(), (Throwable)((Object)e));
        }
    }
}

