/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Arrays;
import org.neo4j.internal.kernel.api.CapableIndexReference;
import org.neo4j.internal.kernel.api.ExplicitIndexRead;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.Locks;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeExplicitIndexCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.Procedures;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipExplicitIndexCursor;
import org.neo4j.internal.kernel.api.RelationshipGroupCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.Scan;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.api.ExplicitIndex;
import org.neo4j.kernel.api.ExplicitIndexHits;
import org.neo4j.kernel.api.exceptions.index.IndexNotApplicableKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.IndexBrokenKernelException;
import org.neo4j.kernel.api.txstate.ExplicitIndexTransactionState;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.api.txstate.TxStateHolder;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.locking.LockTracer;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.impl.newapi.DefaultCursors;
import org.neo4j.kernel.impl.newapi.DefaultNodeCursor;
import org.neo4j.kernel.impl.newapi.DefaultNodeExplicitIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultNodeLabelIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultNodeValueIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultPropertyCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipExplicitIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipGroupCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipScanCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipTraversalCursor;
import org.neo4j.kernel.impl.newapi.ExplicitIndexProgressor;
import org.neo4j.kernel.impl.newapi.GroupReferenceEncoding;
import org.neo4j.kernel.impl.newapi.NodeLabelIndexProgressor;
import org.neo4j.kernel.impl.newapi.NodeValueClientFilter;
import org.neo4j.kernel.impl.newapi.References;
import org.neo4j.kernel.impl.newapi.RelationshipDirection;
import org.neo4j.kernel.impl.newapi.RelationshipReferenceEncoding;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.storageengine.api.lock.ResourceType;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.LabelScanReader;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;

abstract class Read
implements TxStateHolder,
org.neo4j.internal.kernel.api.Read,
ExplicitIndexRead,
SchemaRead,
Procedures,
Locks {
    private final DefaultCursors cursors;
    final KernelTransactionImplementation ktx;

    Read(DefaultCursors cursors, KernelTransactionImplementation ktx) {
        this.cursors = cursors;
        this.ktx = ktx;
    }

    public final void nodeIndexSeek(IndexReference index, NodeValueIndexCursor cursor, IndexOrder indexOrder, IndexQuery ... query) throws IndexNotApplicableKernelException, IndexNotFoundKernelException {
        this.ktx.assertOpen();
        if (this.hasForbiddenProperties(index)) {
            cursor.close();
            return;
        }
        ((DefaultNodeValueIndexCursor)cursor).setRead(this);
        IndexProgressor.NodeValueClient target = (DefaultNodeValueIndexCursor)cursor;
        IndexReader reader = this.indexReader(index);
        if (!reader.hasFullValuePrecision(query)) {
            IndexQuery[] filters = new IndexQuery[query.length];
            int j = 0;
            block4: for (IndexQuery q : query) {
                switch (q.type()) {
                    case range: {
                        ValueGroup valueGroup = q.valueGroup();
                        if (valueGroup != ValueGroup.NUMBER && valueGroup != ValueGroup.GEOMETRY || reader.hasFullValuePrecision(q)) continue block4;
                        filters[j++] = q;
                        continue block4;
                    }
                    case exact: {
                        Value value = ((IndexQuery.ExactPredicate)q).value();
                        if (value.valueGroup() != ValueGroup.NUMBER && !Values.isArrayValue((Value)value) && value.valueGroup() != ValueGroup.GEOMETRY || reader.hasFullValuePrecision(q)) continue block4;
                        filters[j++] = q;
                        continue block4;
                    }
                }
            }
            if (j > 0) {
                filters = Arrays.copyOf(filters, j);
                target = new NodeValueClientFilter(target, this.cursors.allocateNodeCursor(), this.cursors.allocatePropertyCursor(), this, filters);
            }
        }
        reader.query(target, indexOrder, query);
    }

    public final long nodeUniqueIndexSeek(IndexReference index, IndexQuery.ExactPredicate ... predicates) throws IndexNotApplicableKernelException, IndexNotFoundKernelException, IndexBrokenKernelException {
        this.assertIndexOnline(index);
        this.assertPredicatesMatchSchema(index, predicates);
        int labelId = index.label();
        Locks.Client locks = this.ktx.statementLocks().optimistic();
        LockTracer lockTracer = this.ktx.lockTracer();
        long indexEntryId = ResourceTypes.indexEntryResourceId(labelId, predicates);
        locks.acquireShared(lockTracer, ResourceTypes.INDEX_ENTRY, indexEntryId);
        try (DefaultNodeValueIndexCursor cursor = this.cursors.allocateNodeValueIndexCursor();){
            this.nodeIndexSeek(index, cursor, IndexOrder.NONE, (IndexQuery[])predicates);
            if (!cursor.next()) {
                locks.releaseShared(ResourceTypes.INDEX_ENTRY, indexEntryId);
                locks.acquireExclusive(lockTracer, ResourceTypes.INDEX_ENTRY, indexEntryId);
                this.nodeIndexSeek(index, cursor, IndexOrder.NONE, (IndexQuery[])predicates);
                if (cursor.next()) {
                    locks.acquireShared(lockTracer, ResourceTypes.INDEX_ENTRY, indexEntryId);
                    locks.releaseExclusive(ResourceTypes.INDEX_ENTRY, indexEntryId);
                }
            }
            long l = cursor.nodeReference();
            return l;
        }
    }

    public final void nodeIndexScan(IndexReference index, NodeValueIndexCursor cursor, IndexOrder indexOrder) throws KernelException {
        this.ktx.assertOpen();
        if (this.hasForbiddenProperties(index)) {
            cursor.close();
            return;
        }
        int firstProperty = index.properties()[0];
        ((DefaultNodeValueIndexCursor)cursor).setRead(this);
        this.indexReader(index).query((DefaultNodeValueIndexCursor)cursor, indexOrder, new IndexQuery[]{IndexQuery.exists((int)firstProperty)});
    }

    private boolean hasForbiddenProperties(IndexReference index) {
        AccessMode mode = this.ktx.securityContext().mode();
        for (int prop : index.properties()) {
            if (mode.allowsPropertyReads(prop)) continue;
            return true;
        }
        return false;
    }

    public final void nodeLabelScan(int label, NodeLabelIndexCursor cursor) {
        this.ktx.assertOpen();
        DefaultNodeLabelIndexCursor indexCursor = (DefaultNodeLabelIndexCursor)cursor;
        indexCursor.setRead(this);
        this.labelScanReader().nodesWithLabel(indexCursor, label);
    }

    public void nodeLabelUnionScan(NodeLabelIndexCursor cursor, int ... labels) {
        this.ktx.assertOpen();
        DefaultNodeLabelIndexCursor client = (DefaultNodeLabelIndexCursor)cursor;
        client.setRead(this);
        client.unionScan(new NodeLabelIndexProgressor(this.labelScanReader().nodesWithAnyOfLabels(labels), client), false, labels);
    }

    public void nodeLabelIntersectionScan(NodeLabelIndexCursor cursor, int ... labels) {
        this.ktx.assertOpen();
        DefaultNodeLabelIndexCursor client = (DefaultNodeLabelIndexCursor)cursor;
        client.setRead(this);
        client.intersectionScan(new NodeLabelIndexProgressor(this.labelScanReader().nodesWithAllLabels(labels), client), false, labels);
    }

    public final Scan<NodeLabelIndexCursor> nodeLabelScan(int label) {
        this.ktx.assertOpen();
        throw new UnsupportedOperationException("not implemented");
    }

    public final void allNodesScan(NodeCursor cursor) {
        this.ktx.assertOpen();
        ((DefaultNodeCursor)cursor).scan(this);
    }

    public final Scan<NodeCursor> allNodesScan() {
        this.ktx.assertOpen();
        throw new UnsupportedOperationException("not implemented");
    }

    public final void singleNode(long reference, NodeCursor cursor) {
        this.ktx.assertOpen();
        ((DefaultNodeCursor)cursor).single(reference, this);
    }

    public final void singleRelationship(long reference, RelationshipScanCursor cursor) {
        this.ktx.assertOpen();
        ((DefaultRelationshipScanCursor)cursor).single(reference, this);
    }

    public final void allRelationshipsScan(RelationshipScanCursor cursor) {
        this.ktx.assertOpen();
        ((DefaultRelationshipScanCursor)cursor).scan(-1, this);
    }

    public final Scan<RelationshipScanCursor> allRelationshipsScan() {
        this.ktx.assertOpen();
        throw new UnsupportedOperationException("not implemented");
    }

    public final void relationshipLabelScan(int label, RelationshipScanCursor cursor) {
        this.ktx.assertOpen();
        ((DefaultRelationshipScanCursor)cursor).scan(label, this);
    }

    public final Scan<RelationshipScanCursor> relationshipLabelScan(int label) {
        this.ktx.assertOpen();
        throw new UnsupportedOperationException("not implemented");
    }

    public final void relationshipGroups(long nodeReference, long reference, RelationshipGroupCursor cursor) {
        this.ktx.assertOpen();
        if (reference != -1L && GroupReferenceEncoding.isRelationship(reference)) {
            ((DefaultRelationshipGroupCursor)cursor).buffer(nodeReference, References.clearEncoding(reference), this);
        } else {
            ((DefaultRelationshipGroupCursor)cursor).direct(nodeReference, reference, this);
        }
    }

    public final void relationships(long nodeReference, long reference, RelationshipTraversalCursor cursor) {
        this.ktx.assertOpen();
        RelationshipReferenceEncoding encoding = RelationshipReferenceEncoding.parseEncoding(reference);
        DefaultRelationshipTraversalCursor internalCursor = (DefaultRelationshipTraversalCursor)cursor;
        switch (encoding) {
            case NONE: {
                internalCursor.chain(nodeReference, reference, this);
                break;
            }
            case FILTER: {
                internalCursor.filtered(nodeReference, References.clearEncoding(reference), this, true);
                break;
            }
            case FILTER_TX_STATE: {
                internalCursor.filtered(nodeReference, References.clearEncoding(reference), this, false);
                break;
            }
            case GROUP: {
                internalCursor.groups(nodeReference, References.clearEncoding(reference), this);
                break;
            }
            case NO_OUTGOING_OF_TYPE: {
                int relationshipType = (int)References.clearEncoding(reference);
                internalCursor.filteredTxState(nodeReference, this, relationshipType, RelationshipDirection.OUTGOING);
                break;
            }
            case NO_INCOMING_OF_TYPE: {
                int relationshipType = (int)References.clearEncoding(reference);
                internalCursor.filteredTxState(nodeReference, this, relationshipType, RelationshipDirection.INCOMING);
                break;
            }
            case NO_LOOP_OF_TYPE: {
                int relationshipType = (int)References.clearEncoding(reference);
                internalCursor.filteredTxState(nodeReference, this, relationshipType, RelationshipDirection.LOOP);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown encoding " + (Object)((Object)encoding));
            }
        }
    }

    public final void nodeProperties(long nodeReference, long reference, PropertyCursor cursor) {
        this.ktx.assertOpen();
        ((DefaultPropertyCursor)cursor).initNode(nodeReference, reference, this, this.ktx);
    }

    public final void relationshipProperties(long relationshipReference, long reference, PropertyCursor cursor) {
        this.ktx.assertOpen();
        ((DefaultPropertyCursor)cursor).initRelationship(relationshipReference, reference, this, this.ktx);
    }

    public final void graphProperties(PropertyCursor cursor) {
        this.ktx.assertOpen();
        ((DefaultPropertyCursor)cursor).initGraph(this.graphPropertiesReference(), this, this.ktx);
    }

    abstract long graphPropertiesReference();

    public final void nodeExplicitIndexLookup(NodeExplicitIndexCursor cursor, String index, String key, Value value) throws KernelException {
        this.ktx.assertOpen();
        ((DefaultNodeExplicitIndexCursor)cursor).setRead(this);
        Read.explicitIndex((DefaultNodeExplicitIndexCursor)cursor, this.explicitNodeIndex(index).get(key, value.asObject()));
    }

    public final void nodeExplicitIndexQuery(NodeExplicitIndexCursor cursor, String index, Object query) throws KernelException {
        this.ktx.assertOpen();
        ((DefaultNodeExplicitIndexCursor)cursor).setRead(this);
        Read.explicitIndex((DefaultNodeExplicitIndexCursor)cursor, this.explicitNodeIndex(index).query(query instanceof Value ? ((Value)query).asObject() : query));
    }

    public final void nodeExplicitIndexQuery(NodeExplicitIndexCursor cursor, String index, String key, Object query) throws KernelException {
        this.ktx.assertOpen();
        ((DefaultNodeExplicitIndexCursor)cursor).setRead(this);
        Read.explicitIndex((DefaultNodeExplicitIndexCursor)cursor, this.explicitNodeIndex(index).query(key, query instanceof Value ? ((Value)query).asObject() : query));
    }

    public void relationshipExplicitIndexGet(RelationshipExplicitIndexCursor cursor, String index, String key, Value value, long source, long target) throws KernelException {
        this.ktx.assertOpen();
        ((DefaultRelationshipExplicitIndexCursor)cursor).setRead(this);
        Read.explicitIndex((DefaultRelationshipExplicitIndexCursor)cursor, this.explicitRelationshipIndex(index).get(key, value.asObject(), source, target));
    }

    public void relationshipExplicitIndexQuery(RelationshipExplicitIndexCursor cursor, String index, Object query, long source, long target) throws KernelException {
        this.ktx.assertOpen();
        ((DefaultRelationshipExplicitIndexCursor)cursor).setRead(this);
        Read.explicitIndex((DefaultRelationshipExplicitIndexCursor)cursor, this.explicitRelationshipIndex(index).query(query instanceof Value ? ((Value)query).asObject() : query, source, target));
    }

    public void relationshipExplicitIndexQuery(RelationshipExplicitIndexCursor cursor, String index, String key, Object query, long source, long target) throws KernelException {
        this.ktx.assertOpen();
        ((DefaultRelationshipExplicitIndexCursor)cursor).setRead(this);
        Read.explicitIndex((DefaultRelationshipExplicitIndexCursor)cursor, this.explicitRelationshipIndex(index).query(key, query instanceof Value ? ((Value)query).asObject() : query, source, target));
    }

    private static void explicitIndex(IndexProgressor.ExplicitClient client, ExplicitIndexHits hits) {
        client.initialize(new ExplicitIndexProgressor(hits, client), hits.size());
    }

    public final void futureNodeReferenceRead(long reference) {
        this.ktx.assertOpen();
    }

    public final void futureRelationshipsReferenceRead(long reference) {
        this.ktx.assertOpen();
    }

    public final void futureNodePropertyReferenceRead(long reference) {
        this.ktx.assertOpen();
    }

    public final void futureRelationshipPropertyReferenceRead(long reference) {
        this.ktx.assertOpen();
    }

    abstract IndexReader indexReader(IndexReference var1) throws IndexNotFoundKernelException;

    abstract LabelScanReader labelScanReader();

    abstract ExplicitIndex explicitNodeIndex(String var1) throws KernelException;

    abstract ExplicitIndex explicitRelationshipIndex(String var1) throws KernelException;

    public abstract CapableIndexReference index(int var1, int ... var2);

    abstract PageCursor nodePage(long var1);

    abstract PageCursor relationshipPage(long var1);

    abstract PageCursor groupPage(long var1);

    abstract PageCursor propertyPage(long var1);

    abstract PageCursor stringPage(long var1);

    abstract PageCursor arrayPage(long var1);

    abstract RecordCursor<DynamicRecord> labelCursor();

    abstract void node(NodeRecord var1, long var2, PageCursor var4);

    abstract void relationship(RelationshipRecord var1, long var2, PageCursor var4);

    abstract void relationshipFull(RelationshipRecord var1, long var2, PageCursor var4);

    abstract void property(PropertyRecord var1, long var2, PageCursor var4);

    abstract void group(RelationshipGroupRecord var1, long var2, PageCursor var4);

    abstract long nodeHighMark();

    abstract long relationshipHighMark();

    abstract TextValue string(DefaultPropertyCursor var1, long var2, PageCursor var4);

    abstract ArrayValue array(DefaultPropertyCursor var1, long var2, PageCursor var4);

    @Override
    public TransactionState txState() {
        return this.ktx.txState();
    }

    @Override
    public ExplicitIndexTransactionState explicitIndexTxState() {
        return this.ktx.explicitIndexTxState();
    }

    @Override
    public boolean hasTxStateWithChanges() {
        return this.ktx.hasTxStateWithChanges();
    }

    public void acquireExclusiveNodeLock(long ... ids) {
        this.acquireExclusiveLock(ResourceTypes.NODE, ids);
        this.ktx.assertOpen();
    }

    public void acquireExclusiveRelationshipLock(long ... ids) {
        this.acquireExclusiveLock(ResourceTypes.RELATIONSHIP, ids);
        this.ktx.assertOpen();
    }

    public void acquireExclusiveExplicitIndexLock(long ... ids) {
        this.acquireExclusiveLock(ResourceTypes.EXPLICIT_INDEX, ids);
        this.ktx.assertOpen();
    }

    public void acquireExclusiveLabelLock(long ... ids) {
        this.acquireExclusiveLock(ResourceTypes.LABEL, ids);
        this.ktx.assertOpen();
    }

    public void releaseExclusiveNodeLock(long ... ids) {
        this.releaseExclusiveLock(ResourceTypes.NODE, ids);
        this.ktx.assertOpen();
    }

    public void releaseExclusiveRelationshipLock(long ... ids) {
        this.releaseExclusiveLock(ResourceTypes.RELATIONSHIP, ids);
        this.ktx.assertOpen();
    }

    public void releaseExclusiveExplicitIndexLock(long ... ids) {
        this.releaseExclusiveLock(ResourceTypes.EXPLICIT_INDEX, ids);
        this.ktx.assertOpen();
    }

    public void releaseExclusiveLabelLock(long ... ids) {
        this.releaseExclusiveLock(ResourceTypes.LABEL, ids);
        this.ktx.assertOpen();
    }

    public void acquireSharedNodeLock(long ... ids) {
        this.acquireSharedLock(ResourceTypes.NODE, ids);
        this.ktx.assertOpen();
    }

    public void acquireSharedRelationshipLock(long ... ids) {
        this.acquireSharedLock(ResourceTypes.RELATIONSHIP, ids);
        this.ktx.assertOpen();
    }

    public void acquireSharedExplicitIndexLock(long ... ids) {
        this.acquireSharedLock(ResourceTypes.EXPLICIT_INDEX, ids);
        this.ktx.assertOpen();
    }

    public void acquireSharedLabelLock(long ... ids) {
        this.acquireSharedLock(ResourceTypes.LABEL, ids);
        this.ktx.assertOpen();
    }

    public void releaseSharedNodeLock(long ... ids) {
        this.releaseSharedLock(ResourceTypes.NODE, ids);
        this.ktx.assertOpen();
    }

    public void releaseSharedRelationshipLock(long ... ids) {
        this.releaseSharedLock(ResourceTypes.RELATIONSHIP, ids);
        this.ktx.assertOpen();
    }

    public void releaseSharedExplicitIndexLock(long ... ids) {
        this.releaseSharedLock(ResourceTypes.EXPLICIT_INDEX, ids);
        this.ktx.assertOpen();
    }

    public void releaseSharedLabelLock(long ... ids) {
        this.releaseSharedLock(ResourceTypes.LABEL, ids);
        this.ktx.assertOpen();
    }

    void sharedOptimisticLock(ResourceType resource, long resourceId) {
        this.ktx.statementLocks().optimistic().acquireShared(this.ktx.lockTracer(), resource, resourceId);
    }

    private void acquireExclusiveLock(ResourceTypes types, long ... ids) {
        this.ktx.statementLocks().pessimistic().acquireExclusive(this.ktx.lockTracer(), types, ids);
    }

    private void releaseExclusiveLock(ResourceTypes types, long ... ids) {
        this.ktx.statementLocks().pessimistic().releaseExclusive(types, ids);
    }

    private void acquireSharedLock(ResourceTypes types, long ... ids) {
        this.ktx.statementLocks().pessimistic().acquireShared(this.ktx.lockTracer(), types, ids);
    }

    private void releaseSharedLock(ResourceTypes types, long ... ids) {
        this.ktx.statementLocks().pessimistic().releaseShared(types, ids);
    }

    private void assertIndexOnline(IndexReference index) throws IndexNotFoundKernelException, IndexBrokenKernelException {
        switch (this.indexGetState(index)) {
            case ONLINE: {
                return;
            }
        }
        throw new IndexBrokenKernelException(this.indexGetFailure(index));
    }

    private void assertPredicatesMatchSchema(IndexReference index, IndexQuery.ExactPredicate[] predicates) throws IndexNotApplicableKernelException {
        int[] propertyIds = index.properties();
        if (propertyIds.length != predicates.length) {
            throw new IndexNotApplicableKernelException(String.format("The index specifies %d properties, but only %d lookup predicates were given.", propertyIds.length, predicates.length));
        }
        for (int i = 0; i < predicates.length; ++i) {
            if (predicates[i].propertyKeyId() == propertyIds[i]) continue;
            throw new IndexNotApplicableKernelException(String.format("The index has the property id %d in position %d, but the lookup property id was %d.", propertyIds[i], i, predicates[i].propertyKeyId()));
        }
    }
}

