/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Arrays;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.StateHandlingStatementOperations;
import org.neo4j.kernel.impl.newapi.DefaultCursors;
import org.neo4j.kernel.impl.newapi.IndexCursor;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.storageengine.api.txstate.PrimitiveLongReadableDiffSets;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

final class DefaultNodeValueIndexCursor
extends IndexCursor<IndexProgressor>
implements NodeValueIndexCursor,
IndexProgressor.NodeValueClient {
    private Read read;
    private long node;
    private IndexQuery[] query;
    private Value[] values;
    private PrimitiveLongIterator added = PrimitiveLongCollections.emptyIterator();
    private PrimitiveLongSet removed = PrimitiveLongCollections.emptySet();
    private boolean needsValues;
    private final DefaultCursors pool;

    DefaultNodeValueIndexCursor(DefaultCursors pool) {
        this.pool = pool;
        this.node = -1L;
    }

    @Override
    public void initialize(SchemaIndexDescriptor descriptor, IndexProgressor progressor, IndexQuery[] query) {
        assert (query != null && query.length > 0);
        super.initialize(progressor);
        this.query = query;
        IndexQuery firstPredicate = query[0];
        switch (firstPredicate.type()) {
            case exact: {
                this.seekQuery(descriptor, query);
                break;
            }
            case stringSuffix: 
            case stringContains: 
            case exists: {
                this.scanQuery(descriptor);
                break;
            }
            case range: {
                assert (query.length == 1);
                this.rangeQuery(descriptor, (IndexQuery.RangePredicate)query[0]);
                break;
            }
            case stringPrefix: {
                this.prefixQuery(descriptor, (IndexQuery.StringPrefixPredicate)query[0]);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Query not supported: " + Arrays.toString(query));
            }
        }
    }

    private boolean isRemoved(long reference) {
        return this.removed.contains(reference);
    }

    @Override
    public boolean acceptNode(long reference, Value[] values) {
        if (this.isRemoved(reference)) {
            return false;
        }
        this.node = reference;
        this.values = values;
        return true;
    }

    @Override
    public boolean needsValues() {
        return this.needsValues;
    }

    public boolean next() {
        if (this.added.hasNext()) {
            this.node = this.added.next();
            this.values = null;
            return true;
        }
        return this.innerNext();
    }

    public void setRead(Read read) {
        this.read = read;
    }

    public void node(NodeCursor cursor) {
        this.read.singleNode(this.node, cursor);
    }

    public long nodeReference() {
        return this.node;
    }

    public int numberOfProperties() {
        return this.query == null ? 0 : this.query.length;
    }

    public int propertyKey(int offset) {
        return this.query[offset].propertyKeyId();
    }

    public boolean hasValue() {
        return this.values != null;
    }

    public Value propertyValue(int offset) {
        return this.values[offset];
    }

    @Override
    public void close() {
        if (!this.isClosed()) {
            super.close();
            this.node = -1L;
            this.query = null;
            this.values = null;
            this.read = null;
            this.added = PrimitiveLongCollections.emptyIterator();
            this.removed = PrimitiveLongCollections.emptySet();
            this.pool.accept(this);
        }
    }

    @Override
    public boolean isClosed() {
        return super.isClosed();
    }

    public String toString() {
        if (this.isClosed()) {
            return "NodeValueIndexCursor[closed state]";
        }
        String keys = this.query == null ? "unknown" : Arrays.toString(Arrays.stream(this.query).map(IndexQuery::propertyKeyId).toArray(Integer[]::new));
        return "NodeValueIndexCursor[node=" + this.node + ", open state with: keys=" + keys + ", values=" + Arrays.toString(this.values) + ", underlying record=" + super.toString() + " ]";
    }

    private void prefixQuery(SchemaIndexDescriptor descriptor, IndexQuery.StringPrefixPredicate predicate) {
        this.needsValues = true;
        if (this.read.hasTxStateWithChanges()) {
            TransactionState txState = this.read.txState();
            PrimitiveLongReadableDiffSets changes = txState.indexUpdatesForRangeSeekByPrefix(descriptor, predicate.prefix());
            this.added = changes.augment(PrimitiveLongCollections.emptyIterator());
            this.removed = this.removed(txState, changes);
        }
    }

    private void rangeQuery(SchemaIndexDescriptor descriptor, IndexQuery.RangePredicate predicate) {
        ValueGroup valueGroup = predicate.valueGroup();
        boolean bl = this.needsValues = valueGroup == ValueGroup.TEXT || valueGroup == ValueGroup.NUMBER;
        if (this.read.hasTxStateWithChanges()) {
            TransactionState txState = this.read.txState();
            PrimitiveLongReadableDiffSets changes = txState.indexUpdatesForRangeSeek(descriptor, valueGroup, predicate.fromValue(), predicate.fromInclusive(), predicate.toValue(), predicate.toInclusive());
            this.added = changes.augment(PrimitiveLongCollections.emptyIterator());
            this.removed = this.removed(txState, changes);
        }
    }

    private void scanQuery(SchemaIndexDescriptor descriptor) {
        this.needsValues = true;
        if (this.read.hasTxStateWithChanges()) {
            TransactionState txState = this.read.txState();
            PrimitiveLongReadableDiffSets changes = txState.indexUpdatesForScan(descriptor);
            this.added = changes.augment(PrimitiveLongCollections.emptyIterator());
            this.removed = this.removed(txState, changes);
        }
    }

    private void seekQuery(SchemaIndexDescriptor descriptor, IndexQuery[] query) {
        this.needsValues = false;
        IndexQuery.ExactPredicate[] exactPreds = StateHandlingStatementOperations.assertOnlyExactPredicates(query);
        if (this.read.hasTxStateWithChanges()) {
            TransactionState txState = this.read.txState();
            PrimitiveLongReadableDiffSets changes = this.read.txState().indexUpdatesForSeek(descriptor, IndexQuery.asValueTuple((IndexQuery.ExactPredicate[])exactPreds));
            this.added = changes.augment(PrimitiveLongCollections.emptyIterator());
            this.removed = this.removed(txState, changes);
        }
    }

    private PrimitiveLongSet removed(TransactionState txState, PrimitiveLongReadableDiffSets changes) {
        PrimitiveLongSet longSet = PrimitiveLongCollections.asSet(txState.addedAndRemovedNodes().getRemoved());
        longSet.addAll(changes.getRemoved().iterator());
        return longSet;
    }

    public void release() {
    }
}

