/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.index.schema.SpatialCRSSchemaIndex;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexBase;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Value;

class SpatialFusionIndexUpdater
implements IndexUpdater {
    private final Map<CoordinateReferenceSystem, SpatialCRSSchemaIndex> indexMap;
    private final Map<CoordinateReferenceSystem, IndexUpdater> currentUpdaters = new HashMap<CoordinateReferenceSystem, IndexUpdater>();
    private final long indexId;
    private final SpatialCRSSchemaIndex.Supplier indexSupplier;
    private final SchemaIndexDescriptor descriptor;
    private final boolean populating;

    static SpatialFusionIndexUpdater updaterForAccessor(Map<CoordinateReferenceSystem, SpatialCRSSchemaIndex> indexMap, long indexId, SpatialCRSSchemaIndex.Supplier indexFactory, SchemaIndexDescriptor descriptor) {
        return new SpatialFusionIndexUpdater(indexMap, indexId, indexFactory, descriptor, false);
    }

    static SpatialFusionIndexUpdater updaterForPopulator(Map<CoordinateReferenceSystem, SpatialCRSSchemaIndex> indexMap, long indexId, SpatialCRSSchemaIndex.Supplier indexFactory, SchemaIndexDescriptor descriptor) {
        return new SpatialFusionIndexUpdater(indexMap, indexId, indexFactory, descriptor, true);
    }

    private SpatialFusionIndexUpdater(Map<CoordinateReferenceSystem, SpatialCRSSchemaIndex> indexMap, long indexId, SpatialCRSSchemaIndex.Supplier indexSupplier, SchemaIndexDescriptor descriptor, boolean populating) {
        this.indexMap = indexMap;
        this.indexId = indexId;
        this.indexSupplier = indexSupplier;
        this.descriptor = descriptor;
        this.populating = populating;
    }

    @Override
    public void process(IndexEntryUpdate<?> update) throws IOException, IndexEntryConflictException {
        switch (update.updateMode()) {
            case ADDED: {
                this.selectUpdater(update.values()).process(update);
                break;
            }
            case CHANGED: {
                IndexUpdater from = this.selectUpdater(update.beforeValues());
                IndexUpdater to = this.selectUpdater(update.values());
                if (from == to) {
                    from.process(update);
                    break;
                }
                from.process(IndexEntryUpdate.remove(update.getEntityId(), update.indexKey(), update.beforeValues()));
                to.process(IndexEntryUpdate.add(update.getEntityId(), update.indexKey(), update.values()));
                break;
            }
            case REMOVED: {
                this.selectUpdater(update.values()).process(update);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown update mode");
            }
        }
    }

    private IndexUpdater selectUpdater(Value ... values) throws IOException {
        assert (values.length == 1);
        PointValue pointValue = (PointValue)values[0];
        CoordinateReferenceSystem crs = pointValue.getCoordinateReferenceSystem();
        IndexUpdater updater = this.currentUpdaters.get(crs);
        if (updater != null) {
            return updater;
        }
        SpatialCRSSchemaIndex index = this.indexSupplier.get(this.descriptor, this.indexMap, this.indexId, crs);
        IndexUpdater indexUpdater = index.updaterWithCreate(this.populating);
        return this.remember(crs, indexUpdater);
    }

    private IndexUpdater remember(CoordinateReferenceSystem crs, IndexUpdater indexUpdater) {
        this.currentUpdaters.put(crs, indexUpdater);
        return indexUpdater;
    }

    @Override
    public void close() throws IOException, IndexEntryConflictException {
        while (!this.currentUpdaters.isEmpty()) {
            try {
                FusionIndexBase.forAll(IndexUpdater::close, this.currentUpdaters.values());
            }
            catch (IOException | IndexEntryConflictException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.currentUpdaters.clear();
        }
    }
}

