/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.BoundedIterable;
import org.neo4j.helpers.collection.CombiningIterable;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.SpatialCRSSchemaIndex;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexBase;
import org.neo4j.kernel.impl.index.schema.fusion.SpatialFusionIndexReader;
import org.neo4j.kernel.impl.index.schema.fusion.SpatialFusionIndexUpdater;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.values.storable.CoordinateReferenceSystem;

class SpatialFusionIndexAccessor
implements IndexAccessor {
    private final Map<CoordinateReferenceSystem, SpatialCRSSchemaIndex> indexMap;
    private final long indexId;
    private final SchemaIndexDescriptor descriptor;
    private final IndexSamplingConfig samplingConfig;
    private final SpatialCRSSchemaIndex.Supplier indexFactory;

    SpatialFusionIndexAccessor(Map<CoordinateReferenceSystem, SpatialCRSSchemaIndex> indexMap, long indexId, SchemaIndexDescriptor descriptor, IndexSamplingConfig samplingConfig, SpatialCRSSchemaIndex.Supplier indexFactory) throws IOException {
        this.indexMap = indexMap;
        this.indexId = indexId;
        this.descriptor = descriptor;
        this.samplingConfig = samplingConfig;
        this.indexFactory = indexFactory;
        for (SpatialCRSSchemaIndex index : indexMap.values()) {
            index.takeOnline();
        }
    }

    @Override
    public void drop() throws IOException {
        FusionIndexBase.forAll(SpatialCRSSchemaIndex::drop, this.indexMap.values());
        this.indexMap.clear();
    }

    @Override
    public IndexUpdater newUpdater(IndexUpdateMode mode) {
        return SpatialFusionIndexUpdater.updaterForAccessor(this.indexMap, this.indexId, this.indexFactory, this.descriptor);
    }

    @Override
    public void force(IOLimiter ioLimiter) throws IOException {
        FusionIndexBase.forAll(spatialCRSSchemaIndex -> spatialCRSSchemaIndex.force(ioLimiter), this.indexMap.values());
    }

    @Override
    public void refresh() {
    }

    @Override
    public void close() throws IOException {
        FusionIndexBase.forAll(SpatialCRSSchemaIndex::close, this.indexMap.values());
    }

    @Override
    public IndexReader newReader() {
        HashMap<CoordinateReferenceSystem, IndexReader> indexReaders = new HashMap<CoordinateReferenceSystem, IndexReader>();
        for (Map.Entry<CoordinateReferenceSystem, SpatialCRSSchemaIndex> index : this.indexMap.entrySet()) {
            indexReaders.put(index.getKey(), index.getValue().newReader(this.samplingConfig, this.descriptor));
        }
        return new SpatialFusionIndexReader(indexReaders, this.descriptor);
    }

    @Override
    public BoundedIterable<Long> newAllEntriesReader() {
        final ArrayList<BoundedIterable<Long>> allEntriesReader = new ArrayList<BoundedIterable<Long>>();
        for (SpatialCRSSchemaIndex index : this.indexMap.values()) {
            allEntriesReader.add(index.newAllEntriesReader());
        }
        return new BoundedIterable<Long>(){

            @Override
            public long maxCount() {
                return allEntriesReader.stream().map(BoundedIterable::maxCount).reduce(0L, (acc, e) -> {
                    if (acc == -1L || e == -1L) {
                        return -1L;
                    }
                    return acc + e;
                });
            }

            @Override
            public void close() throws Exception {
                FusionIndexBase.forAll(AutoCloseable::close, allEntriesReader);
            }

            @Override
            public Iterator<Long> iterator() {
                return new CombiningIterable((Iterable)allEntriesReader).iterator();
            }
        };
    }

    @Override
    public ResourceIterator<File> snapshotFiles() throws IOException {
        ArrayList<ResourceIterator<File>> snapshotFiles = new ArrayList<ResourceIterator<File>>();
        for (SpatialCRSSchemaIndex index : this.indexMap.values()) {
            snapshotFiles.add(index.snapshotFiles());
        }
        return Iterators.concatResourceIterators(snapshotFiles.iterator());
    }

    @Override
    public void verifyDeferredConstraints(PropertyAccessor propertyAccessor) throws IndexEntryConflictException, IOException {
    }

    @Override
    public boolean isDirty() {
        return this.indexMap.values().stream().anyMatch(SpatialCRSSchemaIndex::wasDirtyOnStartup);
    }
}

