/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.util.Arrays;
import org.neo4j.collection.primitive.PrimitiveLongResourceCollections;
import org.neo4j.collection.primitive.PrimitiveLongResourceIterator;
import org.neo4j.graphdb.Resource;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.kernel.api.exceptions.index.IndexNotApplicableKernelException;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.api.schema.BridgingIndexProgressor;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexBase;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexProvider;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexSampler;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.IndexSampler;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

class FusionIndexReader
extends FusionIndexBase<IndexReader>
implements IndexReader {
    private final SchemaIndexDescriptor descriptor;

    FusionIndexReader(IndexReader[] readers, FusionIndexProvider.Selector selector, SchemaIndexDescriptor descriptor) {
        super(readers, selector);
        this.descriptor = descriptor;
    }

    public void close() {
        FusionIndexReader.forAll(Resource::close, this.instances);
    }

    @Override
    public long countIndexedNodes(long nodeId, Value ... propertyValues) {
        return ((IndexReader)this.selector.select(this.instances, propertyValues)).countIndexedNodes(nodeId, propertyValues);
    }

    @Override
    public IndexSampler createSampler() {
        return new FusionIndexSampler(this.instancesAs(IndexSampler.class, IndexReader::createSampler));
    }

    @Override
    public PrimitiveLongResourceIterator query(IndexQuery ... predicates) throws IndexNotApplicableKernelException {
        if (predicates.length > 1) {
            return ((IndexReader[])this.instances)[4].query(predicates);
        }
        IndexQuery predicate = predicates[0];
        if (predicate instanceof IndexQuery.ExactPredicate) {
            IndexQuery.ExactPredicate exactPredicate = (IndexQuery.ExactPredicate)predicate;
            return ((IndexReader)this.selector.select(this.instances, exactPredicate.value())).query(predicates);
        }
        if (predicate instanceof IndexQuery.StringPrefixPredicate || predicate instanceof IndexQuery.StringSuffixPredicate || predicate instanceof IndexQuery.StringContainsPredicate) {
            return ((IndexReader[])this.instances)[0].query(predicate);
        }
        if (predicate instanceof IndexQuery.RangePredicate) {
            switch (predicate.valueGroup()) {
                case NUMBER: {
                    return ((IndexReader[])this.instances)[1].query(predicates);
                }
                case GEOMETRY: {
                    return ((IndexReader[])this.instances)[2].query(predicates);
                }
                case TEXT: {
                    return ((IndexReader[])this.instances)[0].query(predicates);
                }
                case DATE: 
                case LOCAL_DATE_TIME: 
                case ZONED_DATE_TIME: 
                case LOCAL_TIME: 
                case ZONED_TIME: 
                case DURATION: {
                    return ((IndexReader[])this.instances)[3].query(predicates);
                }
            }
        }
        if (predicate instanceof IndexQuery.ExistsPredicate) {
            PrimitiveLongResourceIterator[] converted = this.instancesAs(PrimitiveLongResourceIterator.class, reader -> reader.query(predicates));
            return PrimitiveLongResourceCollections.concat((PrimitiveLongResourceIterator[])converted);
        }
        return ((IndexReader[])this.instances)[4].query(predicates);
    }

    @Override
    public void query(IndexProgressor.NodeValueClient cursor, IndexOrder indexOrder, IndexQuery ... predicates) throws IndexNotApplicableKernelException {
        if (predicates.length > 1) {
            ((IndexReader[])this.instances)[4].query(cursor, indexOrder, predicates);
            return;
        }
        IndexQuery predicate = predicates[0];
        if (predicate instanceof IndexQuery.ExactPredicate) {
            IndexQuery.ExactPredicate exactPredicate = (IndexQuery.ExactPredicate)predicate;
            ((IndexReader)this.selector.select(this.instances, exactPredicate.value())).query(cursor, indexOrder, predicate);
            return;
        }
        if (predicate instanceof IndexQuery.StringPrefixPredicate || predicate instanceof IndexQuery.StringSuffixPredicate || predicate instanceof IndexQuery.StringContainsPredicate) {
            ((IndexReader[])this.instances)[0].query(cursor, indexOrder, predicate);
            return;
        }
        if (predicate instanceof IndexQuery.RangePredicate) {
            switch (predicate.valueGroup()) {
                case NUMBER: {
                    ((IndexReader[])this.instances)[1].query(cursor, indexOrder, predicates);
                    return;
                }
                case GEOMETRY: {
                    ((IndexReader[])this.instances)[2].query(cursor, indexOrder, predicates);
                    return;
                }
                case TEXT: {
                    ((IndexReader[])this.instances)[0].query(cursor, indexOrder, predicates);
                    return;
                }
                case DATE: 
                case LOCAL_DATE_TIME: 
                case ZONED_DATE_TIME: 
                case LOCAL_TIME: 
                case ZONED_TIME: 
                case DURATION: {
                    ((IndexReader[])this.instances)[3].query(cursor, indexOrder, predicates);
                    return;
                }
            }
        }
        if (predicate instanceof IndexQuery.ExistsPredicate) {
            if (indexOrder != IndexOrder.NONE) {
                throw new UnsupportedOperationException(String.format("Tried to query index with unsupported order %s. Supported orders for query %s are %s.", indexOrder, Arrays.toString(predicates), IndexOrder.NONE));
            }
            BridgingIndexProgressor multiProgressor = new BridgingIndexProgressor(cursor, this.descriptor.schema().getPropertyIds());
            cursor.initialize(this.descriptor, multiProgressor, predicates);
            for (IndexReader reader : (IndexReader[])this.instances) {
                reader.query(multiProgressor, indexOrder, predicate);
            }
            return;
        }
        ((IndexReader[])this.instances)[4].query(cursor, indexOrder, predicates);
    }

    @Override
    public boolean hasFullValuePrecision(IndexQuery ... predicates) {
        if (predicates.length > 1) {
            return false;
        }
        IndexQuery predicate = predicates[0];
        if (predicate instanceof IndexQuery.ExactPredicate) {
            Value value = ((IndexQuery.ExactPredicate)predicate).value();
            return ((IndexReader)this.selector.select(this.instances, value)).hasFullValuePrecision(predicates);
        }
        if (predicate instanceof IndexQuery.RangePredicate && predicate.valueGroup() == ValueGroup.NUMBER) {
            return ((IndexReader[])this.instances)[1].hasFullValuePrecision(predicates);
        }
        return false;
    }
}

