/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.SchemaLayout;
import org.neo4j.kernel.impl.index.schema.ZonedDateTimeSchemaKey;

class ZonedDateTimeLayout
extends SchemaLayout<ZonedDateTimeSchemaKey> {
    private static final int ZONE_ID_FLAG = 0x1000000;
    private static final int ZONE_ID_MASK = 65535;

    ZonedDateTimeLayout() {
        super("Tdt", 0, 1);
    }

    public ZonedDateTimeSchemaKey newKey() {
        return new ZonedDateTimeSchemaKey();
    }

    public ZonedDateTimeSchemaKey copyKey(ZonedDateTimeSchemaKey key, ZonedDateTimeSchemaKey into) {
        into.epochSecondUTC = key.epochSecondUTC;
        into.nanoOfSecond = key.nanoOfSecond;
        into.zoneId = key.zoneId;
        into.zoneOffsetMinutes = key.zoneOffsetMinutes;
        into.setEntityId(key.getEntityId());
        into.setCompareId(key.getCompareId());
        return into;
    }

    public int keySize(ZonedDateTimeSchemaKey key) {
        return 24;
    }

    public void writeKey(PageCursor cursor, ZonedDateTimeSchemaKey key) {
        cursor.putLong(key.epochSecondUTC);
        cursor.putInt(key.nanoOfSecond);
        if (key.zoneId >= 0) {
            cursor.putInt(key.zoneId | 0x1000000);
        } else {
            cursor.putInt(key.zoneOffsetMinutes & 0xFFFF);
        }
        cursor.putLong(key.getEntityId());
    }

    public void readKey(PageCursor cursor, ZonedDateTimeSchemaKey into, int keySize) {
        into.epochSecondUTC = cursor.getLong();
        into.nanoOfSecond = cursor.getInt();
        int encodedZone = cursor.getInt();
        if (this.isZoneId(encodedZone)) {
            into.zoneId = this.asZoneId(encodedZone);
            into.zoneOffsetMinutes = 0;
        } else {
            into.zoneId = (short)-1;
            into.zoneOffsetMinutes = this.asZoneOffset(encodedZone);
        }
        into.setEntityId(cursor.getLong());
    }

    private int asZoneOffset(int encodedZone) {
        return (short)encodedZone;
    }

    private short asZoneId(int encodedZone) {
        return (short)(encodedZone & 0xFFFF);
    }

    private boolean isZoneId(int encodedZone) {
        return (encodedZone & 0x1000000) != 0;
    }
}

