/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.CapabilityValidator;
import org.neo4j.kernel.impl.index.schema.NativeSchemaIndexReader;
import org.neo4j.kernel.impl.index.schema.NativeSchemaKey;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class TemporalIndexPartReader<KEY extends NativeSchemaKey>
extends NativeSchemaIndexReader<KEY, NativeSchemaValue> {
    TemporalIndexPartReader(GBPTree<KEY, NativeSchemaValue> tree, Layout<KEY, NativeSchemaValue> layout, IndexSamplingConfig samplingConfig, SchemaIndexDescriptor descriptor) {
        super(tree, layout, samplingConfig, descriptor);
    }

    @Override
    protected void validateQuery(IndexOrder indexOrder, IndexQuery[] predicates) {
        if (predicates.length != 1) {
            throw new UnsupportedOperationException();
        }
        CapabilityValidator.validateQuery(IndexCapability.NO_CAPABILITY, indexOrder, predicates);
    }

    @Override
    protected boolean initializeRangeForQuery(KEY treeKeyFrom, KEY treeKeyTo, IndexQuery[] predicates) {
        IndexQuery predicate = predicates[0];
        switch (predicate.type()) {
            case exists: {
                ((NativeSchemaKey)((Object)treeKeyFrom)).initAsLowest();
                ((NativeSchemaKey)((Object)treeKeyTo)).initAsHighest();
                break;
            }
            case exact: {
                IndexQuery.ExactPredicate exactPredicate = (IndexQuery.ExactPredicate)predicate;
                ((NativeSchemaKey)((Object)treeKeyFrom)).from(Long.MIN_VALUE, exactPredicate.value());
                ((NativeSchemaKey)((Object)treeKeyTo)).from(Long.MAX_VALUE, exactPredicate.value());
                break;
            }
            case range: {
                IndexQuery.RangePredicate rangePredicate = (IndexQuery.RangePredicate)predicate;
                this.initFromForRange(rangePredicate, treeKeyFrom);
                this.initToForRange(rangePredicate, treeKeyTo);
                break;
            }
            default: {
                throw new IllegalArgumentException("IndexQuery of type " + predicate.type() + " is not supported.");
            }
        }
        return false;
    }

    private void initFromForRange(IndexQuery.RangePredicate rangePredicate, KEY treeKeyFrom) {
        Value fromValue = rangePredicate.fromValue();
        if (fromValue == Values.NO_VALUE) {
            ((NativeSchemaKey)((Object)treeKeyFrom)).initAsLowest();
        } else {
            ((NativeSchemaKey)((Object)treeKeyFrom)).from(rangePredicate.fromInclusive() ? Long.MIN_VALUE : Long.MAX_VALUE, fromValue);
            ((NativeSchemaKey)((Object)treeKeyFrom)).setCompareId(true);
        }
    }

    private void initToForRange(IndexQuery.RangePredicate rangePredicate, KEY treeKeyTo) {
        Value toValue = rangePredicate.toValue();
        if (toValue == Values.NO_VALUE) {
            ((NativeSchemaKey)((Object)treeKeyTo)).initAsHighest();
        } else {
            ((NativeSchemaKey)((Object)treeKeyTo)).from(rangePredicate.toInclusive() ? Long.MAX_VALUE : Long.MIN_VALUE, toValue);
            ((NativeSchemaKey)((Object)treeKeyTo)).setCompareId(true);
        }
    }

    @Override
    public boolean hasFullValuePrecision(IndexQuery ... predicates) {
        return true;
    }
}

