/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Arrays;
import org.neo4j.kernel.impl.index.schema.NativeSchemaKey;
import org.neo4j.string.UTF8;
import org.neo4j.values.storable.UTF8StringValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class StringSchemaKey
extends NativeSchemaKey<StringSchemaKey> {
    static final int ENTITY_ID_SIZE = 8;
    private boolean ignoreLength;
    byte[] bytes;

    StringSchemaKey() {
    }

    int size() {
        return 8 + this.bytes.length;
    }

    @Override
    protected Value assertCorrectType(Value value) {
        if (!Values.isTextValue((Object)value)) {
            throw new IllegalArgumentException("Key layout does only support strings, tried to create key from " + value);
        }
        return value;
    }

    @Override
    public Value asValue() {
        return this.bytes == null ? Values.NO_VALUE : Values.utf8Value((byte[])this.bytes);
    }

    @Override
    void initValueAsLowest() {
        this.bytes = null;
    }

    @Override
    void initValueAsHighest() {
        this.bytes = null;
    }

    void initAsPrefixLow(String prefix) {
        this.writeString(prefix);
        this.setEntityId(Long.MIN_VALUE);
        this.setCompareId(true);
    }

    void initAsPrefixHigh(String prefix) {
        this.writeString(prefix);
        this.setEntityId(Long.MAX_VALUE);
        this.setCompareId(true);
        this.ignoreLength = true;
    }

    private boolean isHighest() {
        return this.getCompareId() && this.getEntityId() == Long.MAX_VALUE && this.bytes == null;
    }

    @Override
    int compareValueTo(StringSchemaKey other) {
        if (this.bytes != other.bytes) {
            if (this.bytes == null) {
                return this.isHighest() ? 1 : -1;
            }
            if (other.bytes == null) {
                return other.isHighest() ? -1 : 1;
            }
        } else {
            return 0;
        }
        try {
            return UTF8StringValue.codePointByteArrayCompare((byte[])this.bytes, (byte[])other.bytes, (this.ignoreLength || other.ignoreLength ? 1 : 0) != 0);
        }
        catch (Exception e) {
            return StringSchemaKey.byteArrayCompare(this.bytes, other.bytes);
        }
    }

    private static int byteArrayCompare(byte[] a, byte[] b) {
        assert (a != null && b != null) : "Null arrays not supported.";
        if (a == b) {
            return 0;
        }
        int length = Math.min(a.length, b.length);
        for (int i = 0; i < length; ++i) {
            int compare = Byte.compare(a[i], b[i]);
            if (compare == 0) continue;
            return compare;
        }
        return Integer.compare(a.length, b.length);
    }

    public String toString() {
        return String.format("value=%s,entityId=%d,bytes=%s", this.asValue(), this.getEntityId(), Arrays.toString(this.bytes));
    }

    public void writeString(String value) {
        this.bytes = UTF8.encode((String)value);
    }

    public void writeString(char value) {
        this.writeString(String.valueOf(value));
    }
}

