/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.SchemaLayout;
import org.neo4j.kernel.impl.index.schema.StringSchemaKey;

class StringLayout
extends SchemaLayout<StringSchemaKey> {
    StringLayout() {
        super("USI", 0, 1);
    }

    public StringSchemaKey newKey() {
        return new StringSchemaKey();
    }

    public StringSchemaKey copyKey(StringSchemaKey key, StringSchemaKey into) {
        into.bytes = (byte[])key.bytes.clone();
        into.setEntityId(key.getEntityId());
        into.setCompareId(key.getCompareId());
        return into;
    }

    public int keySize(StringSchemaKey key) {
        return key.size();
    }

    public void writeKey(PageCursor cursor, StringSchemaKey key) {
        cursor.putLong(key.getEntityId());
        cursor.putBytes(key.bytes);
    }

    public void readKey(PageCursor cursor, StringSchemaKey into, int keySize) {
        if (keySize < 8) {
            into.bytes = null;
            return;
        }
        into.setEntityId(cursor.getLong());
        into.bytes = new byte[keySize - 8];
        cursor.getBytes(into.bytes);
    }

    @Override
    public boolean fixedSize() {
        return false;
    }

    public String toString() {
        return String.format("%s[version:%d.%d, identifier:%d]", ((Object)((Object)this)).getClass().getSimpleName(), this.majorVersion(), this.minorVersion(), this.identifier());
    }

    @Override
    int compareValue(StringSchemaKey o1, StringSchemaKey o2) {
        return o1.compareValueTo(o2);
    }
}

