/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Arrays;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurve;
import org.neo4j.kernel.impl.index.schema.NativeSchemaKey;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class SpatialSchemaKey
extends NativeSchemaKey<SpatialSchemaKey> {
    static final int SIZE = 16;
    long rawValueBits;
    CoordinateReferenceSystem crs;
    SpaceFillingCurve curve;

    SpatialSchemaKey(CoordinateReferenceSystem crs, SpaceFillingCurve curve) {
        this.crs = crs;
        this.curve = curve;
    }

    public NumberValue asValue() {
        return (NumberValue)Values.of((Object)this.rawValueBits);
    }

    @Override
    void initValueAsLowest() {
        double[] limit = new double[this.crs.getDimension()];
        Arrays.fill(limit, Double.NEGATIVE_INFINITY);
        this.writePoint(this.crs, limit);
    }

    @Override
    void initValueAsHighest() {
        double[] limit = new double[this.crs.getDimension()];
        Arrays.fill(limit, Double.NEGATIVE_INFINITY);
        limit[0] = Double.POSITIVE_INFINITY;
        this.writePoint(this.crs, limit);
    }

    public void fromDerivedValue(long entityId, long derivedValue) {
        this.rawValueBits = derivedValue;
        this.setEntityId(entityId);
        this.setCompareId(true);
    }

    @Override
    int compareValueTo(SpatialSchemaKey other) {
        return Long.compare(this.rawValueBits, other.rawValueBits);
    }

    @Override
    protected Value assertCorrectType(Value value) {
        if (!Values.isGeometryValue((Value)value)) {
            throw new IllegalArgumentException("Key layout does only support geometries, tried to create key from " + value);
        }
        return value;
    }

    public void writePoint(CoordinateReferenceSystem crs, double[] coordinate) {
        this.rawValueBits = this.curve.derivedValueFor(coordinate);
    }

    public String toString() {
        return String.format("rawValue=%d,value=%s,entityId=%d", this.rawValueBits, "unknown", this.getEntityId());
    }
}

