/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import org.neo4j.concurrent.WorkSync;
import org.neo4j.gis.spatial.index.Envelope;
import org.neo4j.gis.spatial.index.curves.HilbertSpaceFillingCurve2D;
import org.neo4j.gis.spatial.index.curves.HilbertSpaceFillingCurve3D;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurve;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.BoundedIterable;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.ConflictDetectingValueMerger;
import org.neo4j.kernel.impl.index.schema.FailureHeaderWriter;
import org.neo4j.kernel.impl.index.schema.NativeAllEntriesReader;
import org.neo4j.kernel.impl.index.schema.NativeSchemaIndex;
import org.neo4j.kernel.impl.index.schema.NativeSchemaIndexHeaderWriter;
import org.neo4j.kernel.impl.index.schema.NativeSchemaIndexPopulator;
import org.neo4j.kernel.impl.index.schema.NativeSchemaIndexUpdater;
import org.neo4j.kernel.impl.index.schema.NativeSchemaIndexes;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.kernel.impl.index.schema.SpatialLayout;
import org.neo4j.kernel.impl.index.schema.SpatialSchemaIndexReader;
import org.neo4j.kernel.impl.index.schema.SpatialSchemaKey;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.values.storable.CoordinateReferenceSystem;

public class SpatialCRSSchemaIndex {
    private final File indexFile;
    private final PageCache pageCache;
    private final CoordinateReferenceSystem crs;
    private final FileSystemAbstraction fs;
    private final RecoveryCleanupWorkCollector recoveryCleanupWorkCollector;
    private final SpaceFillingCurveConfiguration configuration;
    private final SpaceFillingCurve curve;
    private State state;
    private boolean dropped;
    private byte[] failureBytes;
    private SpatialSchemaKey treeKey;
    private NativeSchemaValue treeValue;
    private SpatialLayout layout;
    private NativeSchemaIndexUpdater<SpatialSchemaKey, NativeSchemaValue> singleUpdater;
    private NativeSchemaIndex<SpatialSchemaKey, NativeSchemaValue> schemaIndex;
    private WorkSync<NativeSchemaIndexPopulator.IndexUpdateApply<SpatialSchemaKey, NativeSchemaValue>, NativeSchemaIndexPopulator.IndexUpdateWork<SpatialSchemaKey, NativeSchemaValue>> additionsWorkSync;
    private WorkSync<NativeSchemaIndexPopulator.IndexUpdateApply<SpatialSchemaKey, NativeSchemaValue>, NativeSchemaIndexPopulator.IndexUpdateWork<SpatialSchemaKey, NativeSchemaValue>> updatesWorkSync;

    public SpatialCRSSchemaIndex(SchemaIndexDescriptor descriptor, IndexDirectoryStructure directoryStructure, CoordinateReferenceSystem crs, long indexId, PageCache pageCache, FileSystemAbstraction fs, IndexProvider.Monitor monitor, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, SpaceFillingCurveConfiguration configuration, int maxBits) {
        this.crs = crs;
        this.pageCache = pageCache;
        this.fs = fs;
        this.recoveryCleanupWorkCollector = recoveryCleanupWorkCollector;
        this.configuration = configuration;
        IndexProvider.Descriptor crsDescriptor = new IndexProvider.Descriptor(Integer.toString(crs.getTable().getTableId()), Integer.toString(crs.getCode()));
        IndexDirectoryStructure indexDir = IndexDirectoryStructure.directoriesBySubProvider(directoryStructure).forProvider(crsDescriptor);
        this.indexFile = new File(indexDir.directoryForIndex(indexId), "index-" + indexId);
        if (crs.getDimension() == 2) {
            this.curve = new HilbertSpaceFillingCurve2D(SpatialCRSSchemaIndex.envelopeFromCRS(crs), Math.min(30, maxBits / 2));
        } else if (crs.getDimension() == 3) {
            this.curve = new HilbertSpaceFillingCurve3D(SpatialCRSSchemaIndex.envelopeFromCRS(crs), Math.min(20, maxBits / 3));
        } else {
            throw new IllegalArgumentException("Cannot create spatial index with other than 2D or 3D coordinate reference system: " + crs);
        }
        this.state = State.INIT;
        this.layout = new SpatialLayout(crs, this.curve);
        this.treeKey = this.layout.newKey();
        this.treeValue = this.layout.newValue();
        this.schemaIndex = new NativeSchemaIndex(pageCache, fs, this.indexFile, this.layout, monitor, descriptor, indexId);
    }

    public void startPopulation() throws IOException {
        if (this.state == State.INIT) {
            this.create();
        }
        if (this.state != State.POPULATING) {
            throw new IllegalStateException("Failed to start populating index.");
        }
    }

    public void takeOnline() throws IOException {
        if (!this.indexExists()) {
            throw new IOException("Index file does not exist.");
        }
        if (this.state == State.INIT || this.state == State.POPULATED) {
            if (this.state == State.INIT) {
                this.schemaIndex.instantiateTree(this.recoveryCleanupWorkCollector, GBPTree.NO_HEADER_WRITER);
            }
            this.online();
        }
        if (this.state != State.ONLINE) {
            throw new IllegalStateException("Failed to bring index online.");
        }
    }

    public IndexUpdater updaterWithCreate(boolean populating) throws IOException {
        if (populating) {
            if (this.state == State.INIT) {
                this.create();
            }
            return this.newPopulatingUpdater();
        }
        if (this.state == State.INIT) {
            this.create();
            this.finishPopulation(true);
            this.online();
        }
        return this.newUpdater();
    }

    public void close() throws IOException {
        this.schemaIndex.closeTree();
    }

    public BoundedIterable<Long> newAllEntriesReader() {
        return new NativeAllEntriesReader(this.schemaIndex.tree, this.layout);
    }

    public IndexReader newReader(IndexSamplingConfig samplingConfig, SchemaIndexDescriptor descriptor) {
        this.schemaIndex.assertOpen();
        return new SpatialSchemaIndexReader(this.schemaIndex.tree, this.layout, samplingConfig, descriptor, this.configuration);
    }

    public ResourceIterator<File> snapshotFiles() {
        return Iterators.asResourceIterator((Iterator)Iterators.iterator((Object)this.indexFile));
    }

    public void force(IOLimiter ioLimiter) throws IOException {
        this.schemaIndex.tree.checkpoint(ioLimiter);
    }

    public boolean wasDirtyOnStartup() {
        return this.schemaIndex.tree.wasDirtyOnStartup();
    }

    private IndexUpdater newUpdater() {
        this.schemaIndex.assertOpen();
        try {
            return this.singleUpdater.initialize((Writer<SpatialSchemaKey, NativeSchemaValue>)this.schemaIndex.tree.writer());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public synchronized void finishPopulation(boolean populationCompletedSuccessfully) throws IOException {
        assert (this.state == State.POPULATING);
        if (populationCompletedSuccessfully && this.failureBytes != null) {
            throw new IllegalStateException("Can't mark index as online after it has been marked as failure");
        }
        if (populationCompletedSuccessfully) {
            this.schemaIndex.assertOpen();
            this.markTreeAsOnline();
            this.state = State.POPULATED;
        } else {
            this.assertNotDropped();
            this.ensureTreeInstantiated();
            this.markTreeAsFailed();
            this.state = State.FAILED;
        }
    }

    public void add(Collection<IndexEntryUpdate<?>> updates) throws IOException {
        this.applyWithWorkSync(this.additionsWorkSync, updates);
    }

    private IndexUpdater newPopulatingUpdater() {
        return new IndexUpdater(){
            private boolean closed;
            private final Collection<IndexEntryUpdate<?>> updates = new ArrayList();

            @Override
            public void process(IndexEntryUpdate<?> update) {
                this.assertOpen();
                this.updates.add(update);
            }

            @Override
            public void close() throws IOException {
                SpatialCRSSchemaIndex.this.applyWithWorkSync((WorkSync<NativeSchemaIndexPopulator.IndexUpdateApply<SpatialSchemaKey, NativeSchemaValue>, NativeSchemaIndexPopulator.IndexUpdateWork<SpatialSchemaKey, NativeSchemaValue>>)SpatialCRSSchemaIndex.this.updatesWorkSync, this.updates);
                this.closed = true;
            }

            private void assertOpen() {
                if (this.closed) {
                    throw new IllegalStateException("Updater has been closed");
                }
            }
        };
    }

    public synchronized void drop() throws IOException {
        try {
            this.schemaIndex.closeTree();
            this.schemaIndex.gbpTreeFileUtil.deleteFileIfPresent(this.indexFile);
        }
        finally {
            this.dropped = true;
            this.state = State.INIT;
        }
    }

    public void markAsFailed(String failure) {
        this.failureBytes = failure.getBytes(StandardCharsets.UTF_8);
        this.state = State.FAILED;
    }

    public boolean indexExists() {
        return this.fs.fileExists(this.indexFile);
    }

    public String readPopulationFailure() throws IOException {
        return NativeSchemaIndexes.readFailureMessage(this.pageCache, this.indexFile, this.layout);
    }

    public InternalIndexState readState() throws IOException {
        return NativeSchemaIndexes.readState(this.pageCache, this.indexFile, this.layout);
    }

    private synchronized void create() throws IOException {
        assert (this.state == State.INIT);
        this.schemaIndex.gbpTreeFileUtil.deleteFileIfPresent(this.indexFile);
        this.schemaIndex.instantiateTree(RecoveryCleanupWorkCollector.IMMEDIATE, new NativeSchemaIndexHeaderWriter(2));
        this.additionsWorkSync = new WorkSync(new NativeSchemaIndexPopulator.IndexUpdateApply<SpatialSchemaKey, NativeSchemaValue>(this.schemaIndex.tree, this.treeKey, this.treeValue, new ConflictDetectingValueMerger(this.schemaIndex.descriptor.type() == SchemaIndexDescriptor.Type.GENERAL)));
        this.updatesWorkSync = new WorkSync(new NativeSchemaIndexPopulator.IndexUpdateApply<SpatialSchemaKey, NativeSchemaValue>(this.schemaIndex.tree, this.treeKey, this.treeValue, new ConflictDetectingValueMerger(true)));
        this.state = State.POPULATING;
    }

    private void online() throws IOException {
        assert (this.state == State.POPULATED || this.state == State.INIT);
        this.singleUpdater = new NativeSchemaIndexUpdater<SpatialSchemaKey, NativeSchemaValue>(this.treeKey, this.treeValue);
        this.state = State.ONLINE;
    }

    private void applyWithWorkSync(WorkSync<NativeSchemaIndexPopulator.IndexUpdateApply<SpatialSchemaKey, NativeSchemaValue>, NativeSchemaIndexPopulator.IndexUpdateWork<SpatialSchemaKey, NativeSchemaValue>> workSync, Collection<? extends IndexEntryUpdate<?>> updates) throws IOException {
        try {
            workSync.apply(new NativeSchemaIndexPopulator.IndexUpdateWork(updates));
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
    }

    private void markTreeAsOnline() throws IOException {
        this.schemaIndex.tree.checkpoint(IOLimiter.unlimited(), pc -> pc.putByte((byte)1));
    }

    private void markTreeAsFailed() throws IOException {
        if (this.failureBytes == null) {
            this.failureBytes = new byte[0];
        }
        this.schemaIndex.tree.checkpoint(IOLimiter.unlimited(), (Consumer)new FailureHeaderWriter(this.failureBytes));
    }

    private void assertNotDropped() {
        if (this.dropped) {
            throw new IllegalStateException("Populator has already been dropped.");
        }
    }

    private void ensureTreeInstantiated() throws IOException {
        if (this.schemaIndex.tree == null) {
            this.schemaIndex.instantiateTree(RecoveryCleanupWorkCollector.IGNORE, GBPTree.NO_HEADER_WRITER);
        }
    }

    static Envelope envelopeFromCRS(CoordinateReferenceSystem crs) {
        Pair indexEnvelope = crs.getIndexEnvelope();
        return new Envelope((double[])indexEnvelope.first(), (double[])indexEnvelope.other());
    }

    public static interface Supplier {
        public SpatialCRSSchemaIndex get(SchemaIndexDescriptor var1, Map<CoordinateReferenceSystem, SpatialCRSSchemaIndex> var2, long var3, CoordinateReferenceSystem var5);
    }

    private static enum State {
        INIT,
        POPULATING,
        POPULATED,
        ONLINE,
        FAILED;

    }
}

