/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import org.neo4j.concurrent.Work;
import org.neo4j.concurrent.WorkSync;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.DefaultNonUniqueIndexSampler;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.sampling.NonUniqueIndexSampler;
import org.neo4j.kernel.impl.api.index.sampling.UniqueIndexSampler;
import org.neo4j.kernel.impl.index.schema.ConflictDetectingValueMerger;
import org.neo4j.kernel.impl.index.schema.DeferredConflictCheckingIndexUpdater;
import org.neo4j.kernel.impl.index.schema.FailureHeaderWriter;
import org.neo4j.kernel.impl.index.schema.NativeSchemaIndex;
import org.neo4j.kernel.impl.index.schema.NativeSchemaIndexHeaderWriter;
import org.neo4j.kernel.impl.index.schema.NativeSchemaIndexUpdater;
import org.neo4j.kernel.impl.index.schema.NativeSchemaKey;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.kernel.impl.index.schema.SamplingUtil;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.IndexSample;

abstract class NativeSchemaIndexPopulator<KEY extends NativeSchemaKey, VALUE extends NativeSchemaValue>
extends NativeSchemaIndex<KEY, VALUE>
implements IndexPopulator {
    static final byte BYTE_FAILED = 0;
    static final byte BYTE_ONLINE = 1;
    static final byte BYTE_POPULATING = 2;
    private final KEY treeKey;
    private final VALUE treeValue;
    private final UniqueIndexSampler uniqueSampler;
    private final NonUniqueIndexSampler nonUniqueSampler;
    final IndexSamplingConfig samplingConfig;
    private WorkSync<IndexUpdateApply<KEY, VALUE>, IndexUpdateWork<KEY, VALUE>> additionsWorkSync;
    private WorkSync<IndexUpdateApply<KEY, VALUE>, IndexUpdateWork<KEY, VALUE>> updatesWorkSync;
    private byte[] failureBytes;
    private boolean dropped;
    private boolean closed;

    NativeSchemaIndexPopulator(PageCache pageCache, FileSystemAbstraction fs, File storeFile, Layout<KEY, VALUE> layout, IndexProvider.Monitor monitor, SchemaIndexDescriptor descriptor, long indexId, IndexSamplingConfig samplingConfig) {
        super(pageCache, fs, storeFile, layout, monitor, descriptor, indexId);
        this.treeKey = (NativeSchemaKey)((Object)layout.newKey());
        this.treeValue = (NativeSchemaValue)layout.newValue();
        this.samplingConfig = samplingConfig;
        switch (descriptor.type()) {
            case GENERAL: {
                this.uniqueSampler = null;
                this.nonUniqueSampler = new DefaultNonUniqueIndexSampler(samplingConfig.sampleSizeLimit());
                break;
            }
            case UNIQUE: {
                this.uniqueSampler = new UniqueIndexSampler();
                this.nonUniqueSampler = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected index type " + (Object)((Object)descriptor.type()));
            }
        }
    }

    public void clear() throws IOException {
        this.gbpTreeFileUtil.deleteFileIfPresent(this.storeFile);
    }

    @Override
    public synchronized void create() throws IOException {
        this.assertNotDropped();
        this.assertNotClosed();
        this.gbpTreeFileUtil.deleteFileIfPresent(this.storeFile);
        this.instantiateTree(RecoveryCleanupWorkCollector.IMMEDIATE, new NativeSchemaIndexHeaderWriter(2));
        boolean compareIds = this.descriptor.type() == SchemaIndexDescriptor.Type.GENERAL;
        this.additionsWorkSync = new WorkSync(new IndexUpdateApply<KEY, VALUE>(this.tree, this.treeKey, this.treeValue, new ConflictDetectingValueMerger(compareIds)));
        this.updatesWorkSync = new WorkSync(new IndexUpdateApply<KEY, VALUE>(this.tree, this.treeKey, this.treeValue, new ConflictDetectingValueMerger(true)));
    }

    @Override
    public synchronized void drop() throws IOException {
        try {
            this.closeTree();
            this.gbpTreeFileUtil.deleteFileIfPresent(this.storeFile);
        }
        finally {
            this.dropped = true;
            this.closed = true;
        }
    }

    @Override
    public void add(Collection<? extends IndexEntryUpdate<?>> updates) throws IOException, IndexEntryConflictException {
        this.applyWithWorkSync(this.additionsWorkSync, updates);
    }

    @Override
    public void verifyDeferredConstraints(PropertyAccessor propertyAccessor) {
    }

    @Override
    public IndexUpdater newPopulatingUpdater(PropertyAccessor accessor) {
        IndexUpdater updater = new IndexUpdater(){
            private boolean closed;
            private final Collection<IndexEntryUpdate<?>> updates = new ArrayList();

            @Override
            public void process(IndexEntryUpdate<?> update) {
                this.assertOpen();
                this.updates.add(update);
            }

            @Override
            public void close() throws IOException, IndexEntryConflictException {
                NativeSchemaIndexPopulator.this.applyWithWorkSync(NativeSchemaIndexPopulator.this.updatesWorkSync, this.updates);
                this.closed = true;
            }

            private void assertOpen() {
                if (this.closed) {
                    throw new IllegalStateException("Updater has been closed");
                }
            }
        };
        if (this.descriptor.type() == SchemaIndexDescriptor.Type.UNIQUE) {
            updater = new DeferredConflictCheckingIndexUpdater(updater, this::newReader, this.descriptor);
        }
        return updater;
    }

    abstract IndexReader newReader();

    @Override
    public synchronized void close(boolean populationCompletedSuccessfully) throws IOException {
        if (populationCompletedSuccessfully && this.failureBytes != null) {
            throw new IllegalStateException("Can't mark index as online after it has been marked as failure");
        }
        try {
            if (populationCompletedSuccessfully) {
                this.assertPopulatorOpen();
                this.markTreeAsOnline();
            } else {
                this.assertNotDropped();
                this.ensureTreeInstantiated();
                this.markTreeAsFailed();
            }
        }
        finally {
            this.closeTree();
            this.closed = true;
        }
    }

    private void applyWithWorkSync(WorkSync<IndexUpdateApply<KEY, VALUE>, IndexUpdateWork<KEY, VALUE>> workSync, Collection<? extends IndexEntryUpdate<?>> updates) throws IOException, IndexEntryConflictException {
        try {
            workSync.apply(new IndexUpdateWork(updates));
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof IndexEntryConflictException) {
                throw (IndexEntryConflictException)cause;
            }
            throw new IOException(cause);
        }
    }

    private void assertNotDropped() {
        if (this.dropped) {
            throw new IllegalStateException("Populator has already been dropped.");
        }
    }

    private void assertNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("Populator has already been closed.");
        }
    }

    @Override
    public void markAsFailed(String failure) {
        this.failureBytes = failure.getBytes(StandardCharsets.UTF_8);
    }

    private void ensureTreeInstantiated() throws IOException {
        if (this.tree == null) {
            this.instantiateTree(RecoveryCleanupWorkCollector.IGNORE, GBPTree.NO_HEADER_WRITER);
        }
    }

    private void assertPopulatorOpen() {
        if (this.tree == null) {
            throw new IllegalStateException("Populator has already been closed.");
        }
    }

    private void markTreeAsFailed() throws IOException {
        if (this.failureBytes == null) {
            this.failureBytes = new byte[0];
        }
        this.tree.checkpoint(IOLimiter.unlimited(), (Consumer)new FailureHeaderWriter(this.failureBytes));
    }

    private void markTreeAsOnline() throws IOException {
        this.tree.checkpoint(IOLimiter.unlimited(), pc -> pc.putByte((byte)1));
    }

    @Override
    public void includeSample(IndexEntryUpdate<?> update) {
        switch (this.descriptor.type()) {
            case GENERAL: {
                this.nonUniqueSampler.include(SamplingUtil.encodedStringValuesForSampling(update.values()));
                break;
            }
            case UNIQUE: {
                this.uniqueSampler.increment(1L);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected index type " + (Object)((Object)this.descriptor.type()));
            }
        }
    }

    @Override
    public IndexSample sampleResult() {
        switch (this.descriptor.type()) {
            case GENERAL: {
                return this.nonUniqueSampler.result();
            }
            case UNIQUE: {
                return this.uniqueSampler.result();
            }
        }
        throw new IllegalArgumentException("Unexpected index type " + (Object)((Object)this.descriptor.type()));
    }

    static class IndexUpdateWork<KEY extends NativeSchemaKey, VALUE extends NativeSchemaValue>
    implements Work<IndexUpdateApply<KEY, VALUE>, IndexUpdateWork<KEY, VALUE>> {
        private final Collection<? extends IndexEntryUpdate<?>> updates;

        IndexUpdateWork(Collection<? extends IndexEntryUpdate<?>> updates) {
            this.updates = updates;
        }

        public IndexUpdateWork<KEY, VALUE> combine(IndexUpdateWork work) {
            ArrayList combined = new ArrayList(this.updates);
            combined.addAll(work.updates);
            return new IndexUpdateWork<KEY, VALUE>(combined);
        }

        public void apply(IndexUpdateApply<KEY, VALUE> indexUpdateApply) throws Exception {
            indexUpdateApply.process(this.updates);
        }
    }

    static class IndexUpdateApply<KEY extends NativeSchemaKey, VALUE extends NativeSchemaValue> {
        private final GBPTree<KEY, VALUE> tree;
        private final KEY treeKey;
        private final VALUE treeValue;
        private final ConflictDetectingValueMerger<KEY, VALUE> conflictDetectingValueMerger;

        IndexUpdateApply(GBPTree<KEY, VALUE> tree, KEY treeKey, VALUE treeValue, ConflictDetectingValueMerger<KEY, VALUE> conflictDetectingValueMerger) {
            this.tree = tree;
            this.treeKey = treeKey;
            this.treeValue = treeValue;
            this.conflictDetectingValueMerger = conflictDetectingValueMerger;
        }

        void process(Iterable<? extends IndexEntryUpdate<?>> indexEntryUpdates) throws Exception {
            try (Writer writer = this.tree.writer();){
                for (IndexEntryUpdate<?> indexEntryUpdate : indexEntryUpdates) {
                    NativeSchemaIndexUpdater.processUpdate(this.treeKey, this.treeValue, indexEntryUpdate, writer, this.conflictDetectingValueMerger);
                }
            }
        }
    }
}

