/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.NativeSchemaIndexes;
import org.neo4j.kernel.impl.index.schema.NativeSchemaKey;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;

abstract class NativeIndexProvider<KEY extends NativeSchemaKey, VALUE extends NativeSchemaValue>
extends IndexProvider {
    protected final PageCache pageCache;
    protected final FileSystemAbstraction fs;
    protected final IndexProvider.Monitor monitor;
    protected final RecoveryCleanupWorkCollector recoveryCleanupWorkCollector;
    protected final boolean readOnly;

    protected NativeIndexProvider(IndexProvider.Descriptor descriptor, int priority, IndexDirectoryStructure.Factory directoryStructureFactory, PageCache pageCache, FileSystemAbstraction fs, IndexProvider.Monitor monitor, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, boolean readOnly) {
        super(descriptor, priority, directoryStructureFactory);
        this.pageCache = pageCache;
        this.fs = fs;
        this.monitor = monitor;
        this.recoveryCleanupWorkCollector = recoveryCleanupWorkCollector;
        this.readOnly = readOnly;
    }

    abstract Layout<KEY, VALUE> layout(SchemaIndexDescriptor var1);

    @Override
    public IndexPopulator getPopulator(long indexId, SchemaIndexDescriptor descriptor, IndexSamplingConfig samplingConfig) {
        if (this.readOnly) {
            throw new UnsupportedOperationException("Can't create populator for read only index");
        }
        File storeFile = this.nativeIndexFileFromIndexId(indexId);
        return this.newIndexPopulator(storeFile, this.layout(descriptor), descriptor, indexId, samplingConfig);
    }

    protected abstract IndexPopulator newIndexPopulator(File var1, Layout<KEY, VALUE> var2, SchemaIndexDescriptor var3, long var4, IndexSamplingConfig var6);

    @Override
    public IndexAccessor getOnlineAccessor(long indexId, SchemaIndexDescriptor descriptor, IndexSamplingConfig samplingConfig) throws IOException {
        File storeFile = this.nativeIndexFileFromIndexId(indexId);
        return this.newIndexAccessor(storeFile, this.layout(descriptor), descriptor, indexId, samplingConfig);
    }

    protected abstract IndexAccessor newIndexAccessor(File var1, Layout<KEY, VALUE> var2, SchemaIndexDescriptor var3, long var4, IndexSamplingConfig var6) throws IOException;

    @Override
    public String getPopulationFailure(long indexId, SchemaIndexDescriptor descriptor) throws IllegalStateException {
        try {
            String failureMessage = NativeSchemaIndexes.readFailureMessage(this.pageCache, this.nativeIndexFileFromIndexId(indexId), this.layout(descriptor));
            if (failureMessage == null) {
                throw new IllegalStateException("Index " + indexId + " isn't failed");
            }
            return failureMessage;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public InternalIndexState getInitialState(long indexId, SchemaIndexDescriptor descriptor) {
        try {
            return NativeSchemaIndexes.readState(this.pageCache, this.nativeIndexFileFromIndexId(indexId), this.layout(descriptor));
        }
        catch (IOException e) {
            this.monitor.failedToOpenIndex(indexId, descriptor, "Requesting re-population.", e);
            return InternalIndexState.POPULATING;
        }
    }

    @Override
    public StoreMigrationParticipant storeMigrationParticipant(FileSystemAbstraction fs, PageCache pageCache) {
        return StoreMigrationParticipant.NOT_PARTICIPATING;
    }

    private File nativeIndexFileFromIndexId(long indexId) {
        return new File(this.directoryStructure().directoryForIndex(indexId), NativeIndexProvider.indexFileName(indexId));
    }

    private static String indexFileName(long indexId) {
        return "index-" + indexId;
    }
}

