/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.kernel.impl.index.schema.NativeSchemaKey;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.Value;

class LocalDateTimeSchemaKey
extends NativeSchemaKey<LocalDateTimeSchemaKey> {
    static final int SIZE = 20;
    int nanoOfSecond;
    long epochSecond;

    LocalDateTimeSchemaKey() {
    }

    @Override
    public Value asValue() {
        return LocalDateTimeValue.localDateTime((long)this.epochSecond, (long)this.nanoOfSecond);
    }

    @Override
    public void initValueAsLowest() {
        this.epochSecond = Long.MIN_VALUE;
        this.nanoOfSecond = Integer.MIN_VALUE;
    }

    @Override
    public void initValueAsHighest() {
        this.epochSecond = Long.MAX_VALUE;
        this.nanoOfSecond = Integer.MAX_VALUE;
    }

    @Override
    public int compareValueTo(LocalDateTimeSchemaKey other) {
        int compare = Long.compare(this.epochSecond, other.epochSecond);
        if (compare == 0) {
            compare = Integer.compare(this.nanoOfSecond, other.nanoOfSecond);
        }
        return compare;
    }

    public String toString() {
        return String.format("value=%s,entityId=%d,epochSecond=%d,nanoOfSecond=%d", this.asValue(), this.getEntityId(), this.epochSecond, this.nanoOfSecond);
    }

    public void writeLocalDateTime(long epochSecond, int nano) {
        this.nanoOfSecond = nano;
        this.epochSecond = epochSecond;
    }

    @Override
    protected Value assertCorrectType(Value value) {
        if (!(value instanceof LocalDateTimeValue)) {
            throw new IllegalArgumentException("Key layout does only support LocalDateTimeValue, tried to create key from " + value);
        }
        return value;
    }
}

