/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.Arrays;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;

public class DefaultIndexReference
implements IndexReference {
    private final boolean unique;
    private final int label;
    private final int[] properties;

    private DefaultIndexReference(boolean unique, int label, int[] properties) {
        this.unique = unique;
        this.label = label;
        this.properties = properties;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public int label() {
        return this.label;
    }

    public int[] properties() {
        return this.properties;
    }

    public static IndexReference unique(int label, int ... properties) {
        return new DefaultIndexReference(true, label, properties);
    }

    public static IndexReference general(int label, int ... properties) {
        return new DefaultIndexReference(false, label, properties);
    }

    public static IndexReference fromDescriptor(SchemaIndexDescriptor descriptor) {
        boolean unique = descriptor.type() == SchemaIndexDescriptor.Type.UNIQUE;
        LabelSchemaDescriptor schema = descriptor.schema();
        return new DefaultIndexReference(unique, schema.getLabelId(), schema.getPropertyIds());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof IndexReference)) {
            return false;
        }
        IndexReference that = (IndexReference)o;
        return this.unique == that.isUnique() && this.label == that.label() && Arrays.equals(this.properties, that.properties());
    }

    public int hashCode() {
        int result = this.unique ? 1 : 0;
        result = 31 * result + this.label;
        result = 31 * result + Arrays.hashCode(this.properties);
        return result;
    }

    public String toString() {
        return String.format("Index(%d:%s)", this.label, Arrays.toString(this.properties));
    }
}

